/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.items.ore.Ore;
import exnihilocreatio.json.JsonHelper;
import exnihilocreatio.texturing.Color;
import exnihilocreatio.util.ItemInfo;
import java.lang.reflect.Type;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lexnihilocreatio/json/CustomOreJson;", "Lcom/google/gson/JsonDeserializer;", "Lexnihilocreatio/items/ore/Ore;", "Lcom/google/gson/JsonSerializer;", "()V", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "serialize", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "exnihilocreatio"})
public final class CustomOreJson
implements JsonDeserializer<Ore>,
JsonSerializer<Ore> {
    public static final CustomOreJson INSTANCE;

    @NotNull
    public JsonElement serialize(@NotNull Ore src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        Intrinsics.checkParameterIsNotNull((Object)typeOfSrc, (String)"typeOfSrc");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JsonObject obj = new JsonObject();
        obj.addProperty("name", src.getName());
        obj.add("color", context.serialize((Object)src.getColor(), (Type)((Object)Color.class)));
        if (src.getResult() != null) {
            obj.add("ingot", context.serialize((Object)src.getResult(), (Type)((Object)ItemInfo.class)));
        }
        if (src.getDustResult() != null) {
            obj.add("dust", context.serialize((Object)src.getDustResult(), (Type)((Object)ItemInfo.class)));
        }
        if (src.getOredictName() != null) {
            obj.addProperty("oredictName", src.getOredictName());
        }
        if (src.getTranslations() != null) {
            obj.add("translations", context.serialize(src.getTranslations(), new TypeToken<HashMap<String, String>>(){}.getType()));
        }
        return (JsonElement)obj;
    }

    @NotNull
    public Ore deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) throws JsonParseException {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)typeOfT, (String)"typeOfT");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JsonHelper helper = new JsonHelper(json);
        String name = helper.getString("name");
        Color color = (Color)context.deserialize(json.getAsJsonObject().get("color"), (Type)((Object)Color.class));
        ItemInfo ingot = json.getAsJsonObject().has("result") ? (ItemInfo)context.deserialize(json.getAsJsonObject().get("result"), (Type)((Object)ItemInfo.class)) : (json.getAsJsonObject().has("ingot") ? (ItemInfo)context.deserialize(json.getAsJsonObject().get("ingot"), (Type)((Object)ItemInfo.class)) : null);
        ItemInfo dust = json.getAsJsonObject().has("dust") ? (ItemInfo)context.deserialize(json.getAsJsonObject().get("dust"), (Type)((Object)ItemInfo.class)) : null;
        HashMap translations = null;
        if (json.isJsonObject() && json.getAsJsonObject().has("translations")) {
            translations = (HashMap)context.deserialize(json.getAsJsonObject().get("translations"), new TypeToken<HashMap<String, String>>(){}.getType());
        }
        String oredictName = null;
        if (json.isJsonObject() && json.getAsJsonObject().has("oredictName")) {
            oredictName = helper.getString("oredictName");
        }
        String string = name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        Color color2 = color;
        Intrinsics.checkExpressionValueIsNotNull((Object)color2, (String)"color");
        return new Ore(string, color2, ingot, dust, translations, oredictName);
    }

    private CustomOreJson() {
    }

    static {
        CustomOreJson customOreJson;
        INSTANCE = customOreJson = new CustomOreJson();
    }
}

