/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.modules.tconstruct.tools;

import exnihilocreatio.items.tools.IHammer;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.StringUtils;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;

public class SledgeHammer
extends AoeToolCore
implements IHammer {
    public SledgeHammer() {
        this(PartMaterialType.handle((IToolPart)TinkerTools.toolRod), PartMaterialType.head((IToolPart)TinkerTools.hammerHead), PartMaterialType.extra((IToolPart)TinkerTools.binding));
    }

    public SledgeHammer(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
        this.addCategory(new Category[]{Category.HARVEST});
        this.setHarvestLevel("crushing", 0);
        this.setRegistryName("hammer_tconstruct");
        this.func_77655_b("exnihilocreatio.hammer_tconstruct");
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState state) {
        if (StringUtils.func_151246_b((String)toolClass) || state == null) {
            return -1;
        }
        if (this.isEffective(state)) {
            return this.getMiningLevel(stack);
        }
        return super.getHarvestLevel(stack, toolClass, player, state);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            this.addDefaultSubItems((List)subItems, new Material[]{null, null, null});
        }
    }

    public boolean isEffective(IBlockState state) {
        return ExNihiloRegistryManager.HAMMER_REGISTRY.isRegistered(state);
    }

    public boolean canHarvestBlock(@Nonnull IBlockState state, ItemStack stack) {
        return !ToolHelper.isBroken((ItemStack)stack) && ExNihiloRegistryManager.HAMMER_REGISTRY.getRewards(state).stream().anyMatch(it -> it.getMiningLevel() <= this.getMiningLevel(stack));
    }

    public float damagePotential() {
        return 1.1f;
    }

    public double attackSpeed() {
        return 1.1f;
    }

    public float knockback() {
        return 1.3f;
    }

    protected ToolNBT buildTagData(List<Material> materials) {
        return this.buildDefaultTag(materials);
    }

    @Override
    public int getMiningLevel(ItemStack stack) {
        if (ToolHelper.isBroken((ItemStack)stack)) {
            return -1;
        }
        return ToolHelper.getHarvestLevelStat((ItemStack)stack);
    }

    @Override
    public boolean isHammer(ItemStack stack) {
        return stack.func_77973_b() instanceof SledgeHammer && !ToolHelper.isBroken((ItemStack)stack);
    }
}

