/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.api.registries.ICrookRegistry;
import exnihilocreatio.compatibility.jei.crook.CrookRecipe;
import exnihilocreatio.json.CustomIngredientJson;
import exnihilocreatio.json.CustomItemStackJson;
import exnihilocreatio.registries.ingredient.IngredientUtil;
import exnihilocreatio.registries.ingredient.OreIngredientStoring;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.registries.prefab.BaseRegistryMap;
import exnihilocreatio.registries.types.CrookReward;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.ItemUtil;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import org.jetbrains.annotations.NotNull;

public class CrookRegistry
extends BaseRegistryMap<Ingredient, List<CrookReward>>
implements ICrookRegistry {
    public CrookRegistry() {
        super(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemStack.class, (Object)CustomItemStackJson.INSTANCE).registerTypeAdapter(Ingredient.class, (Object)CustomIngredientJson.INSTANCE).registerTypeAdapter(OreIngredientStoring.class, (Object)CustomIngredientJson.INSTANCE).enableComplexMapKeySerialization().create(), new TypeToken<Map<Ingredient, List<CrookReward>>>(){}.getType(), ExNihiloRegistryManager.CROOK_DEFAULT_REGISTRY_PROVIDERS);
    }

    @Override
    public void register(@NotNull Block block, int meta, @NotNull ItemStack reward, float chance, float fortuneChance) {
        this.register(new BlockInfo(block, meta), reward, chance, fortuneChance);
    }

    @Override
    public void register(@NotNull IBlockState state, @NotNull ItemStack reward, float chance, float fortuneChance) {
        this.register(new BlockInfo(state), reward, chance, fortuneChance);
    }

    @Override
    public void register(@NotNull BlockInfo info, @NotNull ItemStack reward, float chance, float fortuneChance) {
        this.register(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{info.getItemStack()}), new CrookReward(reward, chance, fortuneChance));
    }

    @Override
    public void register(@NotNull String name, @NotNull ItemStack reward, float chance, float fortuneChance) {
        this.register((Ingredient)new OreIngredientStoring(name), new CrookReward(reward, chance, fortuneChance));
    }

    @Override
    public void register(@NotNull Ingredient ingredient, @NotNull CrookReward reward) {
        Ingredient search = ((Map)this.registry).keySet().stream().filter(entry -> IngredientUtil.ingredientEquals(entry, ingredient)).findAny().orElse(null);
        if (search != null) {
            ((List)((Map)this.registry).get(search)).add(reward);
        } else {
            NonNullList drops = NonNullList.func_191196_a();
            drops.add((Object)reward);
            ((Map)this.registry).put(ingredient, drops);
        }
    }

    public NonNullList<CrookReward> getRewards(Ingredient ingredient) {
        NonNullList drops = NonNullList.func_191196_a();
        ((Map)this.registry).entrySet().stream().filter(entry -> entry.getKey() == ingredient).forEach(entry -> drops.addAll((Collection)entry.getValue()));
        return drops;
    }

    @Override
    public boolean isRegistered(@NotNull Block block) {
        ItemStack stack = new ItemStack(block);
        return ((Map)this.registry).keySet().stream().anyMatch(ingredient -> ingredient.test((Object)stack));
    }

    public boolean isRegistered(IBlockState state) {
        return this.isRegistered(new BlockInfo(state));
    }

    public boolean isRegistered(BlockInfo stackInfo) {
        return ((Map)this.registry).keySet().stream().anyMatch(ingredient -> ingredient.test((Object)stackInfo.getItemStack()));
    }

    @Override
    @NotNull
    public List<CrookReward> getRewards(@NotNull IBlockState state) {
        BlockInfo info = new BlockInfo(state);
        ArrayList<CrookReward> list = new ArrayList<CrookReward>();
        ((Map)this.registry).entrySet().stream().filter(ingredient -> ((Ingredient)ingredient.getKey()).test((Object)info.getItemStack())).forEach(ingredient -> list.addAll((Collection)ingredient.getValue()));
        return list;
    }

    @Override
    public void registerEntriesFromJSON(FileReader fr) {
        HashMap gsonInput = (HashMap)this.gson.fromJson((Reader)fr, new TypeToken<HashMap<String, NonNullList<CrookReward>>>(){}.getType());
        gsonInput.forEach((key, value) -> {
            Ingredient ingredient = IngredientUtil.parseFromString(key);
            if (ingredient != null) {
                List list = (List)((Map)this.registry).getOrDefault(ingredient, NonNullList.func_191196_a());
                list.addAll(value);
                ((Map)this.registry).put(ingredient, list);
            }
        });
    }

    @Override
    public List<CrookRecipe> getRecipeList() {
        LinkedList recipes = Lists.newLinkedList();
        for (Ingredient ingredient : ((Map)this.getRegistry()).keySet()) {
            if (ingredient == null) continue;
            List rawOutputs = this.getRewards(ingredient).stream().map(CrookReward::getStack).collect(Collectors.toList());
            ArrayList<ItemStack> allOutputs = new ArrayList<ItemStack>();
            for (ItemStack raw : rawOutputs) {
                boolean alreadyexists = false;
                for (ItemStack all : allOutputs) {
                    if (!ItemUtil.areStacksEquivalent(all, raw)) continue;
                    alreadyexists = true;
                    break;
                }
                if (alreadyexists) continue;
                allOutputs.add(raw);
            }
            List<ItemStack> inputs = Arrays.asList(ingredient.func_193365_a());
            for (int i = 0; i < allOutputs.size(); i += 21) {
                List<ItemStack> outputs = allOutputs.subList(i, Math.min(i + 21, allOutputs.size()));
                recipes.add(new CrookRecipe(inputs, outputs));
            }
        }
        return recipes;
    }
}

