/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.api.registries.ICrucibleRegistry;
import exnihilocreatio.compatibility.jei.crucible.CrucibleRecipe;
import exnihilocreatio.json.CustomBlockInfoJson;
import exnihilocreatio.json.CustomIngredientJson;
import exnihilocreatio.json.CustomMeltableJson;
import exnihilocreatio.registries.ingredient.IngredientUtil;
import exnihilocreatio.registries.ingredient.OreIngredientStoring;
import exnihilocreatio.registries.manager.IDefaultRecipeProvider;
import exnihilocreatio.registries.registries.prefab.BaseRegistryMap;
import exnihilocreatio.registries.types.Meltable;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.LogUtil;
import exnihilocreatio.util.StackInfo;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.jetbrains.annotations.NotNull;

public class CrucibleRegistry
extends BaseRegistryMap<Ingredient, Meltable>
implements ICrucibleRegistry {
    public CrucibleRegistry(List<? extends IDefaultRecipeProvider> defaultRecipeProviders) {
        super(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(BlockInfo.class, (Object)CustomBlockInfoJson.INSTANCE).registerTypeAdapter(Ingredient.class, (Object)CustomIngredientJson.INSTANCE).registerTypeAdapter(OreIngredientStoring.class, (Object)CustomIngredientJson.INSTANCE).registerTypeAdapter(Meltable.class, (Object)CustomMeltableJson.INSTANCE).enableComplexMapKeySerialization().create(), new TypeToken<Map<Ingredient, Meltable>>(){}.getType(), defaultRecipeProviders);
    }

    @Override
    public void register(@NotNull StackInfo item, @NotNull Fluid fluid, int amount) {
        this.register(item.getItemStack(), fluid, amount);
    }

    @Override
    public void register(@NotNull StackInfo item, @NotNull Meltable meltable) {
        this.register(item.getItemStack(), meltable);
    }

    @Override
    public void register(@NotNull String name, @NotNull Fluid fluid, int amount, @NotNull BlockInfo block) {
        this.register(name, new Meltable(fluid.getName(), amount, block));
    }

    @Override
    public void register(@NotNull ItemStack stack, @NotNull Fluid fluid, int amount) {
        this.register(stack, new Meltable(fluid.getName(), amount));
    }

    @Override
    public void register(@NotNull ItemStack stack, @NotNull Meltable meltable) {
        if (stack.func_190926_b() || !FluidRegistry.isFluidRegistered((String)meltable.getFluid())) {
            return;
        }
        if (((Map)this.registry).keySet().stream().anyMatch(ingredient -> ingredient.test((Object)stack))) {
            LogUtil.warn("Crucible entry for " + stack.func_82833_r() + " with meta " + stack.func_77960_j() + " already exists, skipping.");
        } else {
            this.register(CraftingHelper.getIngredient((Object)stack), meltable);
        }
    }

    @Override
    public void register(@NotNull String name, @NotNull Fluid fluid, int amount) {
        this.register(name, new Meltable(fluid.getName(), amount));
    }

    @Override
    public void register(@NotNull String name, @NotNull Meltable meltable) {
        OreIngredientStoring ingredient = new OreIngredientStoring(name);
        if (!FluidRegistry.isFluidRegistered((String)meltable.getFluid())) {
            return;
        }
        if (((Map)this.registry).keySet().stream().anyMatch(arg_0 -> CrucibleRegistry.lambda$register$1((Ingredient)ingredient, arg_0))) {
            LogUtil.error("Crucible Ore Entry for " + name + " already exists, skipping.");
        } else {
            ((Map)this.registry).put(ingredient, meltable);
        }
    }

    @Override
    public boolean canBeMelted(@NotNull ItemStack stack) {
        return ((Map)this.registry).keySet().stream().anyMatch(entry -> entry.test((Object)stack));
    }

    @Override
    public boolean canBeMelted(@NotNull StackInfo info) {
        return this.canBeMelted(info.getItemStack());
    }

    @Override
    @Nonnull
    public Meltable getMeltable(@NotNull ItemStack stack) {
        Ingredient ingredient = ((Map)this.registry).keySet().stream().filter(entry -> entry.test((Object)stack)).findFirst().orElse(null);
        if (ingredient != null) {
            return (Meltable)((Map)this.registry).get(ingredient);
        }
        return Meltable.Companion.getEMPTY();
    }

    @Override
    @Nonnull
    public Meltable getMeltable(@NotNull StackInfo info) {
        return this.getMeltable(info.getItemStack());
    }

    @Override
    @Nonnull
    public Meltable getMeltable(@NotNull Item item, int meta) {
        return this.getMeltable(new ItemStack(item, meta));
    }

    @Override
    protected void registerEntriesFromJSON(FileReader fr) {
        Map gsonInput = (Map)this.gson.fromJson((Reader)fr, new TypeToken<Map<String, Meltable>>(){}.getType());
        gsonInput.forEach((key, value) -> {
            Ingredient ingredient = IngredientUtil.parseFromString(key);
            if (((Map)this.registry).keySet().stream().anyMatch(entry -> IngredientUtil.ingredientEquals(ingredient, entry))) {
                LogUtil.error("Compost JSON Entry for " + Arrays.toString(ingredient.func_193365_a()) + " already exists, skipping.");
            }
            ((Map)this.registry).put(ingredient, value);
        });
    }

    @Override
    public Map<Ingredient, Meltable> getRegistry() {
        return (Map)this.registry;
    }

    @Override
    public List<CrucibleRecipe> getRecipeList() {
        LinkedList recipes = Lists.newLinkedList();
        HashMap outputMap = new HashMap();
        for (Map.Entry entry : this.getRegistry().entrySet()) {
            ArrayList<ItemStack> inputs;
            Fluid output = FluidRegistry.getFluid((String)((Meltable)entry.getValue()).getFluid());
            Ingredient ingredient = (Ingredient)entry.getKey();
            if (output == null || ingredient == null) continue;
            if (!outputMap.containsKey(output)) {
                inputs = new ArrayList<ItemStack>();
                outputMap.put(output, inputs);
            }
            inputs = new ArrayList();
            for (ItemStack match : ingredient.func_193365_a()) {
                if (match.func_190926_b() || match.func_77973_b() == null) continue;
                ItemStack input = match.func_77946_l();
                input.func_190920_e((int)Math.max(Math.ceil(1000 / ((Meltable)entry.getValue()).getAmount()), 1.0));
                inputs.add(input);
            }
            if (inputs.size() <= 0) continue;
            ((List)outputMap.get(output)).add(inputs);
        }
        for (Map.Entry entry : outputMap.entrySet()) {
            for (int i = 0; i < ((List)entry.getValue()).size(); i += 21) {
                recipes.add(new CrucibleRecipe((Fluid)entry.getKey(), ((List)entry.getValue()).subList(i, Math.min(i + 21, ((List)entry.getValue()).size()))));
            }
        }
        return recipes;
    }

    private static /* synthetic */ boolean lambda$register$1(Ingredient ingredient, Ingredient entry) {
        return IngredientUtil.ingredientEquals(entry, ingredient);
    }
}

