/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.api.registries.IHammerRegistry;
import exnihilocreatio.compatibility.jei.hammer.HammerRecipe;
import exnihilocreatio.json.CustomHammerRewardJson;
import exnihilocreatio.json.CustomIngredientJson;
import exnihilocreatio.json.CustomItemStackJson;
import exnihilocreatio.registries.ingredient.IngredientUtil;
import exnihilocreatio.registries.ingredient.OreIngredientStoring;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.registries.prefab.BaseRegistryMap;
import exnihilocreatio.registries.types.HammerReward;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.ItemUtil;
import exnihilocreatio.util.StackInfo;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.NotNull;

public class HammerRegistry
extends BaseRegistryMap<Ingredient, List<HammerReward>>
implements IHammerRegistry {
    public HammerRegistry() {
        super(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemStack.class, (Object)CustomItemStackJson.INSTANCE).registerTypeAdapter(Ingredient.class, (Object)CustomIngredientJson.INSTANCE).registerTypeAdapter(OreIngredientStoring.class, (Object)CustomIngredientJson.INSTANCE).registerTypeAdapter(HammerReward.class, (Object)CustomHammerRewardJson.INSTANCE).enableComplexMapKeySerialization().create(), new TypeToken<Map<Ingredient, List<HammerReward>>>(){}.getType(), ExNihiloRegistryManager.HAMMER_DEFAULT_REGISTRY_PROVIDERS);
    }

    @Override
    public void registerEntriesFromJSON(FileReader fr) {
        HashMap gsonInput = (HashMap)this.gson.fromJson((Reader)fr, new TypeToken<HashMap<String, ArrayList<HammerReward>>>(){}.getType());
        for (Map.Entry s : gsonInput.entrySet()) {
            Ingredient ingredient = IngredientUtil.parseFromString((String)s.getKey());
            Ingredient search = ((Map)this.registry).keySet().stream().filter(entry -> IngredientUtil.ingredientEquals(ingredient, entry)).findAny().orElse(null);
            if (search != null) {
                ((List)((Map)this.registry).get(search)).addAll((Collection)s.getValue());
                continue;
            }
            NonNullList drops = NonNullList.func_191196_a();
            drops.addAll((Collection)s.getValue());
            ((Map)this.registry).put(ingredient, drops);
        }
    }

    @Override
    public void register(@NotNull IBlockState state, @NotNull ItemStack reward, int miningLevel, float chance, float fortuneChance) {
        this.register(new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)), new HammerReward(reward, miningLevel, chance, fortuneChance));
    }

    @Override
    public void register(@NotNull Block block, int meta, @NotNull ItemStack reward, int miningLevel, float chance, float fortuneChance) {
        this.register(new ItemStack(block, 1, meta), new HammerReward(reward, miningLevel, chance, fortuneChance));
    }

    @Override
    public void register(@NotNull StackInfo stackInfo, @NotNull ItemStack reward, int miningLevel, float chance, float fortuneChance) {
        this.register(stackInfo.getItemStack(), new HammerReward(reward, miningLevel, chance, fortuneChance));
    }

    @Override
    public void register(@NotNull ItemStack stack, @NotNull HammerReward reward) {
        if (stack.func_190926_b()) {
            return;
        }
        Ingredient ingredient = CraftingHelper.getIngredient((Object)stack);
        this.register(ingredient, reward);
    }

    @Override
    public void register(@NotNull String name, @NotNull ItemStack reward, int miningLevel, float chance, float fortuneChance) {
        OreIngredientStoring ingredient = new OreIngredientStoring(name);
        this.register((Ingredient)ingredient, new HammerReward(reward, miningLevel, chance, fortuneChance));
    }

    @Override
    public void register(@NotNull Ingredient ingredient, @NotNull HammerReward reward) {
        Ingredient search = ((Map)this.registry).keySet().stream().filter(entry -> IngredientUtil.ingredientEquals(ingredient, entry)).findAny().orElse(null);
        if (search != null) {
            ((List)((Map)this.registry).get(search)).add(reward);
        } else {
            NonNullList drops = NonNullList.func_191196_a();
            drops.add((Object)reward);
            ((Map)this.registry).put(ingredient, drops);
        }
    }

    @NotNull
    public NonNullList<ItemStack> getRewardDrops(@NotNull Random random, @NotNull IBlockState block, int miningLevel, int fortuneLevel) {
        NonNullList rewards = NonNullList.func_191196_a();
        for (HammerReward reward : this.getRewards(block)) {
            if (miningLevel < reward.getMiningLevel() || !(random.nextFloat() <= reward.getChance() + reward.getFortuneChance() * (float)fortuneLevel)) continue;
            rewards.add((Object)reward.getStack().func_77946_l());
        }
        return rewards;
    }

    @NotNull
    public NonNullList<HammerReward> getRewards(@NotNull IBlockState block) {
        return this.getRewards(new BlockInfo(block));
    }

    @NotNull
    public NonNullList<HammerReward> getRewards(@NotNull Block block, int meta) {
        return this.getRewards(new BlockInfo(block, meta));
    }

    @NotNull
    public NonNullList<HammerReward> getRewards(@NotNull BlockInfo stackInfo) {
        NonNullList drops = NonNullList.func_191196_a();
        if (stackInfo.isValid()) {
            ((Map)this.registry).entrySet().stream().filter(entry -> ((Ingredient)entry.getKey()).test((Object)stackInfo.getItemStack())).forEach(entry -> drops.addAll((Collection)entry.getValue()));
        }
        return drops;
    }

    @NotNull
    public NonNullList<HammerReward> getRewards(@NotNull Ingredient ingredient) {
        NonNullList drops = NonNullList.func_191196_a();
        ((Map)this.registry).entrySet().stream().filter(entry -> entry.getKey() == ingredient).forEach(entry -> drops.addAll((Collection)entry.getValue()));
        return drops;
    }

    @Override
    public boolean isRegistered(@NotNull IBlockState block) {
        return this.isRegistered(new BlockInfo(block));
    }

    @Override
    public boolean isRegistered(@NotNull Block block) {
        return this.isRegistered(new BlockInfo(block.func_176223_P()));
    }

    @Deprecated
    public boolean registered(Block block) {
        return this.isRegistered(new BlockInfo(block.func_176223_P()));
    }

    @Override
    public boolean isRegistered(@NotNull BlockInfo stackInfo) {
        return ((Map)this.registry).keySet().stream().anyMatch(ingredient -> ingredient.test((Object)stackInfo.getItemStack()));
    }

    @Deprecated
    public List<HammerReward> getRewards(IBlockState state, int miningLevel) {
        NonNullList drops = NonNullList.func_191196_a();
        BlockInfo block = new BlockInfo(state);
        ((Map)this.registry).entrySet().stream().filter(entry -> ((Ingredient)entry.getKey()).test((Object)block.getItemStack())).forEach(entry -> ((List)entry.getValue()).stream().filter(value -> value.getMiningLevel() <= miningLevel).forEach(arg_0 -> drops.add(arg_0)));
        return drops;
    }

    @Override
    public List<HammerRecipe> getRecipeList() {
        LinkedList hammerRecipes = Lists.newLinkedList();
        for (Ingredient ingredient : ((Map)this.getRegistry()).keySet()) {
            if (ingredient == null) continue;
            List rawOutputs = this.getRewards(ingredient).stream().map(HammerReward::getStack).collect(Collectors.toList());
            ArrayList<ItemStack> allOutputs = new ArrayList<ItemStack>();
            for (ItemStack raw : rawOutputs) {
                boolean alreadyexists = false;
                for (ItemStack all : allOutputs) {
                    if (!ItemUtil.areStacksEquivalent(all, raw)) continue;
                    alreadyexists = true;
                    break;
                }
                if (alreadyexists) continue;
                allOutputs.add(raw);
            }
            List<ItemStack> inputs = Arrays.asList(ingredient.func_193365_a());
            for (int i = 0; i < allOutputs.size(); i += 21) {
                List<ItemStack> outputs = allOutputs.subList(i, Math.min(i + 21, allOutputs.size()));
                hammerRecipes.add(new HammerRecipe(inputs, outputs));
            }
        }
        return hammerRecipes;
    }
}

