/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.util;

import exnihilocreatio.util.ItemInfo;
import exnihilocreatio.util.StackInfo;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockInfo
implements StackInfo {
    public static final BlockInfo EMPTY = new BlockInfo(ItemStack.field_190927_a);
    @Nonnull
    private IBlockState state;
    private boolean isWildcard = false;

    public BlockInfo(@Nonnull Block block) {
        this.state = BlockInfo.getStateFromMeta(block, 0);
        this.checkWildcard();
    }

    public BlockInfo(@Nonnull Block block, int meta) {
        this.state = BlockInfo.getStateFromMeta(block, meta);
        if (meta == -1 || meta == Short.MAX_VALUE) {
            this.isWildcard = true;
        } else {
            this.checkWildcard();
        }
    }

    public BlockInfo(@Nonnull IBlockState state) {
        this.state = state;
    }

    public BlockInfo(@Nonnull ItemStack stack) {
        this.state = BlockInfo.getStateFromMeta(Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77952_i());
        this.checkWildcard();
    }

    public BlockInfo(@Nonnull String string) {
        Block block;
        if (string.isEmpty() || string.length() < 2) {
            this.state = Blocks.field_150350_a.func_176223_P();
            this.isWildcard = true;
            return;
        }
        String[] split = string.split(":");
        int meta = 0;
        switch (split.length) {
            case 1: {
                block = Block.func_149684_b((String)("minecraft:" + split[0]));
                break;
            }
            case 2: {
                try {
                    meta = split[1].equals("*") ? -1 : Integer.parseInt(split[1]);
                    block = Block.func_149684_b((String)("minecraft:" + split[0]));
                    break;
                }
                catch (NumberFormatException e) {
                    meta = 0;
                    block = Block.func_149684_b((String)(split[0] + ":" + split[1]));
                    break;
                }
                catch (NullPointerException e) {
                    this.state = Blocks.field_150350_a.func_176223_P();
                    this.isWildcard = true;
                    return;
                }
            }
            case 3: {
                try {
                    meta = split[2].equals("*") ? -1 : Integer.parseInt(split[2]);
                    Block block2 = Block.func_149684_b((String)(split[0] + ":" + split[1]));
                    this.state = BlockInfo.getStateFromMeta(block2, meta);
                    this.isWildcard = meta == -1;
                }
                catch (NullPointerException | NumberFormatException e) {
                    this.state = Blocks.field_150350_a.func_176223_P();
                    this.isWildcard = true;
                }
                return;
            }
            default: {
                this.state = Blocks.field_150350_a.func_176223_P();
                this.isWildcard = true;
                return;
            }
        }
        if (block == null) {
            this.state = Blocks.field_150350_a.func_176223_P();
            this.isWildcard = true;
        } else if (meta == -1 || meta == Short.MAX_VALUE) {
            this.state = BlockInfo.getStateFromMeta(block, 0);
            this.isWildcard = true;
        } else {
            this.state = BlockInfo.getStateFromMeta(block, meta);
            this.checkWildcard();
        }
    }

    public static BlockInfo readFromNBT(NBTTagCompound tag) {
        Block item = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tag.func_74779_i("block")));
        int meta = tag.func_74762_e("meta");
        return item == null ? EMPTY : new BlockInfo(item, meta);
    }

    @Nonnull
    public static IBlockState getStateFromMeta(Block block, int meta) {
        try {
            return block.func_176203_a(meta);
        }
        catch (Exception e) {
            return block.func_176223_P();
        }
    }

    private void checkWildcard() {
        this.isWildcard = !Item.func_150898_a((Block)this.state.func_177230_c()).func_77614_k();
    }

    @Override
    public String toString() {
        int meta = this.getMeta();
        return ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.state.func_177230_c()) + (meta == 0 ? "" : ":" + meta);
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        Item item = Item.func_150898_a((Block)this.state.func_177230_c());
        return item == Items.field_190931_a ? ItemStack.field_190927_a : new ItemStack(item, 1, this.getMeta());
    }

    @Override
    public boolean hasBlock() {
        return true;
    }

    @Override
    @Nonnull
    public Block getBlock() {
        return this.state.func_177230_c();
    }

    @Override
    @Nonnull
    public IBlockState getBlockState() {
        return this.state;
    }

    @Override
    public int getMeta() {
        return this.isWildcard ? -1 : this.state.func_177230_c().func_176201_c(this.state);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("block", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.state.func_177230_c()).toString());
        tag.func_74768_a("meta", this.state.func_177230_c().func_176201_c(this.state));
        return tag;
    }

    @Override
    public boolean isValid() {
        return this.state != Blocks.field_150350_a.func_176223_P();
    }

    @Override
    public int hashCode() {
        return this.state.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this.isWildcard) {
            if (other instanceof BlockInfo) {
                return Block.func_149680_a((Block)this.state.func_177230_c(), (Block)((BlockInfo)other).getBlock());
            }
            if (other instanceof ItemInfo) {
                return Block.func_149680_a((Block)this.state.func_177230_c(), (Block)((ItemInfo)other).getBlock());
            }
            if (other instanceof ItemStack) {
                return Block.func_149680_a((Block)this.state.func_177230_c(), (Block)Block.func_149634_a((Item)((ItemStack)other).func_77973_b()));
            }
            if (other instanceof Block) {
                return Block.func_149680_a((Block)this.state.func_177230_c(), (Block)((Block)other));
            }
            if (other instanceof ItemBlock) {
                return Block.func_149680_a((Block)this.state.func_177230_c(), (Block)((ItemBlock)other).func_179223_d());
            }
        } else {
            if (other instanceof BlockInfo) {
                return this.state == ((BlockInfo)other).state;
            }
            if (other instanceof ItemInfo) {
                return this.state == ((ItemInfo)other).getBlockState();
            }
            if (other instanceof ItemStack) {
                return this.state == BlockInfo.getStateFromMeta(Block.func_149634_a((Item)((ItemStack)other).func_77973_b()), ((ItemStack)other).func_77952_i());
            }
            if (other instanceof Block) {
                return Block.func_149680_a((Block)this.state.func_177230_c(), (Block)((Block)other));
            }
            if (other instanceof ItemBlock) {
                return Block.func_149680_a((Block)this.state.func_177230_c(), (Block)((ItemBlock)other).func_179223_d());
            }
        }
        return false;
    }

    public boolean isWildcard() {
        return this.isWildcard;
    }
}

