/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.davidee.paintinggui.handler;

import com.mcf.davidee.paintinggui.mod.PaintingSelection;
import com.mcf.davidee.paintinggui.packet.CPacketPainting;
import com.mcf.davidee.paintinggui.wrapper.PaintingWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import subaraki.paintings.mod.entity.EntityNewPainting;
import subaraki.paintings.mod.network.CPacketSyncPaintingData;
import subaraki.paintings.mod.network.NetworkHandler;

public class PlacePaintingEventHandler {
    public PlacePaintingEventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPaintingPlaced(PlayerInteractEvent.RightClickBlock event) {
        ItemStack itemStack = event.getItemStack();
        if (itemStack.func_77973_b() == Items.field_151159_an) {
            EntityPlayer player = event.getEntityPlayer();
            EnumFacing face = event.getFace();
            BlockPos blockpos = event.getPos();
            BlockPos actualPos = blockpos.func_177972_a(face);
            World world = event.getWorld();
            boolean flag = false;
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                if (!face.equals((Object)facing)) continue;
                flag = true;
            }
            if (flag && player.func_175151_a(actualPos, face, itemStack)) {
                EntityNewPainting painting = new EntityNewPainting(world);
                painting.field_174860_b = face;
                painting.field_70177_z = face.func_185119_l();
                painting.func_70107_b(actualPos.func_177958_n(), blockpos.func_177956_o(), actualPos.func_177952_p());
                painting.updateBB();
                if (painting.func_70518_d()) {
                    event.getEntityPlayer().func_184609_a(EnumHand.MAIN_HAND);
                    if (!event.getEntityPlayer().func_184812_l_()) {
                        itemStack.func_190918_g(1);
                    }
                    if (!event.getWorld().field_72995_K) {
                        EntityPlayerMP playerMP = (EntityPlayerMP)event.getEntityPlayer();
                        painting.func_184523_o();
                        event.getWorld().func_72838_d((Entity)painting);
                        NetworkHandler.NETWORK.sendToAllAround((IMessage)new CPacketSyncPaintingData(painting), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), 48.0));
                        PaintingWrapper originalArt = PaintingWrapper.PAINTINGS.get(painting.art);
                        ArrayList<PaintingWrapper> validArts = new ArrayList<PaintingWrapper>();
                        for (PaintingWrapper art : PaintingWrapper.PAINTINGS.values()) {
                            painting.art = art.getTitle();
                            this.updatePaintingBoundingBox(painting);
                            if (!painting.func_70518_d()) continue;
                            validArts.add(art);
                        }
                        painting.art = originalArt.getTitle();
                        this.updatePaintingBoundingBox(painting);
                        PaintingWrapper[] validArtsArray = validArts.toArray(new PaintingWrapper[0]);
                        Arrays.sort(validArtsArray, PaintingSelection.ART_COMPARATOR);
                        String[] names = new String[validArtsArray.length];
                        for (int i = 0; i < validArtsArray.length; ++i) {
                            names[i] = validArtsArray[i].getTitle();
                        }
                        com.mcf.davidee.paintinggui.packet.NetworkHandler.NETWORK.sendTo((IMessage)new CPacketPainting(painting, names), playerMP);
                    }
                }
                event.setCanceled(true);
            }
        }
    }

    private void updatePaintingBoundingBox(EntityHanging painting) {
        if (painting.field_174860_b != null) {
            double hangX = (double)painting.func_174857_n().func_177958_n() + 0.5;
            double hangY = (double)painting.func_174857_n().func_177956_o() + 0.5;
            double hangZ = (double)painting.func_174857_n().func_177952_p() + 0.5;
            double offsetWidth = painting.func_82329_d() % 32 == 0 ? 0.5 : 0.0;
            double offsetHeight = painting.func_82330_g() % 32 == 0 ? 0.5 : 0.0;
            hangX -= (double)painting.field_174860_b.func_82601_c() * 0.46875;
            hangZ -= (double)painting.field_174860_b.func_82599_e() * 0.46875;
            EnumFacing enumfacing = painting.field_174860_b.func_176735_f();
            painting.field_70165_t = hangX += offsetWidth * (double)enumfacing.func_82601_c();
            painting.field_70163_u = hangY += offsetHeight;
            painting.field_70161_v = hangZ += offsetWidth * (double)enumfacing.func_82599_e();
            double widthX = painting.func_82329_d();
            double height = painting.func_82330_g();
            double widthZ = painting.func_82329_d();
            if (painting.field_174860_b.func_176740_k() == EnumFacing.Axis.Z) {
                widthZ = 1.0;
            } else {
                widthX = 1.0;
            }
            painting.func_174826_a(new AxisAlignedBB(hangX - (widthX /= 32.0), hangY - (height /= 32.0), hangZ - (widthZ /= 32.0), hangX + widthX, hangY + height, hangZ + widthZ));
        }
    }
}

