/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.mod;

import com.mcf.davidee.paintinggui.wrapper.PaintingWrapper;
import java.util.HashMap;
import net.minecraft.util.ResourceLocation;
import subaraki.paintings.mod.Paintings;

public class PaintingsPattern {
    public static PaintingsPattern instance = null;
    public ResourceLocation texture = null;
    public ResourceLocation errorTex = null;
    private String type = "subaraki:pattern";
    private String name = null;
    private String[] pattern = null;
    private HashMap<String, Size> key = null;
    private HashMap<Size, Integer> sizeCounts = new HashMap();

    public void parsePattern() {
        Integer width = this.pattern[0].length();
        Integer height = this.pattern.length;
        Integer count = 0;
        for (int offsetY = 0; offsetY < height; ++offsetY) {
            for (int offsetX = 0; offsetX < width; ++offsetX) {
                String symbol = this.pattern[offsetY].substring(offsetX, offsetX + 1);
                if (symbol.equals(" ")) continue;
                Size size = this.key.get(symbol);
                if (size != null) {
                    int sizeCount = this.sizeCounts.get(size) != null ? this.sizeCounts.get(size) : 0;
                    this.addPainting(sizeCount, size.width, size.height, offsetX, offsetY);
                    this.updatePattern(size.width, size.height, offsetX, offsetY);
                    this.sizeCounts.put(size, ++sizeCount);
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                    continue;
                }
                StringBuilder error = new StringBuilder();
                error.append(String.format("Error processing pattern at offset: %d, %d\n", offsetX, offsetY));
                Paintings.log.error((CharSequence)error);
            }
        }
        Paintings.log.info(String.format("%d paintings found in %s/%s.", count, this.type, this.name));
    }

    public Size getSize() {
        return new Size(this.pattern[0].length(), this.pattern.length);
    }

    private void addPainting(Integer sizeIndex, Integer sizeX, Integer sizeY, Integer offsetX, Integer offsetY) {
        String name = String.format("p++%dx%d#%d", sizeX, sizeY, sizeIndex);
        new PaintingWrapper(name, sizeX * 16, sizeY * 16, offsetX * 16, offsetY * 16).append();
        Paintings.log.info(String.format("Added %s at %d, %d.", name, offsetX, offsetY));
    }

    private void updatePattern(Integer sizeX, Integer sizeY, Integer offsetX, Integer offsetY) {
        if (this.pattern[offsetY].length() < offsetX + sizeX) {
            Paintings.log.warn("Added painting extends beyond pattern dimensions.");
            return;
        }
        for (int row = offsetY.intValue(); row < offsetY + sizeY; ++row) {
            byte[] rowBytes = this.pattern[row].getBytes();
            for (int column = offsetX.intValue(); column < offsetX + sizeX; ++column) {
                rowBytes[column] = 32;
            }
            this.pattern[row] = new String(rowBytes);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Pattern: " + this.type + "/" + this.name + "\n");
        for (int i = 0; i < this.pattern.length; ++i) {
            sb.append(String.format("    %s\n", this.pattern[i]));
        }
        sb.append(String.format("Key:\n    %s", this.key.toString()));
        return sb.toString();
    }

    public class Size {
        public Integer width;
        public Integer height;

        Size(Integer width, Integer height) {
            this.width = width;
            this.height = height;
        }

        public String toString() {
            return String.format("[%d, %d]", this.width, this.height);
        }
    }
}

