/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generator;

import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.generation.BOPGeneratorBase;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.world.GeneratorRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GeneratorWeighted
extends BOPGeneratorBase {
    private HashMap<String, IGenerator> generators = new HashMap();
    private HashMap<IGenerator, Integer> weights = new HashMap();

    public GeneratorWeighted() {
        this(1.0f);
    }

    public GeneratorWeighted(float amountPerChunk) {
        super(amountPerChunk);
    }

    public void add(String name, int weight, IGenerator entry) {
        if (this.generators.containsKey(name)) {
            throw new RuntimeException("A generator with name " + name + " already exists!");
        }
        if (weight < 1) {
            throw new IllegalArgumentException("Generator weight must be positive");
        }
        entry.setStage(GeneratorStage.PARENT);
        this.generators.put(name, entry);
        this.weights.put(entry, weight);
    }

    public void clear() {
        this.generators.clear();
        this.weights.clear();
    }

    public IGenerator getGenerator(String name) {
        return this.generators.get(name);
    }

    public void removeGenerator(String name) {
        IGenerator generator = this.generators.get(name);
        if (generator != null) {
            this.generators.remove(name);
            this.weights.remove(generator);
        }
    }

    public IGenerator getRandomGenerator(Random random) {
        if (this.weights.isEmpty()) {
            throw new RuntimeException("GeneratorWeighted has no child generators");
        }
        int totalWeight = 0;
        for (int weight : this.weights.values()) {
            totalWeight += weight;
        }
        int j = random.nextInt(totalWeight);
        for (Map.Entry<IGenerator, Integer> entry : this.weights.entrySet()) {
            if ((j -= entry.getValue().intValue()) >= 0) continue;
            return entry.getKey();
        }
        throw new RuntimeException("Shouldn't ever get here");
    }

    @Override
    public BlockPos getScatterY(World world, Random random, int x, int z) {
        return null;
    }

    @Override
    public void scatter(World world, Random random, BlockPos pos) {
        int amount = this.getAmountToScatter(random);
        for (int i = 0; i < amount; ++i) {
            this.getRandomGenerator(random).scatter(world, random, pos);
        }
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        return this.getRandomGenerator(random).generate(world, random, pos);
    }

    @Override
    public void configure(IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        IConfigObj confGenerators = conf.getObject("generators");
        if (confGenerators != null) {
            for (String name : confGenerators.getKeys()) {
                IConfigObj confCurrentGen = confGenerators.getObject(name);
                if (this.generators.containsKey(name)) {
                    IGenerator generator = this.getGenerator(name);
                    Integer weight = confCurrentGen.getInt("weight", this.weights.get(generator));
                    if (weight < 1) {
                        this.removeGenerator(name);
                        continue;
                    }
                    this.weights.put(generator, weight);
                    generator.configure(confCurrentGen);
                    continue;
                }
                Integer weight = confCurrentGen.getInt("weight", null);
                IGenerator generator = GeneratorRegistry.createGenerator(confCurrentGen);
                if (weight == null || generator == null) continue;
                this.add(name, weight, generator);
            }
        }
    }

    public static class Builder
    implements IGenerator.IGeneratorBuilder<GeneratorWeighted> {
        protected float amountPerChunk = 1.0f;

        public Builder amountPerChunk(float a) {
            this.amountPerChunk = a;
            return this;
        }

        @Override
        public GeneratorWeighted create() {
            return new GeneratorWeighted(this.amountPerChunk);
        }
    }
}

