/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generator.tree;

import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.world.generator.tree.GeneratorTreeBase;
import java.util.Random;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GeneratorBulbTree
extends GeneratorTreeBase {
    public GeneratorBulbTree(float amountPerChunk, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState log, IBlockState leaves, IBlockState vine, IBlockState hanging, IBlockState trunkFruit, IBlockState altLeaves, int minHeight, int maxHeight, GeneratorUtils.ScatterYMethod scatterYMethod) {
        super(amountPerChunk, placeOn, replace, log, leaves, vine, hanging, trunkFruit, altLeaves, minHeight, maxHeight, scatterYMethod);
    }

    public boolean setCocoa(World world, BlockPos pos, EnumFacing side) {
        IBlockState cocoaState = Blocks.field_150375_by.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)side);
        if (this.replace.matches(world, pos)) {
            world.func_175656_a(pos, cocoaState);
            return true;
        }
        return false;
    }

    public boolean checkSpace(World world, BlockPos pos, int baseHeight, int height) {
        for (int y = 0; y <= height; ++y) {
            int radius = y <= baseHeight ? 0 : 1;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos1 = pos.func_177982_a(x, y, z);
                    if (pos1.func_177956_o() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateBranch(World world, Random random, BlockPos pos, EnumFacing direction) {
        EnumFacing sideways = direction.func_176746_e();
        this.setLeaves(world, pos.func_177967_a(direction, 1));
        this.setLeaves(world, pos.func_177984_a().func_177967_a(direction, 1));
        if (random.nextInt(3) > 0) {
            this.setLeaves(world, pos.func_177984_a().func_177967_a(direction, 1).func_177967_a(sideways, 1));
        }
    }

    public void generateLeafLayer(World world, Random random, BlockPos pos) {
        for (EnumFacing direction : EnumFacing.Plane.HORIZONTAL) {
            this.generateBranch(world, random, pos, direction);
        }
        this.setLog(world, pos);
        this.setLog(world, pos.func_177984_a());
    }

    public void generateTop(World world, Random random, BlockPos pos, int topHeight) {
        for (int y = 0; y < topHeight; ++y) {
            int radius = topHeight - 1 - y;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (Math.abs(x) >= radius && Math.abs(z) >= radius && random.nextInt(2) != 0) continue;
                    this.setLeaves(world, pos.func_177982_a(x, y, z));
                }
            }
            if (y < topHeight - 1) {
                this.setLog(world, pos.func_177982_a(0, y, 0));
                continue;
            }
            this.setLeaves(world, pos.func_177982_a(0, y, 0));
        }
    }

    public boolean func_180709_b(World world, Random random, BlockPos startPos) {
        int i;
        while (startPos.func_177956_o() > 1 && world.func_175623_d(startPos) || world.func_180495_p(startPos).func_177230_c().isLeaves(world.func_180495_p(startPos), (IBlockAccess)world, startPos)) {
            startPos = startPos.func_177977_b();
        }
        if (!this.placeOn.matches(world, startPos)) {
            return false;
        }
        int height = GeneratorUtils.nextIntBetween(random, this.minHeight, this.maxHeight);
        if (height < 6) {
            return false;
        }
        int topHeight = 3;
        int heightMinusTop = height - topHeight;
        int numBranches = heightMinusTop / 5;
        int baseHeight = heightMinusTop - numBranches * 2;
        BlockPos pos = startPos.func_177984_a();
        if (!this.checkSpace(world, pos, baseHeight, height)) {
            return false;
        }
        for (i = 0; i < baseHeight; ++i) {
            this.setLog(world, pos);
            pos = pos.func_177984_a();
        }
        for (i = 0; i < numBranches; ++i) {
            this.generateLeafLayer(world, random, pos);
            pos = pos.func_177981_b(2);
        }
        this.generateTop(world, random, pos, topHeight);
        this.addVines(world, random, startPos, baseHeight, height, 3, 10);
        return true;
    }

    protected void addVines(World world, Random rand, BlockPos startPos, int baseHeight, int height, int leavesRadius, int generationAttempts) {
        if (this.vine == null) {
            return;
        }
        block0: for (int i = 0; i < generationAttempts; ++i) {
            EnumFacing direction = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
            EnumFacing back = direction.func_176734_d();
            EnumFacing sideways = direction.func_176746_e();
            BlockPos pos = startPos.func_177981_b(GeneratorUtils.nextIntBetween(rand, baseHeight + 1, height)).func_177967_a(direction, leavesRadius + 1).func_177967_a(sideways, GeneratorUtils.nextIntBetween(rand, -leavesRadius, leavesRadius));
            for (int l = 0; l < leavesRadius; ++l) {
                if (world.func_180495_p(pos.func_177967_a(back, 1 + l)) != this.leaves) continue;
                this.setVine(world, rand, pos.func_177967_a(back, l), back, 4);
                continue block0;
            }
        }
    }

    protected void addCocoa(World world, Random rand, BlockPos startPos, int baseHeight, int generationAttempts) {
        for (int i = 0; i < generationAttempts; ++i) {
            EnumFacing direction = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
            EnumFacing back = direction.func_176734_d();
            BlockPos pos = startPos.func_177981_b(GeneratorUtils.nextIntBetween(rand, 1, baseHeight)).func_177967_a(direction, 1);
            this.setCocoa(world, pos, back);
        }
    }

    @Override
    public void configure(IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.minHeight = conf.getInt("minHeight", this.minHeight);
        this.maxHeight = conf.getInt("minHeight", this.maxHeight);
        this.placeOn = conf.getBlockPosQuery("placeOn", this.placeOn);
        this.replace = conf.getBlockPosQuery("replace", this.replace);
        this.log = conf.getBlockState("logState", this.log);
        this.leaves = conf.getBlockState("leavesState", this.leaves);
        this.vine = conf.getBlockState("vinesState", this.vine);
    }

    public static class Builder
    extends GeneratorTreeBase.InnerBuilder<Builder, GeneratorBulbTree>
    implements IGenerator.IGeneratorBuilder<GeneratorBulbTree> {
        public Builder() {
            this.amountPerChunk = 1.0f;
            this.minHeight = 6;
            this.maxHeight = 12;
            this.placeOn = BlockQueries.fertile;
            this.replace = BlockQueries.airOrLeaves;
            this.log = Blocks.field_150364_r.func_176223_P();
            this.leaves = Blocks.field_150362_t.func_176223_P();
            this.vine = null;
            this.hanging = null;
            this.trunkFruit = null;
            this.altLeaves = null;
            this.scatterYMethod = GeneratorUtils.ScatterYMethod.AT_SURFACE;
        }

        @Override
        public GeneratorBulbTree create() {
            return new GeneratorBulbTree(this.amountPerChunk, this.placeOn, this.replace, this.log, this.leaves, this.vine, this.hanging, this.trunkFruit, this.altLeaves, this.minHeight, this.maxHeight, this.scatterYMethod);
        }
    }
}

