/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.entity;

import com.mrcrayfish.guns.GunConfig;
import com.mrcrayfish.guns.entity.EntityProjectile;
import com.mrcrayfish.guns.item.ItemGun;
import com.mrcrayfish.guns.object.Gun;
import com.mrcrayfish.guns.world.ProjectileExplosion;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityGrenade
extends EntityProjectile {
    public EntityGrenade(World worldIn) {
        super(worldIn);
    }

    public EntityGrenade(World worldIn, EntityLivingBase shooter, ItemGun item, Gun modifiedGun) {
        super(worldIn, shooter, item, modifiedGun);
    }

    @Override
    protected void onHitEntity(Entity entity, double x, double y, double z) {
        this.createExplosion(x, y, z, true);
    }

    @Override
    protected void onHitBlock(IBlockState state, BlockPos pos, double x, double y, double z) {
        this.createExplosion(x, y, z, true);
    }

    @Override
    public void onExpired() {
        this.createExplosion(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p instanceof WorldServer);
    }

    private void createExplosion(double x, double y, double z, boolean particle) {
        boolean canGunGrief = this.field_70170_p.func_82736_K().func_82766_b("gunGriefing");
        ProjectileExplosion explosion = new ProjectileExplosion(this, x, y, z, GunConfig.SERVER.grenades.explosionRadius, canGunGrief);
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        explosion.func_180342_d();
        if (particle) {
            WorldServer worldServer = (WorldServer)this.field_70170_p;
            worldServer.func_180505_a(EnumParticleTypes.EXPLOSION_HUGE, true, x, y, z, 0, 0.0, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

