/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.item;

import com.google.common.annotations.Beta;
import com.mrcrayfish.guns.common.ProjectileFactory;
import com.mrcrayfish.guns.entity.EntityProjectile;
import com.mrcrayfish.guns.item.ItemAmmo;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

@Beta
public class AmmoRegistry {
    private static AmmoRegistry instance = null;
    private final ProjectileFactory DEFAULT_FACTORY = EntityProjectile::new;
    private final Map<ResourceLocation, ItemAmmo> AMMO = new HashMap<ResourceLocation, ItemAmmo>();
    private final Map<ResourceLocation, ProjectileFactory> FACTORIES = new HashMap<ResourceLocation, ProjectileFactory>();

    public static AmmoRegistry getInstance() {
        if (instance == null) {
            instance = new AmmoRegistry();
        }
        return instance;
    }

    void register(ItemAmmo ammo) {
        Objects.requireNonNull(ammo.getRegistryName());
        this.AMMO.put(ammo.getRegistryName(), ammo);
    }

    public void registerProjectileFactory(ItemAmmo ammo, ProjectileFactory factory) {
        this.FACTORIES.put(ammo.getRegistryName(), factory);
    }

    @Nullable
    public ItemAmmo getAmmo(ResourceLocation id) {
        return this.AMMO.get(id);
    }

    public ProjectileFactory getFactory(ResourceLocation id) {
        return this.FACTORIES.getOrDefault(id, this.DEFAULT_FACTORY);
    }
}

