/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.proxy;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.guns.GunConfig;
import com.mrcrayfish.guns.client.ControllerEvents;
import com.mrcrayfish.guns.client.KeyBinds;
import com.mrcrayfish.guns.client.event.GunHandler;
import com.mrcrayfish.guns.client.event.ReloadHandler;
import com.mrcrayfish.guns.client.event.RenderEvents;
import com.mrcrayfish.guns.client.event.SoundEvents;
import com.mrcrayfish.guns.client.gui.DisplayProperty;
import com.mrcrayfish.guns.client.gui.GuiWorkbench;
import com.mrcrayfish.guns.client.render.entity.RenderGrenade;
import com.mrcrayfish.guns.client.render.entity.RenderProjectile;
import com.mrcrayfish.guns.client.render.gun.IOverrideModel;
import com.mrcrayfish.guns.client.render.gun.ModelOverrides;
import com.mrcrayfish.guns.client.render.gun.model.ModelChainGun;
import com.mrcrayfish.guns.client.render.gun.model.ModelLongScope;
import com.mrcrayfish.guns.client.render.gun.model.ModelMediumScope;
import com.mrcrayfish.guns.client.render.gun.model.ModelShortScope;
import com.mrcrayfish.guns.entity.EntityProjectile;
import com.mrcrayfish.guns.entity.EntityThrowableGrenade;
import com.mrcrayfish.guns.entity.EntityThrowableStunGrenade;
import com.mrcrayfish.guns.init.ModGuns;
import com.mrcrayfish.guns.init.RegistrationHandler;
import com.mrcrayfish.guns.item.GunRegistry;
import com.mrcrayfish.guns.item.ItemColored;
import com.mrcrayfish.guns.item.ItemScope;
import com.mrcrayfish.guns.proxy.CommonProxy;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleCloud;
import net.minecraft.client.particle.ParticleCrit;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import org.lwjgl.input.Mouse;

public class ClientProxy
extends CommonProxy {
    public static RenderEvents renderEvents;
    public static boolean controllableLoaded;

    @Override
    public void preInit() {
        super.preInit();
        renderEvents = new RenderEvents();
        MinecraftForge.EVENT_BUS.register((Object)renderEvents);
        MinecraftForge.EVENT_BUS.register((Object)new GunHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ReloadHandler());
        RenderingRegistry.registerEntityRenderingHandler(EntityProjectile.class, RenderProjectile::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityThrowableGrenade.class, RenderGrenade::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityThrowableStunGrenade.class, RenderGrenade::new);
        KeyBinds.register();
        SoundEvents.initReflection();
        if (Loader.isModLoaded((String)"controllable")) {
            controllableLoaded = true;
            MinecraftForge.EVENT_BUS.register((Object)new ControllerEvents());
        }
    }

    @Override
    public void init() {
        super.init();
        IItemColor color = (stack, index) -> {
            if (index == 0 && stack.func_77942_o() && stack.func_77978_p().func_150297_b("color", 3)) {
                return stack.func_77978_p().func_74762_e("color");
            }
            return -1;
        };
        RegistrationHandler.Items.getItems().forEach(item -> {
            if (item instanceof ItemColored) {
                Minecraft.func_71410_x().getItemColors().func_186730_a(color, new Item[]{item});
            }
        });
        ModelOverrides.register(new ItemStack(ModGuns.CHAIN_GUN), new ModelChainGun());
        ModelOverrides.register(new ItemStack(ModGuns.SCOPES, 1, ItemScope.Type.SMALL.ordinal()), new ModelShortScope());
        ModelOverrides.register(new ItemStack(ModGuns.SCOPES, 1, ItemScope.Type.MEDIUM.ordinal()), new ModelMediumScope());
        ModelOverrides.register(new ItemStack(ModGuns.SCOPES, 1, ItemScope.Type.LONG.ordinal()), new ModelLongScope());
        GuiWorkbench.addDisplayProperty(new ItemStack(ModGuns.PISTOL), new DisplayProperty(0.0, 0.55f, -0.25, 0.0, 0.0, 0.0, 3.0));
        GuiWorkbench.addDisplayProperty(new ItemStack(ModGuns.SHOTGUN), new DisplayProperty(0.0, 0.55f, 0.0, 0.0, 0.0, 0.0, 3.0));
        GuiWorkbench.addDisplayProperty(new ItemStack(ModGuns.RIFLE), new DisplayProperty(0.0, 0.55f, 0.0, 0.0, 0.0, 0.0, 3.0));
        GuiWorkbench.addDisplayProperty(new ItemStack((Item)ModGuns.GRENADE_LAUNCHER), new DisplayProperty(0.0, 0.55f, -0.1f, 0.0, 0.0, 0.0, 3.0));
        GuiWorkbench.addDisplayProperty(new ItemStack(ModGuns.BAZOOKA), new DisplayProperty(0.0, 0.55f, 0.0, 0.0, 0.0, 0.0, 2.5));
        GuiWorkbench.addDisplayProperty(new ItemStack(ModGuns.CHAIN_GUN), new DisplayProperty(0.0, 0.55f, 0.1f, 0.0, 0.0, 0.0, 2.0));
        GuiWorkbench.addDisplayProperty(new ItemStack(ModGuns.ASSAULT_RIFLE), new DisplayProperty(0.0, 0.55f, -0.15f, 0.0, 0.0, 0.0, 3.0));
        GuiWorkbench.addDisplayProperty(new ItemStack(ModGuns.BASIC_AMMO), new DisplayProperty(0.0, 0.55f, 0.0, 0.0, 0.0, 0.0, 1.0));
        GuiWorkbench.addDisplayProperty(new ItemStack(ModGuns.ADVANCED_AMMO), new DisplayProperty(0.0, 0.55f, 0.0, 0.0, 0.0, 0.0, 1.0));
        GuiWorkbench.addDisplayProperty(new ItemStack(ModGuns.SHELL), new DisplayProperty(0.0, 0.55f, 0.0, 0.0, 0.0, 0.0, 1.5));
        GuiWorkbench.addDisplayProperty(new ItemStack((Item)ModGuns.GRENADE), new DisplayProperty(0.0, 0.55f, 0.0, 0.0, 0.0, 0.0, 3.0));
        GuiWorkbench.addDisplayProperty(new ItemStack((Item)ModGuns.MISSILE), new DisplayProperty(0.0, 0.55f, 0.0, 0.0, 0.0, 0.0, 2.0));
        GuiWorkbench.addDisplayProperty(new ItemStack(ModGuns.STUN_GRENADE), new DisplayProperty(0.0, 0.55f, 0.0, 0.0, 0.0, 0.0, 3.0));
        GuiWorkbench.addDisplayProperty(new ItemStack(ModGuns.SCOPES, 1, ItemScope.Type.SMALL.ordinal()), new DisplayProperty(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.0));
        GuiWorkbench.addDisplayProperty(new ItemStack(ModGuns.SCOPES, 1, ItemScope.Type.MEDIUM.ordinal()), new DisplayProperty(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.0));
        GuiWorkbench.addDisplayProperty(new ItemStack(ModGuns.SCOPES, 1, ItemScope.Type.LONG.ordinal()), new DisplayProperty(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.0));
        GuiWorkbench.addDisplayProperty(new ItemStack(ModGuns.SILENCER), new DisplayProperty(0.0, 0.25, 0.5, 0.0, 0.0, 0.0, 1.5));
    }

    @Override
    public void postInit() {
        super.postInit();
        ModelOverrides.getModelMap().forEach((item, map) -> map.values().forEach(IOverrideModel::init));
    }

    @Override
    public void showMuzzleFlash() {
        RenderEvents.drawFlash = true;
    }

    @Override
    public void playClientSound(SoundEvent sound) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)sound, (float)1.0f));
    }

    @Override
    public void playClientSound(double posX, double posY, double posZ, SoundEvent event, SoundCategory category, float volume, float pitch) {
        PositionedSoundRecord sound = new PositionedSoundRecord(event.func_187503_a(), category, volume, pitch, false, 0, ISound.AttenuationType.NONE, 0.0f, 0.0f, 0.0f);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
    }

    @SubscribeEvent
    public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        GunRegistry.getInstance().getGuns().forEach((location, gun) -> {
            gun.getGun().serverGun = null;
        });
    }

    @Override
    public void createExplosionStunGrenade(double x, double y, double z) {
        int i;
        ParticleManager particleManager = Minecraft.func_71410_x().field_71452_i;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Random rand = world.field_73012_v;
        for (i = 0; i < 30; ++i) {
            particleManager.func_78873_a(this.createParticle(x, y, z, (World)world, rand, (IParticleFactory)new ParticleCloud.Factory(), 0.2));
        }
        for (i = 0; i < 30; ++i) {
            Particle smoke = this.createParticle(x, y, z, (World)world, rand, (IParticleFactory)new ParticleCloud.Factory(), 4.0);
            smoke.func_187114_a((int)(8.0 / (Math.random() * 0.1 + 0.4) * 0.5));
            particleManager.func_78873_a(smoke);
            particleManager.func_78873_a(this.createParticle(x, y, z, (World)world, rand, (IParticleFactory)new ParticleCrit.Factory(), 4.0));
        }
    }

    private Particle createParticle(double x, double y, double z, World world, Random rand, IParticleFactory factory, double velocityMultiplier) {
        return factory.func_178902_a(0, world, x + (rand.nextDouble() - 0.5) * 0.6, y + (rand.nextDouble() - 0.5) * 0.6, z + (rand.nextDouble() - 0.5) * 0.6, (rand.nextDouble() - 0.5) * velocityMultiplier, (rand.nextDouble() - 0.5) * velocityMultiplier, (rand.nextDouble() - 0.5) * velocityMultiplier, new int[0]);
    }

    @Override
    public boolean canShoot() {
        return GunConfig.CLIENT.controls.oldControls;
    }

    @Override
    public boolean isZooming() {
        Controller controller;
        boolean zooming;
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.field_71415_G) {
            return false;
        }
        if (mc.field_71439_g.func_175149_v()) {
            return false;
        }
        boolean bl = zooming = GunConfig.CLIENT.controls.oldControls ? GuiScreen.func_175283_s() : Mouse.isButtonDown((int)1);
        if (controllableLoaded && (controller = Controllable.getController()) != null) {
            zooming |= (double)controller.getLTriggerValue() >= 0.5;
        }
        if (!zooming) {
            return false;
        }
        return !ClientProxy.isLookingAtInteract();
    }

    @Override
    public void startReloadAnimation() {
        ClientProxy.renderEvents.playAnimation = true;
    }

    public static boolean isLookingAtInteract() {
        Entity entity;
        IBlockState state;
        Block block;
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71476_x != null && (mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK ? (block = (state = mc.field_71441_e.func_180495_p(mc.field_71476_x.func_178782_a())).func_177230_c()) instanceof BlockContainer || block.hasTileEntity(state) || block == Blocks.field_150462_ai : mc.field_71476_x.field_72313_a == RayTraceResult.Type.ENTITY && (entity = mc.field_71476_x.field_72308_g) != null && entity.func_184230_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, EnumHand.MAIN_HAND));
    }

    static {
        controllableLoaded = false;
    }
}

