/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.recipe;

import com.google.common.collect.Lists;
import com.mrcrayfish.guns.item.ItemColored;
import java.util.ArrayList;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.DyeUtils;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeColorItem
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public RecipeColorItem() {
        this.setRegistryName(new ResourceLocation("cgm", "color_weapon"));
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        ItemStack item = ItemStack.field_190927_a;
        ArrayList dyes = Lists.newArrayList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ItemColored) {
                if (!item.func_190926_b()) {
                    return false;
                }
                item = stack;
                continue;
            }
            if (!DyeUtils.isDye((ItemStack)stack)) {
                return false;
            }
            dyes.add(stack);
        }
        return !item.func_190926_b() && !dyes.isEmpty();
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack item = ItemStack.field_190927_a;
        ItemColored colored = null;
        int[] combinedValues = new int[3];
        int combinedColor = 0;
        int colorCount = 0;
        for (int k = 0; k < inv.func_70302_i_(); ++k) {
            ItemStack stack = inv.func_70301_a(k);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ItemColored) {
                colored = (ItemColored)stack.func_77973_b();
                if (!item.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                item = stack.func_77946_l();
                item.func_190920_e(1);
                if (!colored.hasColor(stack)) continue;
                int color = colored.getColor(item);
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                combinedColor = (int)((float)combinedColor + Math.max(red, Math.max(green, blue)) * 255.0f);
                combinedValues[0] = (int)((float)combinedValues[0] + red * 255.0f);
                combinedValues[1] = (int)((float)combinedValues[1] + green * 255.0f);
                combinedValues[2] = (int)((float)combinedValues[2] + blue * 255.0f);
                ++colorCount;
                continue;
            }
            if (!DyeUtils.isDye((ItemStack)stack)) {
                return ItemStack.field_190927_a;
            }
            float[] color = ((EnumDyeColor)DyeUtils.colorFromStack((ItemStack)stack).get()).func_193349_f();
            int red = (int)(color[0] * 255.0f);
            int green = (int)(color[1] * 255.0f);
            int blue = (int)(color[2] * 255.0f);
            combinedColor += Math.max(red, Math.max(green, blue));
            combinedValues[0] = combinedValues[0] + red;
            combinedValues[1] = combinedValues[1] + green;
            combinedValues[2] = combinedValues[2] + blue;
            ++colorCount;
        }
        if (colored == null) {
            return ItemStack.field_190927_a;
        }
        int red = combinedValues[0] / colorCount;
        int green = combinedValues[1] / colorCount;
        int blue = combinedValues[2] / colorCount;
        float averageColor = (float)combinedColor / (float)colorCount;
        float maxValue = Math.max(red, Math.max(green, blue));
        red = (int)((float)red * averageColor / maxValue);
        green = (int)((float)green * averageColor / maxValue);
        blue = (int)((float)blue * averageColor / maxValue);
        int finalColor = (red << 8) + green;
        finalColor = (finalColor << 8) + blue;
        colored.setColor(item, finalColor);
        return item;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList remainingItems = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            remainingItems.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)stack));
        }
        return remainingItems;
    }

    public boolean func_192399_d() {
        return true;
    }
}

