/*
 * Decompiled with CFR 0.152.
 */
package com.TominoCZ.FBP.particle;

import com.TominoCZ.FBP.FBP;
import com.TominoCZ.FBP.keys.FBPKeyBindings;
import com.TominoCZ.FBP.util.FBPMathUtil;
import com.TominoCZ.FBP.util.FBPRenderUtil;
import com.TominoCZ.FBP.vector.FBPVector3d;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FBPParticleDigging
extends ParticleDigging {
    private final IBlockState sourceState;
    Minecraft mc;
    float prevGravity;
    double startY;
    double scaleAlpha;
    double prevParticleScale;
    double prevParticleAlpha;
    double prevMotionX;
    double prevMotionZ;
    double endMult = 0.75;
    boolean modeDebounce;
    boolean wasFrozen;
    boolean destroyed;
    boolean killToggle;
    EnumFacing facing;
    FBPVector3d rot;
    FBPVector3d prevRot;
    FBPVector3d rotStep;
    Vec2f[] par;
    static Entity dummyEntity = new Entity(null){

        protected void func_70014_b(NBTTagCompound compound) {
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70088_a() {
        }
    };

    protected FBPParticleDigging(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, float scale, float R, float G, float B, IBlockState state, @Nullable EnumFacing facing, @Nullable TextureAtlasSprite texture) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, state);
        this.field_70552_h = R;
        this.field_70553_i = G;
        this.field_70551_j = B;
        this.mc = Minecraft.func_71410_x();
        this.rot = new FBPVector3d();
        this.prevRot = new FBPVector3d();
        this.facing = facing;
        this.createRotationMatrix();
        try {
            FBP.setSourcePos.invokeExact(this, new BlockPos(xCoordIn, yCoordIn, zCoordIn));
        }
        catch (Throwable e1) {
            e1.printStackTrace();
        }
        if (scale > -1.0f) {
            this.field_70544_f = scale;
        }
        if (scale < -1.0f && facing != null && facing == EnumFacing.UP && FBP.smartBreaking) {
            this.field_187129_i *= 1.5;
            this.field_187130_j *= 0.1;
            this.field_187131_k *= 1.5;
            double particleSpeed = Math.sqrt(this.field_187129_i * this.field_187129_i + this.field_187131_k * this.field_187131_k);
            double x = FBPMathUtil.add(FBPParticleDigging.field_190016_K.field_72450_a, 0.01);
            double z = FBPMathUtil.add(FBPParticleDigging.field_190016_K.field_72449_c, 0.01);
            this.field_187129_i = x * particleSpeed;
            this.field_187131_k = z * particleSpeed;
        }
        if (this.modeDebounce = !FBP.randomRotation) {
            this.rot.zero();
            this.calculateYAngle();
        }
        this.sourceState = state;
        Block b = state.func_177230_c();
        this.field_70545_g = (float)((double)b.field_149763_I * FBP.gravityMult);
        this.field_70544_f = (float)(FBP.scaleMult * (double)(FBP.randomizedScale ? this.field_70544_f : 1.0f));
        this.field_70547_e = (int)FBP.random.nextDouble(FBP.minAge, (double)FBP.maxAge + 0.5);
        this.scaleAlpha = (double)this.field_70544_f * 0.82;
        boolean bl = this.destroyed = facing == null;
        if (texture == null) {
            BlockModelShapes blockModelShapes = this.mc.func_175602_ab().func_175023_a();
            if (!this.destroyed) {
                try {
                    List quads = blockModelShapes.func_178125_b(state).func_188616_a(state, facing, 0L);
                    if (quads != null && !quads.isEmpty()) {
                        this.field_187119_C = ((BakedQuad)quads.get(0)).func_187508_a();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.field_187119_C == null || this.field_187119_C.func_94215_i().equals("missingno")) {
                this.func_187117_a(blockModelShapes.func_178122_a(state));
            }
        } else {
            this.field_187119_C = texture;
        }
        if (FBP.randomFadingSpeed) {
            this.endMult = MathHelper.func_151237_a((double)FBP.random.nextDouble(0.5, 0.9), (double)0.55, (double)0.8);
        }
        this.prevGravity = this.field_70545_g;
        this.startY = this.field_187127_g;
        this.func_70541_f(1.0f);
    }

    public Particle func_70541_f(float scale) {
        Particle p = super.func_70541_f(scale);
        float f = this.field_70544_f / 10.0f;
        if (FBP.restOnFloor && this.destroyed) {
            this.field_187127_g = this.field_187124_d = this.startY - (double)f;
        }
        this.func_187108_a(new AxisAlignedBB(this.field_187126_f - (double)f, this.field_187127_g, this.field_187128_h - (double)f, this.field_187126_f + (double)f, this.field_187127_g + (double)(2.0f * f), this.field_187128_h + (double)f));
        return p;
    }

    public Particle MultiplyVelocity(float multiplier) {
        this.field_187129_i *= (double)multiplier;
        this.field_187130_j = (this.field_187130_j - (double)0.1f) * (double)(multiplier / 2.0f) + (double)0.1f;
        this.field_187131_k *= (double)multiplier;
        return this;
    }

    protected void func_187154_b(@Nullable BlockPos p_187154_1_) {
        if (this.sourceState.func_177230_c() == Blocks.field_150349_c && this.facing != EnumFacing.UP) {
            return;
        }
        int i = this.mc.func_184125_al().func_186724_a(this.sourceState, (IBlockAccess)this.field_187122_b, p_187154_1_, 0);
        this.field_70552_h *= (float)(i >> 16 & 0xFF) / 255.0f;
        this.field_70553_i *= (float)(i >> 8 & 0xFF) / 255.0f;
        this.field_70551_j *= (float)(i & 0xFF) / 255.0f;
    }

    public FBPParticleDigging init() {
        this.func_187154_b(new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h));
        return this;
    }

    public FBPParticleDigging setBlockPos(BlockPos pos) {
        this.func_187154_b(pos);
        return this;
    }

    public int func_70537_b() {
        return 1;
    }

    public void func_189213_a() {
        boolean allowedToMove;
        boolean bl = allowedToMove = (double)MathHelper.func_76135_e((float)((float)this.field_187129_i)) > 1.0E-4 || (double)MathHelper.func_76135_e((float)((float)this.field_187131_k)) > 1.0E-4;
        if (!FBP.frozen && FBP.bounceOffWalls && !this.mc.func_147113_T() && this.field_70546_d > 0) {
            if (!this.wasFrozen && allowedToMove) {
                boolean zCollided;
                boolean xCollided = this.field_187123_c == this.field_187126_f;
                boolean bl2 = zCollided = this.field_187125_e == this.field_187128_h;
                if (xCollided) {
                    this.field_187129_i = -this.prevMotionX * 0.625;
                }
                if (zCollided) {
                    this.field_187131_k = -this.prevMotionZ * 0.625;
                }
                if (!FBP.randomRotation && (xCollided || zCollided)) {
                    this.calculateYAngle();
                }
            } else {
                this.wasFrozen = false;
            }
        }
        if (FBP.frozen && FBP.bounceOffWalls && !this.wasFrozen) {
            this.wasFrozen = true;
        }
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.prevRot.copyFrom(this.rot);
        this.prevParticleAlpha = this.field_82339_as;
        this.prevParticleScale = this.field_70544_f;
        if (!(this.mc.func_147113_T() || FBP.frozen && !this.killToggle)) {
            if (!this.killToggle) {
                if (!FBP.randomRotation) {
                    if (!this.modeDebounce) {
                        this.modeDebounce = true;
                        this.rot.field_181061_c = 0.0;
                        this.calculateYAngle();
                    }
                    if (allowedToMove) {
                        double x = MathHelper.func_76135_e((float)((float)(this.rotStep.field_181059_a * this.getMult())));
                        if (this.field_187129_i > 0.0) {
                            if (this.field_187131_k > 0.0) {
                                this.rot.field_181059_a -= x;
                            } else if (this.field_187131_k < 0.0) {
                                this.rot.field_181059_a += x;
                            }
                        } else if (this.field_187129_i < 0.0) {
                            if (this.field_187131_k < 0.0) {
                                this.rot.field_181059_a += x;
                            } else if (this.field_187131_k > 0.0) {
                                this.rot.field_181059_a -= x;
                            }
                        }
                    }
                } else {
                    if (this.modeDebounce) {
                        this.modeDebounce = false;
                        this.rot.field_181061_c = FBP.random.nextDouble(30.0, 400.0);
                    }
                    if (allowedToMove) {
                        this.rot.add(this.rotStep.multiply(this.getMult()));
                    }
                }
            }
            if (!FBP.infiniteDuration) {
                ++this.field_70546_d;
            }
            if (this.field_70546_d >= this.field_70547_e || this.killToggle) {
                this.field_70544_f = (float)((double)this.field_70544_f * (0.8876543045043945 * this.endMult));
                if ((double)this.field_82339_as > 0.01 && (double)this.field_70544_f <= this.scaleAlpha) {
                    this.field_82339_as = (float)((double)this.field_82339_as * ((double)0.68752f * this.endMult));
                }
                if ((double)this.field_82339_as <= 0.01) {
                    this.func_187112_i();
                }
            }
            if (!this.killToggle) {
                if (!this.field_187132_l) {
                    this.field_187130_j -= 0.04 * (double)this.field_70545_g;
                }
                this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
                if (this.field_187132_l && FBP.restOnFloor) {
                    this.rot.field_181059_a = (float)Math.round(this.rot.field_181059_a / 90.0) * 90.0f;
                    this.rot.field_181061_c = (float)Math.round(this.rot.field_181061_c / 90.0) * 90.0f;
                }
                if ((double)MathHelper.func_76135_e((float)((float)this.field_187129_i)) > 1.0E-5) {
                    this.prevMotionX = this.field_187129_i;
                }
                if ((double)MathHelper.func_76135_e((float)((float)this.field_187131_k)) > 1.0E-5) {
                    this.prevMotionZ = this.field_187131_k;
                }
                if (allowedToMove) {
                    this.field_187129_i *= (double)0.98f;
                    this.field_187131_k *= (double)0.98f;
                }
                this.field_187130_j *= (double)0.98f;
                if (FBP.entityCollision) {
                    List list = this.field_187122_b.func_72872_a(Entity.class, this.func_187116_l());
                    for (Entity entityIn : list) {
                        double d1;
                        double d0;
                        double d2;
                        if (entityIn.field_70145_X || !((d2 = MathHelper.func_76132_a((double)(d0 = this.field_187126_f - entityIn.field_70165_t), (double)(d1 = this.field_187128_h - entityIn.field_70161_v))) >= (double)0.01f)) continue;
                        d2 = Math.sqrt(d2);
                        d0 /= d2;
                        d1 /= d2;
                        double d3 = 1.0 / d2;
                        if (d3 > 1.0) {
                            d3 = 1.0;
                        }
                        this.field_187129_i += d0 * d3 / 20.0;
                        this.field_187131_k += d1 * d3 / 20.0;
                        if (!FBP.randomRotation) {
                            this.calculateYAngle();
                        }
                        if (FBP.frozen) continue;
                        this.field_187132_l = false;
                    }
                }
                if (FBP.waterPhysics) {
                    if (this.isInWater()) {
                        this.handleWaterMovement();
                        if (FBP.INSTANCE.doesMaterialFloat(this.sourceState.func_185904_a())) {
                            this.field_187130_j = 0.11f + this.field_70544_f / 1.25f * 0.02f;
                        } else {
                            this.field_187129_i *= 0.932515086137662;
                            this.field_187131_k *= 0.932515086137662;
                            this.field_70545_g = 0.35f;
                            this.field_187130_j *= (double)0.85f;
                        }
                        if (!FBP.randomRotation) {
                            this.calculateYAngle();
                        }
                        if (this.field_187132_l) {
                            this.field_187132_l = false;
                        }
                    } else {
                        this.field_70545_g = this.prevGravity;
                    }
                }
                if (this.field_187132_l) {
                    if (FBP.lowTraction) {
                        this.field_187129_i *= 0.932515086137662;
                        this.field_187131_k *= 0.932515086137662;
                    } else {
                        this.field_187129_i *= 0.6654999988079071;
                        this.field_187131_k *= 0.6654999988079071;
                    }
                }
            }
        }
    }

    public boolean isInWater() {
        int maxZ;
        double scale = this.field_70544_f / 20.0f;
        int minX = MathHelper.func_76128_c((double)(this.field_187126_f - scale));
        int maxX = MathHelper.func_76143_f((double)(this.field_187126_f + scale));
        int minY = MathHelper.func_76128_c((double)(this.field_187127_g - scale));
        int maxY = MathHelper.func_76143_f((double)(this.field_187127_g + scale));
        int minZ = MathHelper.func_76128_c((double)(this.field_187128_h - scale));
        if (this.field_187122_b.func_175639_b(new StructureBoundingBox(minX, minY, minZ, maxX, maxY, maxZ = MathHelper.func_76143_f((double)(this.field_187128_h + scale))), true)) {
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        double d0;
                        IBlockState block = this.field_187122_b.func_180495_p(new BlockPos(x, y, z));
                        if (block.func_185904_a() != Material.field_151586_h || !(this.field_187127_g <= (d0 = (double)((float)(y + 1) - BlockLiquid.func_149801_b((int)((Integer)block.func_177229_b((IProperty)BlockLiquid.field_176367_b))))))) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void handleWaterMovement() {
        FBPParticleDigging.dummyEntity.field_70159_w = this.field_187129_i;
        FBPParticleDigging.dummyEntity.field_70181_x = this.field_187130_j;
        FBPParticleDigging.dummyEntity.field_70179_y = this.field_187131_k;
        double scale = this.field_70544_f / 20.0f;
        if (this.field_187122_b.func_72918_a(this.func_187116_l().func_72321_a(0.0, (double)-0.4f, 0.0).func_191195_a(0.001, 0.001, 0.001), Material.field_151586_h, dummyEntity)) {
            this.field_187129_i = FBPParticleDigging.dummyEntity.field_70159_w;
            this.field_187130_j = FBPParticleDigging.dummyEntity.field_70181_x;
            this.field_187131_k = FBPParticleDigging.dummyEntity.field_70179_y;
        }
    }

    public void func_187110_a(double x, double y, double z) {
        double X = x;
        double Y = y;
        double Z = z;
        List list = this.field_187122_b.func_184144_a((Entity)null, this.func_187116_l().func_72321_a(x, y, z));
        for (AxisAlignedBB axisalignedbb : list) {
            y = axisalignedbb.func_72323_b(this.func_187116_l(), y);
        }
        this.func_187108_a(this.func_187116_l().func_72317_d(0.0, y, 0.0));
        for (AxisAlignedBB axisalignedbb : list) {
            x = axisalignedbb.func_72316_a(this.func_187116_l(), x);
        }
        this.func_187108_a(this.func_187116_l().func_72317_d(x, 0.0, 0.0));
        for (AxisAlignedBB axisalignedbb : list) {
            z = axisalignedbb.func_72322_c(this.func_187116_l(), z);
        }
        this.func_187108_a(this.func_187116_l().func_72317_d(0.0, 0.0, z));
        this.func_187118_j();
        boolean bl = this.field_187132_l = y != Y && Y < 0.0;
        if (!FBP.lowTraction && !FBP.bounceOffWalls) {
            if (x != X) {
                this.field_187129_i *= (double)0.7f;
            }
            if (z != Z) {
                this.field_187131_k *= (double)0.7f;
            }
        }
    }

    public void func_180434_a(BufferBuilder buf, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (!FBP.isEnabled() && this.field_70547_e != 0) {
            this.field_70547_e = 0;
        }
        if (FBPKeyBindings.FBPSweep.func_151470_d() && !this.killToggle) {
            this.killToggle = true;
        }
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = (float)(this.prevParticleScale + ((double)this.field_70544_f - this.prevParticleScale) * (double)partialTicks);
        if (this.field_187119_C != null) {
            if (!FBP.cartoonMode) {
                f = this.field_187119_C.func_94214_a((double)(this.field_70548_b / 4.0f * 16.0f));
                f2 = this.field_187119_C.func_94207_b((double)(this.field_70549_c / 4.0f * 16.0f));
            }
            f1 = this.field_187119_C.func_94214_a((double)((this.field_70548_b + 1.0f) / 4.0f * 16.0f));
            f3 = this.field_187119_C.func_94207_b((double)((this.field_70549_c + 1.0f) / 4.0f * 16.0f));
        } else {
            f = ((float)this.field_94054_b + this.field_70548_b / 4.0f) / 16.0f;
            f1 = f + 0.015609375f;
            f2 = ((float)this.field_94055_c + this.field_70549_c / 4.0f) / 16.0f;
            f3 = f2 + 0.015609375f;
        }
        float f5 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float f6 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float f7 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int i = this.func_189214_a(partialTicks);
        this.par = new Vec2f[]{new Vec2f(f1, f3), new Vec2f(f1, f2), new Vec2f(f, f2), new Vec2f(f, f3)};
        float alpha = (float)(this.prevParticleAlpha + ((double)this.field_82339_as - this.prevParticleAlpha) * (double)partialTicks);
        if (FBP.restOnFloor) {
            f6 += f4 / 10.0f;
        }
        FBPVector3d smoothRot = new FBPVector3d(0.0, 0.0, 0.0);
        if (FBP.rotationMult > 0.0) {
            smoothRot.field_181060_b = this.rot.field_181060_b;
            smoothRot.field_181061_c = this.rot.field_181061_c;
            if (!FBP.randomRotation) {
                smoothRot.field_181059_a = this.rot.field_181059_a;
            }
            if (!FBP.frozen) {
                FBPVector3d vec = this.rot.partialVec(this.prevRot, partialTicks);
                if (FBP.randomRotation) {
                    smoothRot.field_181060_b = vec.field_181060_b;
                    smoothRot.field_181061_c = vec.field_181061_c;
                } else {
                    smoothRot.field_181059_a = vec.field_181059_a;
                }
            }
        }
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        float[] arr = new float[]{f1, f3, f1, f2, f, f2, f, f3};
        FBPRenderUtil.renderCubeShaded_S(buf, this.par, f5, f6, f7, f4 / 10.0f, smoothRot, i >> 16 & 0xFFFF, i & 0xFFFF, this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha, FBP.cartoonMode);
    }

    private void createRotationMatrix() {
        double rx0 = FBP.random.nextDouble();
        double ry0 = FBP.random.nextDouble();
        double rz0 = FBP.random.nextDouble();
        this.rotStep = new FBPVector3d(rx0 > 0.5 ? 1.0 : -1.0, ry0 > 0.5 ? 1.0 : -1.0, rz0 > 0.5 ? 1.0 : -1.0);
        this.rot.copyFrom(this.rotStep);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_189214_a(float partialTicks) {
        AxisAlignedBB box = this.func_187116_l();
        if (this.field_187122_b.func_175667_e(new BlockPos(this.field_187126_f, 0.0, this.field_187128_h))) {
            double d0 = (box.field_72337_e - box.field_72338_b) * 0.66;
            double k = this.field_187127_g + d0 + 0.01 - (double)(FBP.restOnFloor ? this.field_70544_f / 10.0f : 0.0f);
            return this.field_187122_b.func_175626_b(new BlockPos(this.field_187126_f, k, this.field_187128_h), 0);
        }
        return 0;
    }

    private void calculateYAngle() {
        double angleSin = Math.toDegrees(Math.asin(this.field_187129_i / Math.sqrt(this.field_187129_i * this.field_187129_i + this.field_187131_k * this.field_187131_k)));
        this.rot.field_181060_b = this.field_187129_i > 0.0 ? (this.field_187131_k > 0.0 ? -angleSin : angleSin) : (this.field_187131_k > 0.0 ? -angleSin : angleSin);
    }

    double getMult() {
        return Math.sqrt(this.field_187129_i * this.field_187129_i + this.field_187131_k * this.field_187131_k) * (double)(FBP.randomRotation ? 200 : 500) * FBP.rotationMult;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements IParticleFactory {
        public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... p_178902_15_) {
            return new FBPParticleDigging(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, -1.0f, 1.0f, 1.0f, 1.0f, Block.func_176220_d((int)p_178902_15_[0]), null, null).init();
        }
    }
}

