/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.config;

import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiSelectFluid;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ConfigFluid
extends ConfigValue {
    public static final String ID = "fluid";
    private Fluid value;
    private Fluid defaultFluid;

    public ConfigFluid(@Nullable Fluid fluid, @Nullable Fluid def) {
        this.defaultFluid = def;
        this.value = fluid == null ? this.getDefaultFluid() : fluid;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getString() {
        this.value = this.getFluid();
        return this.value == null ? "null" : this.value.getName();
    }

    @Nullable
    public Fluid getFluid() {
        return this.value;
    }

    public void setFluid(@Nullable Fluid fluid) {
        this.value = fluid == null ? this.getDefaultFluid() : fluid;
    }

    @Nullable
    public Fluid getDefaultFluid() {
        return this.defaultFluid;
    }

    public void setDefaultFluid(@Nullable Fluid fluid) {
        this.defaultFluid = fluid;
    }

    @Override
    public boolean getBoolean() {
        return this.value != null;
    }

    @Override
    public int getInt() {
        return 0;
    }

    @Override
    public ConfigFluid copy() {
        return new ConfigFluid(this.getFluid(), this.getDefaultFluid());
    }

    @Override
    public ITextComponent getStringForGUI() {
        this.value = this.getFluid();
        if (this.value == null) {
            return new TextComponentString("null");
        }
        return new TextComponentString(this.value.getLocalizedName(new FluidStack(this.value, 1000)));
    }

    @Override
    public boolean setValueFromString(@Nullable ICommandSender sender, String string, boolean simulate) {
        if (string.equals("null")) {
            if (!simulate) {
                this.setFluid(null);
            }
            return true;
        }
        this.value = FluidRegistry.getFluid((String)string);
        if (this.value != null) {
            if (!simulate) {
                this.setFluid(this.value);
            }
            return true;
        }
        return false;
    }

    @Override
    public void onClicked(IOpenableGui gui, ConfigValueInstance inst, MouseButton button, Runnable callback) {
        new GuiSelectFluid(gui, this::getDefaultFluid, fluid -> {
            this.setFluid((Fluid)fluid);
            callback.run();
        }).openGui();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String key) {
        this.value = this.getFluid();
        nbt.func_74778_a(key, this.value == null ? "" : this.value.getName());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String key) {
        String s = nbt.func_74779_i(key);
        this.setFluid(s.isEmpty() ? null : FluidRegistry.getFluid((String)s));
    }

    @Override
    public void writeData(DataOut data) {
        this.defaultFluid = this.getDefaultFluid();
        data.writeString(this.defaultFluid == null ? "" : this.defaultFluid.getName());
        this.value = this.getFluid();
        data.writeString(this.value == null ? "" : this.value.getName());
    }

    @Override
    public void readData(DataIn data) {
        String s = data.readString();
        this.setDefaultFluid(s.isEmpty() ? null : FluidRegistry.getFluid((String)s));
        s = data.readString();
        this.setFluid(s.isEmpty() ? null : FluidRegistry.getFluid((String)s));
    }

    @Override
    public boolean isEmpty() {
        return this.getFluid() == null;
    }
}

