/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.manapool;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.botania.api.recipe.RecipeManaInfusion;
import vazkii.botania.client.core.handler.HUDHandler;

public class ManaPoolRecipeWrapper
implements IRecipeWrapper {
    private final List<List<ItemStack>> input;
    private final ItemStack output;
    private final int mana;

    public ManaPoolRecipeWrapper(RecipeManaInfusion recipe) {
        Block block;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (recipe.getInput() instanceof ItemStack) {
            builder.add((Object)ImmutableList.of((Object)((ItemStack)recipe.getInput())));
        } else if (recipe.getInput() instanceof String) {
            builder.add((Object)OreDictionary.getOres((String)((String)recipe.getInput())));
        }
        if (recipe.getCatalyst() != null && Item.func_150898_a((Block)(block = recipe.getCatalyst().func_177230_c())) != Items.field_190931_a) {
            builder.add((Object)ImmutableList.of((Object)new ItemStack(block, 1, block.func_176201_c(recipe.getCatalyst()))));
        }
        this.input = builder.build();
        this.output = recipe.getOutput();
        this.mana = recipe.getManaToConsume();
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.input);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        GlStateManager.func_179141_d();
        HUDHandler.renderManaBar(28, 50, 255, 0.75f, this.mana, 100000);
        GlStateManager.func_179118_c();
    }

    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return ImmutableList.of();
    }

    public boolean handleClick(@Nonnull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

