/*
 * Decompiled with CFR 0.152.
 */
package mcjty.questutils;

import java.util.Optional;
import java.util.function.Function;
import mcjty.lib.base.ModBase;
import mcjty.lib.proxy.IProxy;
import mcjty.questutils.api.IQuestUtils;
import mcjty.questutils.apiimp.QuestUtilsApi;
import mcjty.questutils.commands.CmdQU;
import mcjty.questutils.setup.ModSetup;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@Mod(modid="questutils", name="QuestUtils", dependencies="required-after:mcjtylib_ng@[3.5.0,);after:forge@[13.19.0.2176,)", version="0.4.0", acceptedMinecraftVersions="[1.12.2]")
public class QuestUtils
implements ModBase {
    public static final String MODID = "questutils";
    public static final String MODNAME = "QuestUtils";
    public static final String MODVERSION = "0.4.0";
    public static final String MIN_MCJTYLIB_VER = "3.5.0";
    public static final String MIN_FORGE_VER = "13.19.0.2176";
    public static QuestUtilsApi questUtilsApi = new QuestUtilsApi();
    @SidedProxy(clientSide="mcjty.questutils.setup.ClientProxy", serverSide="mcjty.questutils.setup.ServerProxy")
    public static IProxy proxy;
    public static ModSetup setup;
    @Mod.Instance(value="questutils")
    public static QuestUtils instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        setup.preInit(event);
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        setup.init(e);
        proxy.init(e);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        setup.postInit(e);
        proxy.postInit(e);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CmdQU());
    }

    public String getModId() {
        return MODID;
    }

    public void openManual(EntityPlayer player, int bookindex, String page) {
    }

    @Mod.EventHandler
    public void imcCallback(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (!message.key.equalsIgnoreCase("getQuestUtils")) continue;
            Optional value = message.getFunctionValue(IQuestUtils.class, Void.class);
            if (value.isPresent()) {
                ((Function)value.get()).apply(questUtilsApi);
                continue;
            }
            setup.getLogger().warn("Some mod didn't return a valid result with getQuestUtils!");
        }
    }

    static {
        setup = new ModSetup();
    }
}

