/*
 * Decompiled with CFR 0.152.
 */
package mcjty.questutils.blocks;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IValue;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.questutils.data.QUData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class QUTileEntity
extends GenericTileEntity {
    private String identifier;
    public static final Key<String> VALUE_ID = new Key("id", Type.STRING);

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_ID, this::getIdentifier, this::setIdentifier)};
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.trim().isEmpty();
    }

    public void setIdentifier(String identifier) {
        if (!this.field_145850_b.field_72995_K && this.hasIdentifier()) {
            QUData.getData().removeEntry(identifier);
            QUData.getData().removeEntry(this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c);
        }
        this.identifier = identifier == null || identifier.trim().isEmpty() ? null : identifier;
        if (!this.field_145850_b.field_72995_K && this.hasIdentifier()) {
            QUData.getData().updateEntry(identifier, this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c);
        }
        this.markDirtyClient();
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, placer, stack);
        if (!world.field_72995_K && this.hasIdentifier()) {
            QUData.getData().updateEntry(this.identifier, world.field_73011_w.getDimension(), pos);
        }
    }

    public void onBlockBreak(World world, BlockPos pos, IBlockState state) {
        super.onBlockBreak(world, pos, state);
        if (!this.field_145850_b.field_72995_K) {
            if (this.hasIdentifier()) {
                QUData.getData().removeEntry(this.identifier);
            }
            QUData.getData().removeEntry(this.field_145850_b.field_73011_w.getDimension(), pos);
        }
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.identifier = tagCompound.func_74764_b("quid") ? tagCompound.func_74779_i("quid") : null;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        if (this.identifier != null) {
            tagCompound.func_74778_a("quid", this.identifier);
        }
    }

    public void writeToJson(JsonObject object) {
        if (this.hasIdentifier()) {
            object.add("id", (JsonElement)new JsonPrimitive(this.identifier));
        }
    }

    public void readFromJson(JsonObject object) {
    }
}

