/*
 * Decompiled with CFR 0.152.
 */
package mcjty.questutils.blocks.itemcomparator;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mcjty.lib.bindings.DefaultAction;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IAction;
import mcjty.lib.bindings.IValue;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.questutils.blocks.QUTileEntity;
import mcjty.questutils.blocks.itemcomparator.ItemComparatorContainer;
import mcjty.questutils.json.JsonTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemComparatorTE
extends QUTileEntity
implements DefaultSidedInventory {
    private static int[] slots = null;
    private boolean inAlarm = false;
    private boolean ignoreMeta = false;
    private boolean ignoreNBT = false;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, ItemComparatorContainer.factory, 32);
    private InventoryHelper ghostSlots = new InventoryHelper((TileEntity)this, ItemComparatorContainer.factory, 16);
    public static final String ACTION_REMEMBER = "remember";
    public static final String ACTION_FORGET = "forget";
    public static final Key<Boolean> VALUE_IGNORE_NBT = new Key("ignoreNBT", Type.BOOLEAN);
    public static final Key<Boolean> VALUE_IGNORE_META = new Key("ignoreMeta", Type.BOOLEAN);

    @Override
    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_ID, this::getIdentifier, this::setIdentifier), new DefaultValue(VALUE_IGNORE_META, this::isIgnoreMeta, this::setIgnoreMeta), new DefaultValue(VALUE_IGNORE_NBT, this::isIgnoreNBT, this::setIgnoreNBT)};
    }

    public boolean isIgnoreMeta() {
        return this.ignoreMeta;
    }

    public void setIgnoreMeta(boolean ignoreMeta) {
        this.ignoreMeta = ignoreMeta;
        this.markDirtyClient();
        this.detect();
    }

    public boolean isIgnoreNBT() {
        return this.ignoreNBT;
    }

    public void setIgnoreNBT(boolean ignoreNBT) {
        this.ignoreNBT = ignoreNBT;
        this.markDirtyClient();
        this.detect();
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public IAction[] getActions() {
        return new IAction[]{new DefaultAction(ACTION_REMEMBER, this::rememberItems), new DefaultAction(ACTION_FORGET, this::forgetItems)};
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void detect() {
        int i;
        boolean ok = true;
        int[] amounts = new int[16];
        for (i = 0; i < 16; ++i) {
            amounts[i] = this.func_70301_a(i + 16).func_190916_E();
        }
        for (i = 0; i < 16; ++i) {
            ItemStack item = this.func_70301_a(i);
            if (item.func_190926_b()) continue;
            if (this.countMissing(item, amounts) == 0) {
                this.consume(item, amounts);
                continue;
            }
            ok = false;
            break;
        }
        this.setAlarm(ok);
    }

    private boolean match(ItemStack matcher, ItemStack item) {
        if (this.ignoreMeta ? matcher.func_77973_b() != item.func_77973_b() : !ItemStack.func_179545_c((ItemStack)matcher, (ItemStack)item)) {
            return false;
        }
        if (this.ignoreNBT) {
            return true;
        }
        return ItemStack.func_77970_a((ItemStack)matcher, (ItemStack)item);
    }

    private int countMissing(ItemStack matcher, int[] amounts) {
        int toFind = matcher.func_190916_E();
        for (int i = 0; i < 16; ++i) {
            ItemStack item = this.func_70301_a(i + 16);
            if (item.func_190926_b() || !this.match(matcher, item) || (toFind -= Math.min(toFind, amounts[i])) > 0) continue;
            return 0;
        }
        return toFind;
    }

    private void consume(ItemStack matcher, int[] amounts) {
        int toFind = matcher.func_190916_E();
        for (int i = 0; i < 16; ++i) {
            ItemStack item = this.func_70301_a(i + 16);
            if (item.func_190926_b() || !this.match(matcher, item)) continue;
            int consume = Math.min(toFind, amounts[i]);
            int n = i;
            amounts[n] = amounts[n] - consume;
            if ((toFind -= consume) > 0) continue;
            return;
        }
    }

    public void setPowerInput(int powered) {
        if (powered != this.powerLevel) {
            super.setPowerInput(powered);
            if (powered > 0) {
                this.dump();
            }
        }
    }

    public void dump() {
        for (int i = 0; i < 16; ++i) {
            ItemStack stack = this.func_70301_a(i + 16);
            if (stack.func_190926_b()) continue;
            stack = InventoryHelper.insertItem((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)EnumFacing.UP, (ItemStack)stack);
            this.func_70299_a(i + 16, stack);
        }
    }

    public boolean isPowered() {
        return this.inAlarm;
    }

    public void setAlarm(boolean alarm) {
        if (alarm != this.inAlarm) {
            this.inAlarm = alarm;
            this.func_145831_w().func_175685_c(this.field_174879_c, this.func_145838_q(), false);
            this.func_70296_d();
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        if (slots == null) {
            slots = new int[16];
            for (int i = 0; i < 16; ++i) {
                ItemComparatorTE.slots[i] = i + 16;
            }
        }
        return slots;
    }

    public InventoryHelper getGhostSlots() {
        return this.ghostSlots;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        if (!this.func_94041_b(index, itemStackIn)) {
            return false;
        }
        return index >= 16 && index < 32;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index >= 16 && index < 32;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.getInventoryHelper().setInventorySlotContents(this.func_70297_j_(), index, stack);
        this.detect();
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.getInventoryHelper().decrStackSize(index, count);
        this.detect();
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.getInventoryHelper().removeStackFromSlot(index);
        this.detect();
        return stack;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        ItemStack ghostSlot;
        return index < 16 || index >= 32 || (ghostSlot = this.ghostSlots.getStackInSlot(index - 16)).func_190926_b() || ghostSlot.func_77969_a(stack);
    }

    private void rememberItems() {
        for (int i = 0; i < this.ghostSlots.getCount(); ++i) {
            int slotIdx = i + 16;
            if (!this.inventoryHelper.containsItem(slotIdx)) continue;
            ItemStack stack = this.inventoryHelper.getStackInSlot(slotIdx).func_77946_l();
            stack.func_190920_e(1);
            this.ghostSlots.setStackInSlot(i, stack);
        }
        this.markDirtyClient();
    }

    private void forgetItems() {
        for (int i = 0; i < this.ghostSlots.getCount(); ++i) {
            this.ghostSlots.setStackInSlot(i, ItemStack.field_190927_a);
        }
        this.markDirtyClient();
    }

    @Override
    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.readGhostBufferFromNBT(tagCompound);
        this.ignoreMeta = tagCompound.func_74767_n("ignoreMeta");
        this.ignoreNBT = tagCompound.func_74767_n("ignoreNBT");
    }

    private void readGhostBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("GItems", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.ghostSlots.setStackInSlot(i, new ItemStack(nbtTagCompound));
        }
    }

    @Override
    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        this.writeGhostBufferToNBT(tagCompound);
        tagCompound.func_74757_a("ignoreMeta", this.ignoreMeta);
        tagCompound.func_74757_a("ignoreNBT", this.ignoreNBT);
    }

    private void writeGhostBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.ghostSlots.getCount(); ++i) {
            ItemStack stack = this.ghostSlots.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (!stack.func_190926_b()) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("GItems", (NBTBase)bufferTagList);
    }

    @Override
    public void writeToJson(JsonObject object) {
        super.writeToJson(object);
        if (this.hasIdentifier()) {
            object.add("filter", (JsonElement)JsonTools.writeItemsToJson(this.getInventoryHelper(), 0, 16));
            object.add("ghost", (JsonElement)JsonTools.writeItemsToJson(this.ghostSlots, 0, 16));
        }
    }

    @Override
    public void readFromJson(JsonObject object) {
        super.readFromJson(object);
        if (object.has("filter")) {
            JsonTools.readItemsFromJson(object.getAsJsonArray("filter"), this.getInventoryHelper(), 0, 16);
            this.detect();
        }
        if (object.has("ghost")) {
            JsonTools.readItemsFromJson(object.getAsJsonArray("ghost"), this.ghostSlots, 0, 16);
        }
    }
}

