/*
 * Decompiled with CFR 0.152.
 */
package mcjty.questutils.blocks.pedestal;

import java.util.function.BiFunction;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.questutils.blocks.QUBlock;
import mcjty.questutils.blocks.pedestal.PedestalContainer;
import mcjty.questutils.blocks.pedestal.PedestalGui;
import mcjty.questutils.blocks.pedestal.PedestalMode;
import mcjty.questutils.blocks.pedestal.PedestalTE;
import mcjty.questutils.blocks.pedestal.PedestalTESR;
import mcjty.questutils.items.ModItems;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PedestalBlock
extends QUBlock<PedestalTE, PedestalContainer> {
    public PedestalBlock() {
        super(PedestalTE.class, PedestalContainer::new, "pedestal");
    }

    public BaseBlock.RotationType getRotationType() {
        return BaseBlock.RotationType.NONE;
    }

    public boolean hasRedstoneOutput() {
        return true;
    }

    public int getGuiID() {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public BiFunction<PedestalTE, PedestalContainer, GenericGuiContainer<? super PedestalTE>> getGuiFactory() {
        return PedestalGui::new;
    }

    public void initModel() {
        super.initModel();
        PedestalTESR.register();
    }

    public boolean handleModule(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (heldItem.func_77973_b() == ModItems.controlKey) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof PedestalTE) {
            PedestalTE pedestal = (PedestalTE)te;
            PedestalMode mode = pedestal.getMode();
            switch (mode) {
                case MODE_DISPLAY: {
                    break;
                }
                case MODE_INTERACT: {
                    pedestal.interactItem(player, hand);
                    break;
                }
                case MODE_PLACE: {
                    pedestal.placeItem(player, hand);
                    break;
                }
                case MODE_TAKE: {
                    pedestal.takeItem(player, hand);
                }
            }
        }
        return true;
    }

    protected int getRedstoneOutput(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        switch (side) {
            case DOWN: 
            case UP: {
                break;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                TileEntity te = world.func_175625_s(pos);
                if (!(state.func_177230_c() instanceof PedestalBlock) || !(te instanceof PedestalTE)) break;
                PedestalTE pedestal = (PedestalTE)te;
                return pedestal.func_70301_a(0).func_190926_b() ? 0 : 15;
            }
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149637_q(IBlockState blockState) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    private PedestalTE getTE(World world, BlockPos pos) {
        return (PedestalTE)world.func_175625_s(pos);
    }
}

