/*
 * Decompiled with CFR 0.152.
 */
package mcjty.questutils.blocks.pedestal;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IValue;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.questutils.blocks.QUTileEntity;
import mcjty.questutils.blocks.pedestal.PedestalContainer;
import mcjty.questutils.blocks.pedestal.PedestalMode;
import mcjty.questutils.json.JsonTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PedestalTE
extends QUTileEntity
implements DefaultSidedInventory {
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, PedestalContainer.factory, 1);
    private static int[] slots = null;
    private boolean inAlarm = false;
    private PedestalMode mode = PedestalMode.MODE_DISPLAY;
    public static final Key<Integer> VALUE_MODE = new Key("mode", Type.INTEGER);

    @Override
    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_MODE, () -> this.getMode().ordinal(), v -> this.setMode(PedestalMode.values()[v])), new DefaultValue(VALUE_ID, this::getIdentifier, this::setIdentifier)};
    }

    public void interactItem(EntityPlayer player, EnumHand hand) {
        if (player.func_184586_b(hand).func_190926_b()) {
            this.takeItem(player, hand);
        } else {
            this.placeItem(player, hand);
        }
    }

    public void placeItem(EntityPlayer player, EnumHand hand) {
        if (player.func_184586_b(hand).func_190926_b()) {
            return;
        }
        ItemStack remaining = InventoryHelper.insertItem((World)this.field_145850_b, (BlockPos)this.field_174879_c, null, (ItemStack)player.func_184586_b(hand));
        player.func_184611_a(hand, remaining);
    }

    public void takeItem(EntityPlayer player, EnumHand hand) {
        ItemStack stack = this.func_70301_a(0);
        if (stack.func_190926_b()) {
            return;
        }
        if (player.func_184586_b(hand).func_190926_b()) {
            player.func_184611_a(hand, stack);
            this.func_70299_a(0, ItemStack.field_190927_a);
        } else if (player.field_71071_by.func_70441_a(stack)) {
            this.func_70299_a(0, ItemStack.field_190927_a);
        }
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (slots == null) {
            slots = new int[]{0};
        }
        return slots;
    }

    public void detect() {
        this.setAlarm(!this.func_70301_a(0).func_190926_b());
    }

    public boolean isPowered() {
        return this.inAlarm;
    }

    public void setAlarm(boolean alarm) {
        if (alarm != this.inAlarm) {
            this.inAlarm = alarm;
            this.func_145831_w().func_175685_c(this.field_174879_c, this.func_145838_q(), false);
            this.func_70296_d();
        }
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.getInventoryHelper().setInventorySlotContents(this.func_70297_j_(), index, stack);
        this.detect();
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.getInventoryHelper().decrStackSize(index, count);
        this.detect();
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.getInventoryHelper().removeStackFromSlot(index);
        this.detect();
        return stack;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public PedestalMode getMode() {
        return this.mode;
    }

    public void setMode(PedestalMode mode) {
        this.mode = mode;
        this.markDirtyClient();
    }

    @Override
    public void readRestorableFromNBT(NBTTagCompound compound) {
        super.readRestorableFromNBT(compound);
        this.readBufferFromNBT(compound, this.inventoryHelper);
        this.mode = PedestalMode.values()[compound.func_74762_e("mode")];
    }

    @Override
    public void writeRestorableToNBT(NBTTagCompound compound) {
        super.writeRestorableToNBT(compound);
        this.writeBufferToNBT(compound, this.inventoryHelper);
        compound.func_74768_a("mode", this.mode.ordinal());
    }

    @Override
    public void writeToJson(JsonObject object) {
        super.writeToJson(object);
        if (this.hasIdentifier()) {
            object.add("filter", (JsonElement)JsonTools.writeItemsToJson(this.getInventoryHelper(), 0, 1));
        }
    }

    @Override
    public void readFromJson(JsonObject object) {
        super.readFromJson(object);
        if (object.has("filter")) {
            JsonTools.readItemsFromJson(object.getAsJsonArray("filter"), this.getInventoryHelper(), 0, 1);
            this.detect();
        }
    }
}

