/*
 * Decompiled with CFR 0.152.
 */
package mcjty.questutils.blocks.screen;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import mcjty.lib.McJtyLib;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.questutils.api.ScreenSize;
import mcjty.questutils.blocks.ModBlocks;
import mcjty.questutils.blocks.QUBlock;
import mcjty.questutils.blocks.screen.ScreenContainer;
import mcjty.questutils.blocks.screen.ScreenGui;
import mcjty.questutils.blocks.screen.ScreenHitTE;
import mcjty.questutils.blocks.screen.ScreenRenderer;
import mcjty.questutils.blocks.screen.ScreenTE;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ScreenBlock
extends QUBlock<ScreenTE, ScreenContainer> {
    public static final PropertyDirection HORIZONTAL_FACING = PropertyDirection.func_177712_a((String)"horizontal_facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static long lastTime = 0L;
    public static final AxisAlignedBB BLOCK_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    public static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);
    public static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    public static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);

    public ScreenBlock() {
        super(ScreenTE.class, ScreenContainer::new, "screen");
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)HORIZONTAL_FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        if (meta > 5) {
            meta -= 4;
        } else if (meta > 1) {
            EnumFacing facing = EnumFacing.field_82609_l[meta];
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)HORIZONTAL_FACING, (Comparable)facing);
        }
        EnumFacing horizontalFacing = EnumFacing.field_82609_l[(meta >> 1) + 2];
        EnumFacing facing = (meta & 1) == 0 ? EnumFacing.DOWN : EnumFacing.UP;
        return this.func_176223_P().func_177226_a((IProperty)HORIZONTAL_FACING, (Comparable)horizontalFacing).func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumFacing horizontalFacing = (EnumFacing)state.func_177229_b((IProperty)HORIZONTAL_FACING);
        int meta = 0;
        switch (facing) {
            case UP: {
                meta = 1;
            }
            case DOWN: {
                if ((meta += horizontalFacing.func_176745_a() << 1) < 6) {
                    meta -= 4;
                }
                return meta;
            }
        }
        return facing.func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HORIZONTAL_FACING});
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        BlockPos pos = data.getPos();
        this.addProbeInfoScreen(mode, probeInfo, player, world, pos);
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfoScreen(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, BlockPos pos) {
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof ScreenTE) {
            return this.getWailaBodyScreen(currenttip, accessor.getPlayer(), (ScreenTE)te);
        }
        return Collections.emptyList();
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBodyScreen(List<String> currenttip, EntityPlayer player, ScreenTE te) {
        if (System.currentTimeMillis() - lastTime > 500L) {
            lastTime = System.currentTimeMillis();
        }
        return currenttip;
    }

    public void initModel() {
        ScreenRenderer.register();
        McJtyLib.proxy.initTESRItemStack(Item.func_150898_a((Block)this), 0, ScreenTE.class);
        super.initModel();
    }

    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer playerIn) {
        if (world.field_72995_K) {
            RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
            ScreenTE screenTE = (ScreenTE)world.func_175625_s(pos);
        }
    }

    private void setInvisibleBlockSafe(World world, BlockPos pos, int dx, int dy, int dz, EnumFacing facing) {
        int zz;
        int yy = pos.func_177956_o() + dy;
        if (yy < 0 || yy >= world.func_72800_K()) {
            return;
        }
        int xx = pos.func_177958_n() + dx;
        BlockPos posO = new BlockPos(xx, yy, zz = pos.func_177952_p() + dz);
        if (world.func_175623_d(posO)) {
            world.func_180501_a(posO, ModBlocks.screenHitBlock.func_176223_P().func_177226_a((IProperty)BaseBlock.FACING, (Comparable)facing), 3);
            ScreenHitTE screenHitTileEntity = (ScreenHitTE)world.func_175625_s(posO);
            screenHitTileEntity.setRelativeLocation(-dx, -dy, -dz);
        }
    }

    private void setInvisibleBlocks(World world, BlockPos pos, int size) {
        IBlockState state = world.func_180495_p(pos);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BaseBlock.FACING);
        EnumFacing horizontalFacing = (EnumFacing)state.func_177229_b((IProperty)HORIZONTAL_FACING);
        for (int i = 0; i <= size; ++i) {
            for (int j = 0; j <= size; ++j) {
                if (i == 0 && j == 0) continue;
                if (facing == EnumFacing.NORTH) {
                    this.setInvisibleBlockSafe(world, pos, -i, -j, 0, facing);
                    continue;
                }
                if (facing == EnumFacing.SOUTH) {
                    this.setInvisibleBlockSafe(world, pos, i, -j, 0, facing);
                    continue;
                }
                if (facing == EnumFacing.WEST) {
                    this.setInvisibleBlockSafe(world, pos, 0, -i, j, facing);
                    continue;
                }
                if (facing == EnumFacing.EAST) {
                    this.setInvisibleBlockSafe(world, pos, 0, -i, -j, facing);
                    continue;
                }
                if (facing == EnumFacing.UP) {
                    if (horizontalFacing == EnumFacing.NORTH) {
                        this.setInvisibleBlockSafe(world, pos, -i, 0, -j, facing);
                        continue;
                    }
                    if (horizontalFacing == EnumFacing.SOUTH) {
                        this.setInvisibleBlockSafe(world, pos, i, 0, j, facing);
                        continue;
                    }
                    if (horizontalFacing == EnumFacing.WEST) {
                        this.setInvisibleBlockSafe(world, pos, -i, 0, j, facing);
                        continue;
                    }
                    if (horizontalFacing != EnumFacing.EAST) continue;
                    this.setInvisibleBlockSafe(world, pos, i, 0, -j, facing);
                    continue;
                }
                if (facing != EnumFacing.DOWN) continue;
                if (horizontalFacing == EnumFacing.NORTH) {
                    this.setInvisibleBlockSafe(world, pos, -i, 0, j, facing);
                    continue;
                }
                if (horizontalFacing == EnumFacing.SOUTH) {
                    this.setInvisibleBlockSafe(world, pos, i, 0, -j, facing);
                    continue;
                }
                if (horizontalFacing == EnumFacing.WEST) {
                    this.setInvisibleBlockSafe(world, pos, i, 0, j, facing);
                    continue;
                }
                if (horizontalFacing != EnumFacing.EAST) continue;
                this.setInvisibleBlockSafe(world, pos, -i, 0, -j, facing);
            }
        }
    }

    private void clearInvisibleBlockSafe(World world, BlockPos pos) {
        if (pos.func_177956_o() < 0 || pos.func_177956_o() >= world.func_72800_K()) {
            return;
        }
        if (world.func_180495_p(pos).func_177230_c() == ModBlocks.screenHitBlock) {
            world.func_175698_g(pos);
        }
    }

    private void clearInvisibleBlocks(World world, BlockPos pos, IBlockState state, int size) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BaseBlock.FACING);
        EnumFacing horizontalFacing = (EnumFacing)state.func_177229_b((IProperty)HORIZONTAL_FACING);
        for (int i = 0; i <= size; ++i) {
            for (int j = 0; j <= size; ++j) {
                if (i == 0 && j == 0) continue;
                if (facing == EnumFacing.NORTH) {
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(-i, -j, 0));
                    continue;
                }
                if (facing == EnumFacing.SOUTH) {
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(i, -j, 0));
                    continue;
                }
                if (facing == EnumFacing.WEST) {
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(0, -i, j));
                    continue;
                }
                if (facing == EnumFacing.EAST) {
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(0, -i, -j));
                    continue;
                }
                if (facing == EnumFacing.UP) {
                    if (horizontalFacing == EnumFacing.NORTH) {
                        this.clearInvisibleBlockSafe(world, pos.func_177982_a(-i, 0, -j));
                        continue;
                    }
                    if (horizontalFacing == EnumFacing.SOUTH) {
                        this.clearInvisibleBlockSafe(world, pos.func_177982_a(i, 0, j));
                        continue;
                    }
                    if (horizontalFacing == EnumFacing.WEST) {
                        this.clearInvisibleBlockSafe(world, pos.func_177982_a(-i, 0, j));
                        continue;
                    }
                    if (horizontalFacing != EnumFacing.EAST) continue;
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(i, 0, -j));
                    continue;
                }
                if (facing != EnumFacing.DOWN) continue;
                if (horizontalFacing == EnumFacing.NORTH) {
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(-i, 0, j));
                    continue;
                }
                if (horizontalFacing == EnumFacing.SOUTH) {
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(i, 0, -j));
                    continue;
                }
                if (horizontalFacing == EnumFacing.WEST) {
                    this.clearInvisibleBlockSafe(world, pos.func_177982_a(i, 0, j));
                    continue;
                }
                if (horizontalFacing != EnumFacing.EAST) continue;
                this.clearInvisibleBlockSafe(world, pos.func_177982_a(-i, 0, -j));
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BaseBlock.FACING);
        if (facing == EnumFacing.NORTH) {
            return NORTH_AABB;
        }
        if (facing == EnumFacing.SOUTH) {
            return SOUTH_AABB;
        }
        if (facing == EnumFacing.WEST) {
            return WEST_AABB;
        }
        if (facing == EnumFacing.EAST) {
            return EAST_AABB;
        }
        if (facing == EnumFacing.UP) {
            return UP_AABB;
        }
        if (facing == EnumFacing.DOWN) {
            return DOWN_AABB;
        }
        return BLOCK_AABB;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int getGuiID() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public BiFunction<ScreenTE, ScreenContainer, GenericGuiContainer<? super ScreenTE>> getGuiFactory() {
        return ScreenGui::new;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        list.add(TextFormatting.WHITE + "Objective and interaction screen");
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        ScreenTE screenTileEntity;
        super.func_180633_a(world, pos, state, entityLivingBase, itemStack);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ScreenTE && (screenTileEntity = (ScreenTE)tileEntity).getSize().ordinal() > ScreenSize.NORMAL.ordinal()) {
            this.setInvisibleBlocks(world, pos, screenTileEntity.getSize().ordinal());
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        ScreenTE screenTileEntity;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ScreenTE && (screenTileEntity = (ScreenTE)te).getSize().ordinal() > ScreenSize.NORMAL.ordinal()) {
            this.clearInvisibleBlocks(world, pos, state, screenTileEntity.getSize().ordinal());
        }
        super.func_180663_b(world, pos, state);
    }
}

