/*
 * Decompiled with CFR 0.152.
 */
package mcjty.questutils.blocks.screen;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.ColorChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.TypedMap;
import mcjty.questutils.QuestUtils;
import mcjty.questutils.api.FormattedString;
import mcjty.questutils.api.TextAlignment;
import mcjty.questutils.blocks.QUTileEntity;
import mcjty.questutils.blocks.screen.ScreenContainer;
import mcjty.questutils.blocks.screen.ScreenTE;
import mcjty.questutils.network.QuestUtilsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;

public class ScreenGui
extends GenericGuiContainer<ScreenTE> {
    public static final int WIDTH = 243;
    public static final int HEIGHT = 238;
    private TextField iconField;
    private TextField fileField;
    private ColorChoiceLabel borderColor;
    private ColorChoiceLabel screenColor;
    private ToggleButton transp;
    private ChoiceLabel size;
    private static final ResourceLocation iconLocation = new ResourceLocation("questutils", "textures/gui/screen.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("questutils", "textures/gui/guielements.png");
    private final String[] SIZES = new String[]{"1x1", "2x2", "3x3", "4x4", "5x5"};

    public ScreenGui(ScreenTE tileEntity, ScreenContainer container) {
        super((ModBase)QuestUtils.instance, QuestUtilsMessages.INSTANCE, (GenericTileEntity)tileEntity, (Container)container, 0, "screen");
        this.field_146999_f = 243;
        this.field_147000_g = 238;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        TextField idField = (TextField)((TextField)new TextField(this.field_146297_k, (Gui)this).setName("id")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(40, 6, 173, 14));
        Panel stringPanel = (Panel)this.getStringPanel("Title", ScreenTE.PARAM_TITLE, ScreenTE.PARAM_TITLE_A, ScreenTE.PARAM_TITLE_C, ((ScreenTE)this.tileEntity).getTitle()).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(0, 22, 243, 14));
        this.iconField = (TextField)new TextField(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(40, 44, 144, 14));
        this.iconField.setText(((ScreenTE)this.tileEntity).getIcon() == null ? "" : ((ScreenTE)this.tileEntity).getIcon().toString());
        this.iconField.setTooltips(new String[]{"Resource name for", "the image to show", "Use the file below", "to load this from image"});
        this.iconField.addTextEvent((parent, newText) -> this.update());
        this.borderColor = (ColorChoiceLabel)new ColorChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(12, 200, 52, 14));
        for (EnumDyeColor color : EnumDyeColor.values()) {
            this.borderColor.addColors(new Integer[]{color.func_193350_e()});
        }
        this.borderColor.setTooltips(new String[]{"Set the color for the", "border around the items"});
        this.borderColor.setCurrentColor(Integer.valueOf(((ScreenTE)this.tileEntity).getBorderColor()));
        this.borderColor.addChoiceEvent((parent, newColor) -> this.update());
        this.transp = (ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(213, 44, 20, 14));
        this.transp.setTooltips(new String[]{"Transparency mode"});
        this.transp.setCheckMarker(true);
        this.transp.setPressed(((ScreenTE)this.tileEntity).isTransparent());
        this.transp.addButtonEvent(parent -> this.update());
        this.screenColor = (ColorChoiceLabel)new ColorChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(190, 44, 20, 14));
        for (EnumDyeColor color : EnumDyeColor.values()) {
            this.screenColor.addColors(new Integer[]{color.func_193350_e()});
        }
        this.screenColor.setTooltips(new String[]{"Set the color for", "the screen"});
        this.screenColor.setCurrentColor(Integer.valueOf(((ScreenTE)this.tileEntity).getBackgroundColor()));
        this.screenColor.addChoiceEvent((parent, newColor) -> this.update());
        this.fileField = (TextField)new TextField(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(40, 60, 144, 14));
        this.fileField.setTooltips(new String[]{"Filename for the image", "to show"});
        this.fileField.setText(((ScreenTE)this.tileEntity).getFilename() == null ? "" : ((ScreenTE)this.tileEntity).getFilename());
        this.fileField.addTextEvent((parent, newText) -> this.update());
        this.size = (ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(this.SIZES).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(190, 58, 43, 14));
        this.size.setChoice(this.SIZES[((ScreenTE)this.tileEntity).getSize().ordinal()]);
        this.size.addChoiceEvent((parent, newChoice) -> this.update());
        Panel status0Panel = (Panel)this.getStringPanel("Stat0", ScreenTE.PARAM_STATUS0, ScreenTE.PARAM_STATUS0_A, ScreenTE.PARAM_STATUS0_C, ((ScreenTE)this.tileEntity).getStatus()[0]).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(0, 82, 243, 14));
        Panel status1Panel = (Panel)this.getStringPanel("Stat1", ScreenTE.PARAM_STATUS1, ScreenTE.PARAM_STATUS1_A, ScreenTE.PARAM_STATUS1_C, ((ScreenTE)this.tileEntity).getStatus()[1]).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(0, 100, 243, 14));
        Panel status2Panel = (Panel)this.getStringPanel("Stat2", ScreenTE.PARAM_STATUS2, ScreenTE.PARAM_STATUS2_A, ScreenTE.PARAM_STATUS2_C, ((ScreenTE)this.tileEntity).getStatus()[2]).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(0, 118, 243, 14));
        Panel toplevel = (Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChild((Widget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setText("ID")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(12, 6, 26, 14))).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT))).addChild((Widget)idField)).addChild((Widget)this.iconField)).addChild((Widget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setText("Icon")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(12, 44, 26, 14))).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT))).addChild((Widget)this.fileField)).addChild((Widget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setText("File")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(12, 60, 26, 14))).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT))).addChild((Widget)this.borderColor)).addChild((Widget)this.screenColor)).addChild((Widget)this.transp)).addChild((Widget)this.size)).addChild((Widget)stringPanel)).addChild((Widget)status0Panel)).addChild((Widget)status1Panel)).addChild((Widget)status2Panel);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
        this.window.bind(QuestUtilsMessages.INSTANCE, "id", this.tileEntity, QUTileEntity.VALUE_ID.getName());
    }

    private Panel getStringPanel(String label, Key<String> titleKey, Key<Integer> alignKey, Key<Integer> colorKey, FormattedString string) {
        Panel panel = new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout());
        panel.addChild((Widget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setText(label)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(12, 0, 26, 14))).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT));
        TextField fld = (TextField)new TextField(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(40, 0, 144, 14));
        fld.setText(string == null ? "" : string.getText());
        ChoiceLabel choice = (ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(new String[]{"L", "C", "R"}).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(190, 0, 20, 14));
        if (string != null) {
            switch (string.getAlignment()) {
                case LEFT: {
                    choice.setChoice("L");
                    break;
                }
                case CENTER: {
                    choice.setChoice("C");
                    break;
                }
                case RIGHT: {
                    choice.setChoice("R");
                }
            }
        }
        ColorChoiceLabel colorChoice = (ColorChoiceLabel)new ColorChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(214, 0, 20, 14));
        for (EnumDyeColor color : EnumDyeColor.values()) {
            colorChoice.addColors(new Integer[]{color.func_193350_e()});
        }
        if (string != null) {
            colorChoice.setCurrentColor(Integer.valueOf(string.getColor()));
        }
        panel.addChild((Widget)fld);
        panel.addChild((Widget)choice);
        panel.addChild((Widget)colorChoice);
        fld.addTextEvent((parent, newText) -> this.updateString(titleKey, alignKey, colorKey, fld.getText(), this.getAlignment(choice), colorChoice.getCurrentColor()));
        choice.addChoiceEvent((parent, newChoice) -> this.updateString(titleKey, alignKey, colorKey, fld.getText(), this.getAlignment(choice), colorChoice.getCurrentColor()));
        colorChoice.addChoiceEvent((parent, newColor) -> this.updateString(titleKey, alignKey, colorKey, fld.getText(), this.getAlignment(choice), colorChoice.getCurrentColor()));
        return panel;
    }

    private TextAlignment getAlignment(ChoiceLabel choice) {
        if ("L".equals(choice.getCurrentChoice())) {
            return TextAlignment.LEFT;
        }
        if ("C".equals(choice.getCurrentChoice())) {
            return TextAlignment.CENTER;
        }
        return TextAlignment.RIGHT;
    }

    private void update() {
        this.sendServerCommand(QuestUtilsMessages.INSTANCE, "screen.cmdUpdate", TypedMap.builder().put(ScreenTE.PARAM_COLOR, (Object)this.borderColor.getCurrentColor()).put(ScreenTE.PARAM_SCREEN, (Object)this.screenColor.getCurrentColor()).put(ScreenTE.PARAM_TRANSP, (Object)this.transp.isPressed()).put(ScreenTE.PARAM_SIZE, (Object)this.getSize()).put(ScreenTE.PARAM_ICON, (Object)this.iconField.getText()).put(ScreenTE.PARAM_FILE, (Object)this.fileField.getText()).build());
    }

    private int getSize() {
        return this.size.getCurrentChoice().charAt(0) - 49;
    }

    private void updateString(Key<String> titleKey, Key<Integer> alignKey, Key<Integer> colorKey, String title, TextAlignment alignment, int color) {
        this.sendServerCommand(QuestUtilsMessages.INSTANCE, "screen.cmdUpdateString", TypedMap.builder().put(titleKey, (Object)title).put(alignKey, (Object)alignment.ordinal()).put(colorKey, (Object)color).build());
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.drawWindow();
    }
}

