/*
 * Decompiled with CFR 0.152.
 */
package mcjty.questutils.blocks.screen;

import java.io.File;
import mcjty.lib.blocks.BaseBlock;
import mcjty.questutils.QuestUtils;
import mcjty.questutils.api.FormattedString;
import mcjty.questutils.blocks.ModBlocks;
import mcjty.questutils.blocks.screen.ScreenBlock;
import mcjty.questutils.blocks.screen.ScreenTE;
import mcjty.questutils.config.ConfigSetup;
import mcjty.questutils.rendering.ImageLoader;
import mcjty.questutils.rendering.RenderTools;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ScreenRenderer
extends TileEntitySpecialRenderer<ScreenTE> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("questutils", "textures/blocks/screenframe.png");
    private static final ItemStack[] STACKS = new ItemStack[9];

    public void render(ScreenTE tileEntity, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        float xRotation = 0.0f;
        float yRotation = 0.0f;
        EnumFacing facing = EnumFacing.SOUTH;
        EnumFacing horizontalFacing = EnumFacing.SOUTH;
        if (tileEntity != null) {
            IBlockState state = Minecraft.func_71410_x().field_71441_e.func_180495_p(tileEntity.func_174877_v());
            if (state.func_177230_c() instanceof ScreenBlock) {
                facing = (EnumFacing)state.func_177229_b((IProperty)BaseBlock.FACING);
                horizontalFacing = (EnumFacing)state.func_177229_b((IProperty)ScreenBlock.HORIZONTAL_FACING);
            } else {
                return;
            }
        }
        GlStateManager.func_179094_E();
        switch (horizontalFacing) {
            case NORTH: {
                yRotation = -180.0f;
                break;
            }
            case WEST: {
                yRotation = -90.0f;
                break;
            }
            case EAST: {
                yRotation = 90.0f;
            }
        }
        switch (facing) {
            case DOWN: {
                xRotation = 90.0f;
                break;
            }
            case UP: {
                xRotation = -90.0f;
            }
        }
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179114_b((float)yRotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)xRotation, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.4375f);
        if (tileEntity == null) {
            GlStateManager.func_179140_f();
            this.renderScreenBoard(0, 0);
        } else if (!tileEntity.isTransparent()) {
            GlStateManager.func_179140_f();
            this.renderScreenBoard(tileEntity.getSize().ordinal(), tileEntity.getBackgroundColor());
        }
        if (tileEntity != null) {
            FontRenderer fontrenderer = this.func_147498_b();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179140_f();
            this.renderModules(fontrenderer, tileEntity, tileEntity.getSize().ordinal());
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    private void renderModules(FontRenderer fontrenderer, ScreenTE tileEntity, int size) {
        float factor = (float)size + 1.0f;
        boolean moduleIndex = false;
        BlockPos pos = tileEntity.func_174877_v();
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        IBlockState blockState = this.func_178459_a().func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block != ModBlocks.screenBlock && block != ModBlocks.screenHitBlock) {
            return;
        }
        if (mouseOver != null && mouseOver.field_178784_b == blockState.func_177229_b((IProperty)BaseBlock.FACING)) {
            double xx = mouseOver.field_72307_f.field_72450_a - (double)pos.func_177958_n();
            double yy = mouseOver.field_72307_f.field_72448_b - (double)pos.func_177956_o();
            double zz = mouseOver.field_72307_f.field_72449_c - (double)pos.func_177952_p();
            EnumFacing enumFacing = (EnumFacing)blockState.func_177229_b((IProperty)ScreenBlock.HORIZONTAL_FACING);
        }
        if (ConfigSetup.BRIGHT_SCREENS) {
            Minecraft.func_71410_x().field_71460_t.func_175072_h();
        }
        this.renderTitle(tileEntity, factor);
        this.renderObjective(tileEntity, factor);
        this.renderStatus(tileEntity, factor);
        if (ConfigSetup.BRIGHT_SCREENS) {
            Minecraft.func_71410_x().field_71460_t.func_180436_i();
        }
    }

    private void renderTitle(ScreenTE tileEntity, float factor) {
        if (tileEntity.getTitle() != null) {
            String txt = tileEntity.getTitle().getText();
            int width = Minecraft.func_71410_x().field_71466_p.func_78256_a(txt);
            int textx = 4;
            switch (tileEntity.getTitle().getAlignment()) {
                case LEFT: {
                    break;
                }
                case CENTER: {
                    textx += (60 - width) / 2;
                    break;
                }
                case RIGHT: {
                    textx += 60 - width;
                }
            }
            RenderTools.renderText(textx, 8, txt, factor * 2.0f, tileEntity.getTitle().getColor());
        }
    }

    private void renderObjective(ScreenTE tileEntity, float factor) {
        ResourceLocation icon = tileEntity.getIcon();
        if (icon != null) {
            String filename = tileEntity.getFilename();
            if (filename != null && !filename.trim().isEmpty()) {
                File file = filename.startsWith("$") ? new File(QuestUtils.setup.getModConfigDir().getPath() + File.separator + filename.substring(1)) : new File(filename);
                ImageLoader.loadAndBind(icon, file);
            }
            RenderTools.renderIcon(15, 18, icon, factor, tileEntity.getBorderColor());
        } else {
            int i;
            int cnt = 0;
            for (i = 0; i < 9; ++i) {
                if (tileEntity.func_70301_a(0 + i).func_190926_b()) continue;
                ScreenRenderer.STACKS[cnt++] = tileEntity.func_70301_a(i);
            }
            for (i = cnt; i < 9; ++i) {
                ScreenRenderer.STACKS[i] = ItemStack.field_190927_a;
            }
            if (cnt <= 1) {
                RenderTools.renderItem(15, 18, STACKS[0], factor, tileEntity.getBorderColor());
            } else if (cnt <= 4) {
                float v = 0.5f;
                RenderTools.renderItem(25, 29, STACKS[0], factor * v, tileEntity.getBorderColor());
                RenderTools.renderItem(45, 29, STACKS[1], factor * v, tileEntity.getBorderColor());
                RenderTools.renderItem(25, 49, STACKS[2], factor * v, tileEntity.getBorderColor());
                RenderTools.renderItem(45, 49, STACKS[3], factor * v, tileEntity.getBorderColor());
            } else {
                float v = 0.3f;
                RenderTools.renderItem(43, 47, STACKS[0], factor * v, tileEntity.getBorderColor());
                RenderTools.renderItem(63, 47, STACKS[1], factor * v, tileEntity.getBorderColor());
                RenderTools.renderItem(83, 47, STACKS[2], factor * v, tileEntity.getBorderColor());
                RenderTools.renderItem(43, 67, STACKS[3], factor * v, tileEntity.getBorderColor());
                RenderTools.renderItem(63, 67, STACKS[4], factor * v, tileEntity.getBorderColor());
                RenderTools.renderItem(83, 67, STACKS[5], factor * v, tileEntity.getBorderColor());
                RenderTools.renderItem(43, 87, STACKS[6], factor * v, tileEntity.getBorderColor());
                RenderTools.renderItem(63, 87, STACKS[7], factor * v, tileEntity.getBorderColor());
                RenderTools.renderItem(83, 87, STACKS[8], factor * v, tileEntity.getBorderColor());
            }
        }
    }

    private void renderStatus(ScreenTE tileEntity, float factor) {
        FormattedString[] status = tileEntity.getStatus();
        int currenty = 95;
        for (FormattedString s : status) {
            if (s == null) continue;
            int width = Minecraft.func_71410_x().field_71466_p.func_78256_a(s.getText());
            int textx = 10;
            switch (s.getAlignment()) {
                case LEFT: {
                    break;
                }
                case CENTER: {
                    textx += (116 - width) / 2;
                    break;
                }
                case RIGHT: {
                    textx += 116 - width;
                }
            }
            RenderTools.renderText(textx, currenty, s.getText(), factor, s.getColor());
            currenty += 10;
        }
    }

    private void renderScreenBoard(int size, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        this.func_147499_a(TEXTURE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        float dim = (float)size + 0.46f;
        float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >> 8) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b((double)-0.46f, (double)dim, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)-0.46f, (double)-0.46f, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        renderer.func_181662_b((double)dim, (double)-0.46f, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        renderer.func_181662_b((double)dim, (double)dim, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)-0.46f, (double)dim, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)dim, (double)dim, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)dim, (double)dim, -0.1).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)-0.46f, (double)dim, -0.1).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)-0.46f, (double)-0.46f, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)-0.46f, (double)-0.46f, -0.1).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)dim, (double)-0.46f, -0.1).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)dim, (double)-0.46f, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)-0.46f, (double)-0.46f, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)-0.46f, (double)dim, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)-0.46f, (double)dim, -0.1).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)-0.46f, (double)-0.46f, -0.1).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)dim, (double)-0.46f, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)dim, (double)-0.46f, -0.1).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)dim, (double)dim, -0.1).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)dim, (double)dim, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        float z = -0.08f;
        renderer.func_181662_b((double)-0.46f, (double)dim, (double)z).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b((double)dim, (double)dim, (double)z).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b((double)dim, (double)-0.46f, (double)z).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b((double)-0.46f, (double)-0.46f, (double)z).func_181666_a(r, g, b, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    public static void register() {
        ClientRegistry.bindTileEntitySpecialRenderer(ScreenTE.class, (TileEntitySpecialRenderer)new ScreenRenderer());
    }
}

