/*
 * Decompiled with CFR 0.152.
 */
package mcjty.questutils.blocks.screen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import mcjty.lib.bindings.DefaultAction;
import mcjty.lib.bindings.IAction;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.questutils.api.FormattedString;
import mcjty.questutils.api.IScreen;
import mcjty.questutils.api.ScreenSize;
import mcjty.questutils.api.TextAlignment;
import mcjty.questutils.blocks.QUTileEntity;
import mcjty.questutils.blocks.screen.ScreenContainer;
import mcjty.questutils.json.JsonTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ScreenTE
extends QUTileEntity
implements DefaultSidedInventory,
IScreen {
    public static final String ACTION_CLICK = "click";
    public static final String ACTION_HOVER = "hover";
    public static final String CMD_UPDATE = "screen.cmdUpdate";
    public static final Key<Integer> PARAM_COLOR = new Key("color", Type.INTEGER);
    public static final Key<Integer> PARAM_SCREEN = new Key("screen", Type.INTEGER);
    public static final Key<Integer> PARAM_SIZE = new Key("size", Type.INTEGER);
    public static final Key<String> PARAM_ICON = new Key("icon", Type.STRING);
    public static final Key<String> PARAM_FILE = new Key("file", Type.STRING);
    public static final Key<Boolean> PARAM_TRANSP = new Key("transp", Type.BOOLEAN);
    public static final String CMD_UPDATE_STRING = "screen.cmdUpdateString";
    public static final Key<String> PARAM_TITLE = new Key("title", Type.STRING);
    public static final Key<Integer> PARAM_TITLE_A = new Key("titleA", Type.INTEGER);
    public static final Key<Integer> PARAM_TITLE_C = new Key("titleC", Type.INTEGER);
    public static final Key<String> PARAM_STATUS0 = new Key("status0", Type.STRING);
    public static final Key<Integer> PARAM_STATUS0_A = new Key("status0A", Type.INTEGER);
    public static final Key<Integer> PARAM_STATUS0_C = new Key("status0C", Type.INTEGER);
    public static final Key<String> PARAM_STATUS1 = new Key("status1", Type.STRING);
    public static final Key<Integer> PARAM_STATUS1_A = new Key("status1A", Type.INTEGER);
    public static final Key<Integer> PARAM_STATUS1_C = new Key("status1C", Type.INTEGER);
    public static final Key<String> PARAM_STATUS2 = new Key("status2", Type.STRING);
    public static final Key<Integer> PARAM_STATUS2_A = new Key("status2A", Type.INTEGER);
    public static final Key<Integer> PARAM_STATUS2_C = new Key("status2C", Type.INTEGER);
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, ScreenContainer.factory, 9);
    private FormattedString title;
    private FormattedString[] status = new FormattedString[3];
    private ResourceLocation icon;
    private String filename;
    private ScreenSize size = ScreenSize.NORMAL;
    private boolean transparent = false;
    private int color = 0;
    private int borderColor = EnumDyeColor.BROWN.func_193350_e();
    private int trueTypeMode = 0;

    public IAction[] getActions() {
        return new IAction[]{new DefaultAction(ACTION_CLICK, () -> {}), new DefaultAction(ACTION_HOVER, () -> {})};
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    @Override
    public String getID() {
        return this.getIdentifier();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        int s = this.size.ordinal();
        return new AxisAlignedBB((double)(xCoord - s - 1), (double)(yCoord - s - 1), (double)(zCoord - s - 1), (double)(xCoord + s + 1), (double)(yCoord + s + 1), (double)(zCoord + s + 1));
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public void setIcon(ResourceLocation icon, String filename) {
        this.icon = icon;
        this.filename = filename == null || filename.trim().isEmpty() ? null : filename;
        this.markDirtyClient();
    }

    @Override
    public void setTitle(String title, TextAlignment alignment, int color) {
        this.title = title == null || title.trim().isEmpty() ? null : new FormattedString(title, alignment, color);
        this.markDirtyClient();
    }

    @Override
    public void setTitle(FormattedString title) {
        this.title = title;
        this.markDirtyClient();
    }

    @Override
    public void setStatus(int idx, String status, TextAlignment alignment, int color) {
        this.status[idx] = status == null || status.trim().isEmpty() ? null : new FormattedString(status, alignment, color);
        this.markDirtyClient();
    }

    @Override
    public void setStatus(int idx, FormattedString status) {
        this.status[idx] = status;
        this.markDirtyClient();
    }

    @Override
    public FormattedString getTitle() {
        return this.title;
    }

    @Override
    public FormattedString[] getStatus() {
        return this.status;
    }

    private void checkStateClient() {
    }

    private void checkStateServer() {
    }

    public int[] func_180463_a(EnumFacing side) {
        return ScreenContainer.factory.getAccessibleSlots();
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return ScreenContainer.factory.isOutputSlot(index);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return ScreenContainer.factory.isInputSlot(index);
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    @Override
    public IItemHandler getItemHandler() {
        return (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    @Override
    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.size = ScreenSize.values()[tagCompound.func_74762_e("size")];
        this.transparent = tagCompound.func_74767_n("transparent");
        this.color = tagCompound.func_74762_e("color");
        this.borderColor = tagCompound.func_74762_e("borderColor");
        this.trueTypeMode = tagCompound.func_74762_e("truetype");
        this.title = this.getFormattedStringFromNBT(tagCompound, "title");
        this.status[0] = this.getFormattedStringFromNBT(tagCompound, "stat0");
        this.status[1] = this.getFormattedStringFromNBT(tagCompound, "stat1");
        this.status[2] = this.getFormattedStringFromNBT(tagCompound, "stat2");
        String iconString = tagCompound.func_74779_i("icon");
        this.icon = iconString.trim().isEmpty() ? null : new ResourceLocation(iconString);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    @Override
    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74768_a("size", this.size.ordinal());
        tagCompound.func_74757_a("transparent", this.transparent);
        tagCompound.func_74768_a("color", this.color);
        tagCompound.func_74768_a("borderColor", this.borderColor);
        tagCompound.func_74768_a("truetype", this.trueTypeMode);
        this.writeFormattedStringToNBT(tagCompound, "title", this.title);
        this.writeFormattedStringToNBT(tagCompound, "stat0", this.status[0]);
        this.writeFormattedStringToNBT(tagCompound, "stat1", this.status[1]);
        this.writeFormattedStringToNBT(tagCompound, "stat2", this.status[2]);
        if (this.icon != null) {
            tagCompound.func_74778_a("icon", this.icon.toString());
        }
    }

    private FormattedString getFormattedStringFromNBT(NBTTagCompound tagCompound, String prefix) {
        if (tagCompound.func_74764_b(prefix)) {
            return new FormattedString(tagCompound.func_74779_i(prefix), TextAlignment.values()[tagCompound.func_74771_c(prefix + "A")], tagCompound.func_74762_e(prefix + "C"));
        }
        return null;
    }

    private void writeFormattedStringToNBT(NBTTagCompound tagCompound, String prefix, FormattedString string) {
        if (string != null) {
            tagCompound.func_74778_a(prefix, string.getText());
            tagCompound.func_74774_a(prefix + "A", (byte)string.getAlignment().ordinal());
            tagCompound.func_74768_a(prefix + "C", string.getColor());
        }
    }

    @Override
    public int getBorderColor() {
        return this.borderColor;
    }

    @Override
    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        this.markDirtyClient();
    }

    @Override
    public int getBackgroundColor() {
        return this.color;
    }

    @Override
    public void setBackgroundColor(int color) {
        this.color = color;
        this.markDirtyClient();
    }

    @Override
    public void setSize(ScreenSize size) {
        this.size = size;
        this.markDirtyClient();
    }

    public int getTrueTypeMode() {
        return this.trueTypeMode;
    }

    public void setTrueTypeMode(int trueTypeMode) {
        this.trueTypeMode = trueTypeMode;
        this.markDirtyClient();
    }

    @Override
    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
        this.markDirtyClient();
    }

    @Override
    public ScreenSize getSize() {
        return this.size;
    }

    @Override
    public boolean isTransparent() {
        return this.transparent;
    }

    @Override
    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    @Override
    public World getScreenWorld() {
        return this.field_145850_b;
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_UPDATE.equals(command)) {
            Integer color = (Integer)params.get(PARAM_COLOR);
            this.setBorderColor(color);
            Integer screen = (Integer)params.get(PARAM_SCREEN);
            this.setBackgroundColor(screen);
            String iconString = (String)params.get(PARAM_ICON);
            String fileName = (String)params.get(PARAM_FILE);
            boolean transp = (Boolean)params.get(PARAM_TRANSP);
            this.setTransparent(transp);
            int s = (Integer)params.get(PARAM_SIZE);
            this.setSize(ScreenSize.values()[s]);
            this.setIcon(iconString.trim().isEmpty() ? null : new ResourceLocation(iconString), fileName.trim().isEmpty() ? null : fileName);
            this.markDirtyClient();
            return true;
        }
        if (CMD_UPDATE_STRING.equals(command)) {
            if (params.get(PARAM_TITLE) != null) {
                this.setTitle((String)params.get(PARAM_TITLE), TextAlignment.values()[(Integer)params.get(PARAM_TITLE_A)], (Integer)params.get(PARAM_TITLE_C));
            }
            if (params.get(PARAM_STATUS0) != null) {
                this.setStatus(0, (String)params.get(PARAM_STATUS0), TextAlignment.values()[(Integer)params.get(PARAM_STATUS0_A)], (Integer)params.get(PARAM_STATUS0_C));
            }
            if (params.get(PARAM_STATUS1) != null) {
                this.setStatus(1, (String)params.get(PARAM_STATUS1), TextAlignment.values()[(Integer)params.get(PARAM_STATUS1_A)], (Integer)params.get(PARAM_STATUS1_C));
            }
            if (params.get(PARAM_STATUS2) != null) {
                this.setStatus(2, (String)params.get(PARAM_STATUS2), TextAlignment.values()[(Integer)params.get(PARAM_STATUS2_A)], (Integer)params.get(PARAM_STATUS2_C));
            }
            this.markDirtyClient();
            return true;
        }
        return false;
    }

    @Override
    public void writeToJson(JsonObject object) {
        super.writeToJson(object);
        if (this.hasIdentifier()) {
            object.add("color", (JsonElement)new JsonPrimitive((Number)this.color));
            object.add("borderColor", (JsonElement)new JsonPrimitive((Number)this.borderColor));
            if (this.title != null) {
                object.add("title", (JsonElement)this.writeFormattedStringToJson(this.title));
            }
            if (this.status[0] != null) {
                object.add("status0", (JsonElement)this.writeFormattedStringToJson(this.status[0]));
            }
            if (this.status[1] != null) {
                object.add("status1", (JsonElement)this.writeFormattedStringToJson(this.status[1]));
            }
            if (this.status[2] != null) {
                object.add("status2", (JsonElement)this.writeFormattedStringToJson(this.status[2]));
            }
            if (this.icon != null) {
                object.add("icon", (JsonElement)new JsonPrimitive(this.icon.toString()));
            }
            object.add("items", (JsonElement)JsonTools.writeItemsToJson(this.getInventoryHelper(), 0, 9));
        }
    }

    @Override
    public void readFromJson(JsonObject object) {
        super.readFromJson(object);
        if (object.has("color")) {
            this.color = object.get("color").getAsInt();
        }
        if (object.has("borderColor")) {
            this.borderColor = object.get("borderColor").getAsInt();
        }
        this.title = this.getFormattedStringFromJson(object, "title");
        this.status[0] = this.getFormattedStringFromJson(object, "status0");
        this.status[1] = this.getFormattedStringFromJson(object, "status1");
        this.status[2] = this.getFormattedStringFromJson(object, "status2");
        if (object.has("icon")) {
            this.icon = new ResourceLocation(object.get("icon").getAsString());
        }
        if (object.has("items")) {
            JsonTools.readItemsFromJson(object.getAsJsonArray("items"), this.getInventoryHelper(), 0, 9);
        }
        this.markDirtyClient();
    }

    private JsonObject writeFormattedStringToJson(FormattedString str) {
        JsonObject obj = new JsonObject();
        obj.add("text", (JsonElement)new JsonPrimitive(str.getText()));
        obj.add("alignment", (JsonElement)new JsonPrimitive((Number)str.getAlignment().ordinal()));
        obj.add("color", (JsonElement)new JsonPrimitive((Number)str.getColor()));
        return obj;
    }

    private FormattedString getFormattedStringFromJson(JsonObject obj, String tag) {
        if (obj.has(tag)) {
            JsonObject object = obj.get("tag").getAsJsonObject();
            return new FormattedString(object.get("text").getAsString(), TextAlignment.values()[object.get("alignment").getAsInt()], object.get("color").getAsInt());
        }
        return null;
    }
}

