/*
 * Decompiled with CFR 0.152.
 */
package mcjty.questutils.commands;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import mcjty.lib.varia.BlockPosTools;
import mcjty.questutils.QuestUtils;
import mcjty.questutils.commands.ICommandHandler;
import mcjty.questutils.data.QUData;
import mcjty.questutils.data.QUEntry;
import mcjty.questutils.json.JsonPersistance;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;

public class CmdQU
extends CommandBase {
    private static final Map<String, ICommandHandler> COMMANDS = new HashMap<String, ICommandHandler>();

    public String func_71517_b() {
        return "qu";
    }

    public String func_71518_a(ICommandSender sender) {
        return "qu help: for more info";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length <= 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Too few arguments!"));
            return;
        }
        String cmd = args[0].toLowerCase();
        ICommandHandler handler = COMMANDS.get(cmd);
        if (handler == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Unknown subcommand!"));
            return;
        }
        handler.execute(sender, args);
    }

    private static void help(ICommandSender sender, String[] args) {
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "qu list [ <matcher> [ <positional> ] ]"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "qu load <file> [ <matcher> [ <positional> ] ]"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "qu save <file> [ <matcher> [ <positional> ] ]"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + ""));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "<matcher> is a wildcard string (using . and *)"));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "<positional> is either a radius or <x>,<y>,<z>[,<dim>]@radius"));
    }

    private static void list(ICommandSender sender, String[] args) {
        Predicate<String> matcher = CmdQU.getMatcher(args, 1);
        BiPredicate<Integer, BlockPos> radiusMatcher = CmdQU.getRadiusMatcher(sender, args, 2);
        if (radiusMatcher == null) {
            return;
        }
        for (Map.Entry<String, QUEntry> entry : QUData.getData().getEntries().entrySet()) {
            QUEntry qu;
            if (!matcher.test(entry.getKey()) || !radiusMatcher.test((qu = entry.getValue()).getDimension(), qu.getPos())) continue;
            sender.func_145747_a((ITextComponent)new TextComponentString("Id: " + entry.getKey() + " at " + BlockPosTools.toString((BlockPos)qu.getPos()) + " (" + qu.getDimension() + ")"));
        }
    }

    private static void save(ICommandSender sender, String[] args) {
        String filename = args[1];
        File file = new File(QuestUtils.setup.getModConfigDir().getPath(), filename);
        Predicate<String> matcher = CmdQU.getMatcher(args, 2);
        BiPredicate<Integer, BlockPos> radiusMatcher = CmdQU.getRadiusMatcher(sender, args, 3);
        if (radiusMatcher == null) {
            return;
        }
        JsonPersistance.write(file, matcher, sender, radiusMatcher);
    }

    private static void load(ICommandSender sender, String[] args) {
        String filename = args[1];
        File file = new File(QuestUtils.setup.getModConfigDir().getPath(), filename);
        if (!file.exists()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Cannot load file!"));
            return;
        }
        Predicate<String> matcher = CmdQU.getMatcher(args, 2);
        BiPredicate<Integer, BlockPos> radiusMatcher = CmdQU.getRadiusMatcher(sender, args, 3);
        if (radiusMatcher == null) {
            return;
        }
        JsonPersistance.read(file, matcher, sender, radiusMatcher);
    }

    private static Predicate<String> getMatcher(String[] args, int index) {
        if (index >= args.length) {
            return s -> true;
        }
        String re = args[index].replace(".", "[.]").replace("*", ".*");
        Pattern pattern = Pattern.compile(re);
        return s -> pattern.matcher((CharSequence)s).matches();
    }

    private static BiPredicate<Integer, BlockPos> getRadiusMatcher(ICommandSender sender, String[] args, int index) {
        if (index >= args.length) {
            return (dimension, pos) -> true;
        }
        try {
            int senderDim = sender.func_130014_f_().field_73011_w.getDimension();
            BlockPos senderPos = sender.func_180425_c();
            int radius = Integer.parseInt(args[index]);
            int sqRadius = radius * radius;
            return (dimension, pos) -> senderDim == dimension && senderPos.func_177951_i((Vec3i)pos) <= (double)sqRadius;
        }
        catch (NumberFormatException e) {
            String[] split = StringUtils.split((String)args[index], (char)'@');
            if (split.length != 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Badly formed radius!"));
                return null;
            }
            String[] possplit = StringUtils.split((String)split[0], (char)',');
            if (possplit.length < 3 || possplit.length > 4) {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Badly formed radius!"));
                return null;
            }
            BlockPos argPos = new BlockPos(Integer.parseInt(possplit[0]), Integer.parseInt(possplit[1]), Integer.parseInt(possplit[2]));
            int argDim = sender.func_130014_f_().field_73011_w.getDimension();
            if (possplit.length == 4) {
                argDim = Integer.parseInt(possplit[3]);
            }
            int radius = Integer.parseInt(split[1]);
            int sqRadius = radius * radius;
            int finalArgDim = argDim;
            return (dimension, pos) -> finalArgDim == dimension && argPos.func_177951_i((Vec3i)pos) <= (double)sqRadius;
        }
    }

    static {
        COMMANDS.put("help", CmdQU::help);
        COMMANDS.put("list", CmdQU::list);
        COMMANDS.put("save", CmdQU::save);
        COMMANDS.put("load", CmdQU::load);
    }
}

