/*
 * Decompiled with CFR 0.152.
 */
package mcjty.questutils.data;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.questutils.data.QUEntry;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.Pair;

public class QUData
extends AbstractWorldData<QUData> {
    private static final String NAME = "QUData";
    private Map<String, QUEntry> entries = new HashMap<String, QUEntry>();
    private Map<Pair<Integer, BlockPos>, QUEntry> entriesByPosition = new HashMap<Pair<Integer, BlockPos>, QUEntry>();

    public QUData(String name) {
        super(name);
    }

    public void clear() {
        this.entries.clear();
        this.entriesByPosition.clear();
    }

    public static QUData getData() {
        return (QUData)QUData.getData(QUData.class, (String)NAME);
    }

    public Map<String, QUEntry> getEntries() {
        return this.entries;
    }

    public void updateEntry(String id, int dimension, BlockPos pos) {
        this.removeEntry(id);
        if (!id.trim().isEmpty()) {
            QUEntry entry = new QUEntry(id, dimension, pos);
            this.entries.put(id, entry);
            this.entriesByPosition.put((Pair<Integer, BlockPos>)Pair.of((Object)dimension, (Object)pos), entry);
            this.save();
        }
    }

    public void removeEntry(String id) {
        QUEntry entry = this.entries.get(id);
        if (entry != null) {
            this.entriesByPosition.remove(Pair.of((Object)entry.getDimension(), (Object)entry.getPos()));
            this.entries.remove(id);
            this.save();
        }
    }

    public void removeEntry(int dim, BlockPos pos) {
        QUEntry entry = this.entriesByPosition.get(Pair.of((Object)dim, (Object)pos));
        if (entry != null) {
            this.entries.remove(entry.getId());
            this.entriesByPosition.remove(Pair.of((Object)dim, (Object)pos));
            this.save();
        }
    }

    public QUEntry getEntry(int dimension, BlockPos pos) {
        return this.entriesByPosition.get(Pair.of((Object)dimension, (Object)pos));
    }

    public QUEntry getEntry(String id) {
        return this.entries.get(id);
    }

    public void func_76184_a(NBTTagCompound compound) {
        this.entries.clear();
        this.entriesByPosition.clear();
        NBTTagList list = compound.func_150295_c("entries", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            String id = tag.func_74779_i("id");
            int dim = tag.func_74762_e("dim");
            BlockPos pos = BlockPos.func_177969_a((long)tag.func_74763_f("pos"));
            QUEntry entry = new QUEntry(id, dim, pos);
            this.entries.put(id, entry);
            this.entriesByPosition.put((Pair<Integer, BlockPos>)Pair.of((Object)dim, (Object)pos), entry);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<String, QUEntry> entry : this.entries.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("id", entry.getKey());
            tag.func_74768_a("dim", entry.getValue().getDimension());
            tag.func_74772_a("pos", entry.getValue().getPos().func_177986_g());
            list.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("entries", (NBTBase)list);
        return compound;
    }
}

