/*
 * Decompiled with CFR 0.152.
 */
package mcjty.questutils.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import mcjty.lib.varia.Logging;
import mcjty.questutils.blocks.QUTileEntity;
import mcjty.questutils.data.QUData;
import mcjty.questutils.data.QUEntry;
import net.minecraft.command.ICommandSender;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class JsonPersistance {
    private static JsonObject getJsonObject(String id) {
        QUTileEntity te = JsonPersistance.getQUTile(id);
        if (te != null && te.hasIdentifier()) {
            JsonObject object = new JsonObject();
            te.writeToJson(object);
            return object;
        }
        System.out.println("Id '" + id + "' does not seem to correspond to a QU block or doesn't have an identifier!");
        return null;
    }

    public static QUTileEntity getQUTile(String id) {
        TileEntity te;
        QUEntry entry = QUData.getData().getEntry(id);
        if (entry == null) {
            return null;
        }
        WorldServer world = DimensionManager.getWorld((int)entry.getDimension());
        if (world == null) {
            world = DimensionManager.getWorld((int)0).func_73046_m().func_71218_a(entry.getDimension());
        }
        if ((te = world.func_175625_s(entry.getPos())) instanceof QUTileEntity) {
            return (QUTileEntity)te;
        }
        return null;
    }

    public static void write(File file, Predicate<String> matcher, ICommandSender sender, BiPredicate<Integer, BlockPos> radiusMatcher) {
        PrintWriter writer;
        try {
            writer = new PrintWriter(file);
        }
        catch (FileNotFoundException e) {
            Logging.logError((String)("Error writing " + file.getName()));
            return;
        }
        JsonArray array = new JsonArray();
        Map<String, QUEntry> entries = QUData.getData().getEntries();
        for (String id : entries.keySet()) {
            JsonObject object;
            QUEntry entry;
            if (!matcher.test(id) || !radiusMatcher.test((entry = entries.get(id)).getDimension(), entry.getPos()) || (object = JsonPersistance.getJsonObject(id)) == null) continue;
            array.add((JsonElement)object);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        writer.print(gson.toJson((JsonElement)array));
        writer.close();
        sender.func_145747_a((ITextComponent)new TextComponentString("Saved " + array.size() + " objects"));
    }

    public static void read(File file, Predicate<String> matcher, ICommandSender sender, BiPredicate<Integer, BlockPos> radiusMatcher) {
        BufferedReader br;
        FileInputStream inputstream;
        try {
            inputstream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            Logging.log((String)("Note: No file " + file.getName()));
            return;
        }
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)inputstream, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Logging.logError((String)("Error reading file: " + file.getName()));
            return;
        }
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse((Reader)br);
        for (JsonElement entry : element.getAsJsonArray()) {
            QUTileEntity te;
            JsonObject object = entry.getAsJsonObject();
            String id = object.get("id").getAsString();
            if (!matcher.test(id)) continue;
            QUEntry qu = QUData.getData().getEntry(id);
            if (qu == null) {
                System.out.println("Cannot find id '" + id + "'!");
                continue;
            }
            if (!radiusMatcher.test(qu.getDimension(), qu.getPos()) || (te = JsonPersistance.getQUTile(id)) == null) continue;
            te.readFromJson(object);
        }
    }
}

