/*
 * Decompiled with CFR 0.152.
 */
package mcjty.questutils.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import mcjty.lib.container.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class JsonTools {
    public static JsonObject itemStackToJson(ItemStack item) {
        JsonObject object = new JsonObject();
        object.add("item", (JsonElement)new JsonPrimitive(item.func_77973_b().getRegistryName().toString()));
        if (item.func_190916_E() != 1) {
            object.add("amount", (JsonElement)new JsonPrimitive((Number)item.func_190916_E()));
        }
        if (item.func_77952_i() != 0) {
            object.add("meta", (JsonElement)new JsonPrimitive((Number)item.func_77952_i()));
        }
        if (item.func_77942_o()) {
            String string = item.func_77978_p().toString();
            object.add("nbt", (JsonElement)new JsonPrimitive(string));
        }
        return object;
    }

    public static ItemStack jsonToItemStack(JsonObject obj) {
        String itemName = obj.get("item").getAsString();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        int amount = 1;
        if (obj.has("amount")) {
            amount = obj.get("amount").getAsInt();
        }
        int meta = 0;
        if (obj.has("meta")) {
            meta = obj.get("meta").getAsInt();
        }
        ItemStack stack = new ItemStack(item, amount, meta);
        if (obj.has("nbt")) {
            try {
                NBTTagCompound nbt = JsonToNBT.func_180713_a((String)obj.get("nbt").getAsString());
                stack.func_77982_d(nbt);
            }
            catch (NBTException nBTException) {
                // empty catch block
            }
        }
        return stack;
    }

    public static JsonArray writeItemsToJson(InventoryHelper helper, int start, int end) {
        JsonArray array = new JsonArray();
        for (int i = start; i < end; ++i) {
            ItemStack stack = helper.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            JsonObject itemJson = JsonTools.itemStackToJson(stack);
            array.add((JsonElement)itemJson);
        }
        return array;
    }

    public static void readItemsFromJson(JsonArray array, InventoryHelper helper, int start, int end) {
        for (int i = start; i < end; ++i) {
            helper.setStackInSlot(i, ItemStack.field_190927_a);
        }
        int idx = start;
        for (JsonElement element : array) {
            helper.setStackInSlot(idx++, JsonTools.jsonToItemStack(element.getAsJsonObject()));
        }
    }
}

