/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags.handler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mal.lootbags.LootbagsUtil;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class InventoryDumpCommand
implements ICommand {
    private List aliases = new ArrayList();
    private Random random = new Random();

    public InventoryDumpCommand() {
        this.aliases.add("lootbags_dumpinventory");
    }

    public String func_71517_b() {
        return "/lootbags_dumpinventory";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/lootbags_dumpinventory";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender icommand, String[] args) throws CommandException {
        EntityPlayer player = null;
        if (!(icommand instanceof EntityPlayer)) {
            icommand.func_145747_a((ITextComponent)new TextComponentString("Lootbags Inventory Dump Failed: Did not recognize command sender as a player."));
            return;
        }
        player = (EntityPlayer)icommand;
        ArrayList stacks = new ArrayList();
        stacks.addAll(player.field_71071_by.field_70462_a);
        stacks.addAll(player.field_71071_by.field_184439_c);
        boolean flag = true;
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            flag = false;
        }
        if (stacks.isEmpty() || flag) {
            icommand.func_145747_a((ITextComponent)new TextComponentString("Lootbags Inventory Dump Failed: Player has no items in inventory."));
            return;
        }
        try {
            File file = new File(icommand.func_184102_h().func_71238_n(), "dumps/LootBagsInventoryDump.txt");
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            PrintWriter write = new PrintWriter(file);
            for (ItemStack stack : stacks) {
                if (stack.func_190926_b()) continue;
                byte[] barray = new byte[]{};
                if (stack.func_77942_o()) {
                    try {
                        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                        CompressedStreamTools.func_74799_a((NBTTagCompound)stack.func_77978_p(), (OutputStream)ostream);
                        barray = ostream.toByteArray();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                String s = "";
                ResourceLocation id = stack.func_77973_b().getRegistryName();
                s = id.func_110624_b() + ":" + id.func_110623_a() + ":" + stack.func_77952_i() + ":" + stack.func_190916_E() + ":" + stack.func_77976_d() + ":20";
                if (barray != null) {
                    s = s + ":";
                    for (byte b : barray) {
                        s = s + b + "|";
                    }
                }
                s = s.substring(0, s.length() - 1);
                write.println(s);
            }
            icommand.func_145747_a((ITextComponent)new TextComponentString("LootBags Inventory Dump Written - Look in your dumps folder"));
            write.close();
        }
        catch (Exception exception) {
            LootbagsUtil.LogError("Error in dumping sources... oh dear not again...");
            exception.printStackTrace();
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return null;
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public int compareTo(ICommand o) {
        return this.func_71517_b().compareTo(o.func_71517_b());
    }
}

