/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.item.stencil;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.IModelState;
import openblocks.OpenBlocks;
import openblocks.client.renderer.item.stencil.StencilTextureManager;
import openblocks.common.IStencilPattern;
import openblocks.common.item.ItemStencil;

public class StencilItemOverride
extends ItemOverrideList {
    public static final ResourceLocation BACKGROUND_TEXTURE = OpenBlocks.location("items/stencil");
    private final IModelState state;
    private final VertexFormat format;
    private final Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;
    private final IBakedModel emptyBakedModel;
    private final Map<IStencilPattern, IBakedModel> filledModels = Maps.newHashMap();

    public StencilItemOverride(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        super(Collections.emptyList());
        this.state = state;
        this.format = format;
        this.bakedTextureGetter = bakedTextureGetter;
        ResourceLocation emptyStencilTexture = StencilTextureManager.INSTANCE.getEmptyStencilTextureLocation(BACKGROUND_TEXTURE);
        this.emptyBakedModel = this.createItemModel(emptyStencilTexture);
    }

    private IBakedModel createItemModel(ResourceLocation texture) {
        return new ItemLayerModel(ImmutableList.of((Object)texture), (ItemOverrideList)this).bake(this.state, this.format, this.bakedTextureGetter);
    }

    public IBakedModel getEmptyModel() {
        return this.emptyBakedModel;
    }

    public IBakedModel handleItemState(IBakedModel originalModel, @Nonnull ItemStack stack, World world, EntityLivingBase entity) {
        Optional<IStencilPattern> pattern = ItemStencil.getPattern(stack);
        if (pattern.isPresent()) {
            return this.getModelForPattern(pattern.get());
        }
        return this.emptyBakedModel;
    }

    private IBakedModel getModelForPattern(IStencilPattern pattern) {
        IBakedModel model = this.filledModels.get(pattern);
        if (model == null) {
            model = this.bakeModel(pattern);
            this.filledModels.put(pattern, model);
        }
        return model;
    }

    private IBakedModel bakeModel(IStencilPattern pattern) {
        ResourceLocation stencilTexture = StencilTextureManager.INSTANCE.getStencilTextureLocation(BACKGROUND_TEXTURE, pattern);
        return this.createItemModel(stencilTexture);
    }
}

