/*
 * Decompiled with CFR 0.152.
 */
package austeretony.alternateui.screen.button;

import austeretony.alternateui.screen.core.GUIAdvancedElement;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class GUICheckBoxButton
extends GUIAdvancedElement<GUICheckBoxButton> {
    private int innerBoxSize;
    private int enabledInnerBoxColor = -13619152;
    private int disabledInnerBoxColor = -14671840;
    private int hoveredInnerBoxColor = -8026747;

    public GUICheckBoxButton(int xPosition, int yPosition, int sideSize) {
        this.setPosition(xPosition, yPosition);
        this.setSize(sideSize, sideSize);
        this.setInnerBoxSize(sideSize / 2);
        this.enableFull();
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            if (this.isTextureEnabled()) {
                int u = this.getTextureU();
                this.mc.func_110434_K().func_110577_a(this.getTexture());
                u = this.isHovered() || this.isToggled() ? (u += this.getTextureWidth() * 2) : (u += this.getTextureWidth());
                GlStateManager.func_179147_l();
                GUICheckBoxButton.drawCustomSizedTexturedRect((this.getWidth() - this.getTextureWidth()) / 2, (this.getHeight() - this.getTextureHeight()) / 2, u, this.getTextureV(), this.getTextureWidth(), this.getTextureHeight(), this.getImageWidth(), this.getImageHeight());
                GUICheckBoxButton.drawCustomSizedTexturedRect((this.getWidth() - this.getTextureWidth()) / 2, (this.getHeight() - this.getTextureHeight()) / 2, u + this.getTextureWidth() * 3, this.getTextureV(), this.getTextureWidth(), this.getTextureHeight(), this.getImageWidth(), this.getImageHeight());
                GlStateManager.func_179084_k();
            }
            if (this.isDynamicBackgroundEnabled()) {
                int innerBoxColor;
                int backgroundColor;
                if (!this.isEnabled()) {
                    backgroundColor = this.getDisabledBackgroundColor();
                    innerBoxColor = this.getDisabledInnerBoxColor();
                } else if (this.isHovered() || this.isToggled()) {
                    backgroundColor = this.getHoveredBackgroundColor();
                    innerBoxColor = this.getHoveredInnerBoxColor();
                } else {
                    backgroundColor = this.getEnabledBackgroundColor();
                    innerBoxColor = this.getEnabledInnerBoxColor();
                }
                GUICheckBoxButton.drawRect(0, 0, this.getWidth(), this.getHeight(), backgroundColor);
                GUICheckBoxButton.drawRect((this.getWidth() - this.getInnerBoxSize()) / 2, (this.getWidth() - this.getInnerBoxSize()) / 2, this.getWidth() - (this.getWidth() - this.getInnerBoxSize()) / 2, this.getHeight() - (this.getWidth() - this.getInnerBoxSize()) / 2, innerBoxColor);
            }
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (flag && mouseButton == 0) {
            this.setToggled(!this.isToggled());
            this.screen.handleElementClick(this.screen.getWorkspace().getCurrentSection(), this);
            this.screen.getWorkspace().getCurrentSection().handleElementClick(this.screen.getWorkspace().getCurrentSection(), this, mouseButton);
            if (this.screen.getWorkspace().getCurrentSection().hasCurrentCallback()) {
                this.screen.getWorkspace().getCurrentSection().getCurrentCallback().handleElementClick(this.screen.getWorkspace().getCurrentSection(), this, mouseButton);
            }
        }
        return flag;
    }

    public int getInnerBoxSize() {
        return this.innerBoxSize;
    }

    public GUICheckBoxButton setInnerBoxSize(int value) {
        this.innerBoxSize = value;
        return this;
    }

    public int getEnabledInnerBoxColor() {
        return this.enabledInnerBoxColor;
    }

    public GUICheckBoxButton setEnabledInnerBoxColor(int colorHex) {
        this.enabledInnerBoxColor = colorHex;
        return this;
    }

    public int getDisabledInnerBoxColor() {
        return this.disabledInnerBoxColor;
    }

    public GUICheckBoxButton setDisabledInnerBoxColor(int colorHex) {
        this.disabledInnerBoxColor = colorHex;
        return this;
    }

    public int getHoveredInnerBoxColor() {
        return this.hoveredInnerBoxColor;
    }

    public GUICheckBoxButton setHoveredInnerBoxColor(int colorHex) {
        this.hoveredInnerBoxColor = colorHex;
        return this;
    }

    @Override
    public GUICheckBoxButton setTexture(ResourceLocation texture, int textureWidth, int textureHeight) {
        this.setTexture(texture);
        this.setTextureSize(textureWidth, textureHeight);
        this.setImageSize(textureWidth * 6, textureHeight);
        return this;
    }
}

