/*
 * Decompiled with CFR 0.152.
 */
package austeretony.alternateui.screen.callback;

import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIAdvancedElement;
import austeretony.alternateui.screen.core.GUIBaseElement;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractGUICallback
extends GUIAdvancedElement<AbstractGUICallback> {
    private final List<GUIBaseElement> elements = new ArrayList<GUIBaseElement>();
    private GUIBaseElement lastHoveredElement;
    private boolean initiliazed;
    private boolean reinitAllowed;
    private boolean clearElementsList;
    private boolean enableDefaultBackground;
    private int defBackgroundColor = 2014318608;

    public AbstractGUICallback(AbstractGUIScreen screen, AbstractGUISection section, int width, int height) {
        this.initScreen(screen);
        this.setSize(width, height);
        this.setPosition((this.screen.field_146294_l - this.getWidth()) / 2, (this.screen.field_146295_m - this.getHeight()) / 2);
        this.enableFull();
    }

    public void open() {
        if (!this.initiliazed) {
            this.initiliazed = true;
            this.init();
        }
        this.onOpen();
        this.screen.getWorkspace().getCurrentSection().openCallback(this);
    }

    public boolean isInitialized() {
        return this.initiliazed;
    }

    @Override
    public abstract void init();

    protected void onOpen() {
    }

    public void close() {
        this.lastHoveredElement.setHovered(false);
        this.onClose();
        this.screen.getWorkspace().getCurrentSection().closeCallback();
        this.clear();
    }

    protected void onClose() {
    }

    @Override
    public void mouseOver(int mouseX, int mouseY) {
        this.setHovered(this.isEnabled() && mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + (int)((float)this.getWidth() * this.getScale()) && mouseY < this.getY() + (int)((float)this.getHeight() * this.getScale()));
        for (GUIBaseElement element : this.getElements()) {
            element.mouseOver(mouseX, mouseY);
            if (!element.isHovered()) continue;
            this.lastHoveredElement = element;
        }
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isDefaultBackgroundEnabled()) {
            this.drawDefaultBackground();
        }
        super.draw(mouseX, mouseY);
        if (this.isVisible()) {
            for (GUIBaseElement element : this.getElements()) {
                element.draw(mouseX, mouseY);
            }
        }
    }

    public void drawDefaultBackground() {
        AbstractGUICallback.drawRect(-this.screen.guiLeft, -this.screen.guiTop, this.mc.field_71443_c, this.mc.field_71440_d, this.getDefaultBackgroundColor());
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY) {
        for (GUIBaseElement element : this.getElements()) {
            element.drawTooltip(mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        for (GUIBaseElement element : this.getElements()) {
            if (element == this.lastHoveredElement) {
                element.mouseClicked(mouseX, mouseY, mouseButton);
                continue;
            }
            if (!element.isDragged()) continue;
            element.setDragged(false);
        }
        return true;
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) {
        for (GUIBaseElement element : this.getElements()) {
            element.keyTyped(typedChar, keyCode);
        }
        return true;
    }

    public void updateScreen() {
        for (GUIBaseElement element : this.getElements()) {
            element.updateCursorCounter();
            element.update();
        }
    }

    @Override
    public void handleScroller(boolean isScrolling) {
        for (GUIBaseElement element : this.getElements()) {
            element.handleScroller(isScrolling);
        }
    }

    @Override
    public void handleSlider() {
        for (GUIBaseElement element : this.getElements()) {
            element.handleSlider();
        }
    }

    public List<GUIBaseElement> getElements() {
        return this.elements;
    }

    public AbstractGUICallback addElement(GUIBaseElement element) {
        element.setPosition(this.getX() + element.getX(), this.getY() + element.getY());
        element.initScreen(this.getScreen());
        this.elements.add(element);
        return this;
    }

    public GUIBaseElement getHoveredElement() {
        return this.lastHoveredElement;
    }

    public abstract void handleElementClick(AbstractGUISection var1, GUIBaseElement var2, int var3);

    public boolean isDefaultBackgroundEnabled() {
        return this.enableDefaultBackground;
    }

    public AbstractGUICallback enableDefaultBackground() {
        this.enableDefaultBackground = true;
        return this;
    }

    public AbstractGUICallback enableDefaultBackground(int colorHex) {
        this.enableDefaultBackground();
        this.defBackgroundColor = colorHex;
        return this;
    }

    public int getDefaultBackgroundColor() {
        return this.defBackgroundColor;
    }

    public AbstractGUICallback setDefaultBackgroundColor(int colorHex) {
        this.defBackgroundColor = colorHex;
        return this;
    }
}

