/*
 * Decompiled with CFR 0.152.
 */
package austeretony.alternateui.screen.core;

import austeretony.alternateui.screen.browsing.GUIScroller;
import austeretony.alternateui.screen.button.GUIButton;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.alternateui.screen.core.GUIWorkspace;
import austeretony.alternateui.screen.list.GUIDropDownElement;
import austeretony.alternateui.screen.list.GUIDropDownList;
import austeretony.alternateui.screen.panel.GUIButtonPanel;
import austeretony.alternateui.util.EnumGUIOrientation;
import java.io.IOException;
import java.util.Iterator;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Mouse;

public abstract class AbstractGUIScreen
extends GuiScreen {
    public int xSize;
    public int ySize;
    public int guiLeft;
    public int guiTop;
    private GUIWorkspace workspace;
    protected boolean workspaceCreated;
    protected boolean isScrolling;
    private int yPrevMouse;

    public void func_73866_w_() {
        this.workspace = this.initWorkspace();
        this.init();
        this.workspace.setCurrentSection(this.getDefaultSection());
        this.xSize = this.workspace.getWidth();
        this.ySize = this.workspace.getHeight();
        this.guiLeft = this.workspace.getX();
        this.guiTop = this.workspace.getY();
        this.workspaceCreated = true;
    }

    protected void init() {
        this.initSections();
        for (AbstractGUISection section : this.getWorkspace().getSections()) {
            section.init();
        }
    }

    protected abstract GUIWorkspace initWorkspace();

    protected abstract void initSections();

    protected abstract AbstractGUISection getDefaultSection();

    public GUIWorkspace getWorkspace() {
        return this.workspace;
    }

    protected boolean isWorkspaceCreated() {
        return this.workspaceCreated;
    }

    public void func_146276_q_() {
    }

    protected void drawBackgroundLayer(int mouseX, int mouseY, float partialTicks) {
    }

    protected void drawForegroundLayer(int mouseX, int mouseY, float partialTicks) {
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.isWorkspaceCreated()) {
            this.func_146276_q_();
            this.getWorkspace().draw(mouseX, mouseY);
            AbstractGUISection section = this.getWorkspace().getCurrentSection();
            section.drawBackground();
            this.drawBackgroundLayer(mouseX, mouseY, partialTicks);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
            RenderHelper.func_74518_a();
            section.mouseOver(mouseX - this.guiLeft, mouseY - this.guiTop);
            section.draw(mouseX - this.guiLeft, mouseY - this.guiTop);
            this.drawForegroundLayer(mouseX, mouseY, partialTicks);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawSlots(mouseX, mouseY);
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            section.drawTooltip(mouseX - this.guiLeft, mouseY - this.guiTop);
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
            GlStateManager.func_179140_f();
            section.drawContextMenu(mouseX, mouseY);
            if (section.hasCurrentCallback()) {
                section.getCurrentCallback().mouseOver(mouseX, mouseY);
                section.drawCallback(mouseX, mouseY);
                section.drawCallbackTooltip(mouseX, mouseY);
                section.drawCallbackContextMenu(mouseX, mouseY);
            }
            GlStateManager.func_179145_e();
            RenderHelper.func_74520_c();
        }
    }

    protected void drawSlots(int mouseX, int mouseY) {
    }

    public void handlePanelSlidebar(GUIButtonPanel buttonPanel, int mouseY) {
        if (buttonPanel.getScroller().getSlider().isDragged()) {
            int slidebarOffset = mouseY - buttonPanel.getScroller().getSlider().getSlidebarY() - this.guiTop;
            float sliderActiveHeight = buttonPanel.getScroller().getSlider().getHeight() - buttonPanel.getScroller().getSlider().getSlidebarHeight();
            float currentPosition = mouseY - slidebarOffset - this.yPrevMouse + mouseY - this.guiTop;
            buttonPanel.getScroller().setPosition((int)((float)buttonPanel.getScroller().getMaxPosition() * ((currentPosition - (float)buttonPanel.getScroller().getSlider().getY()) / sliderActiveHeight)));
            buttonPanel.getScroller().getSlider().handleSlidebarViaCursor((int)(sliderActiveHeight * (currentPosition / sliderActiveHeight)));
            this.scrollButtonPanel(buttonPanel);
        }
        this.yPrevMouse = mouseY;
    }

    public abstract void handleElementClick(AbstractGUISection var1, GUIBaseElement var2);

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.getWorkspace().getCurrentSection().mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.getWorkspace().getCurrentSection().keyTyped(typedChar, keyCode);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        boolean bl = this.isScrolling = Mouse.getDWheel() != 0;
        if (this.isWorkspaceCreated()) {
            this.workspace.getCurrentSection().handleScroller(this.isScrolling);
        }
    }

    public void scrollDropDownList(GUIDropDownList dropDownList) {
        int i = 0;
        dropDownList.visibleElements.clear();
        if (dropDownList.getScroller().scrollerType == GUIScroller.EnumScrollerType.STANDARD) {
            for (i = dropDownList.getScroller().getPosition(); i < dropDownList.getScroller().getPosition() + dropDownList.getScroller().rowsVisible; ++i) {
                if (i >= dropDownList.elementsBuffer.size()) continue;
                GUIDropDownElement dropDownElement = dropDownList.elementsBuffer.get(i);
                int size = dropDownList.visibleElements.size();
                dropDownElement.setPosition(dropDownList.getX(), dropDownList.getY() + (size + 1) * dropDownList.getHeight() - size / dropDownList.getVisibleElementsAmount() * (dropDownList.getMaxElementsAmount() * dropDownList.getHeight()));
                dropDownList.visibleElements.add(dropDownElement);
            }
        }
    }

    public void scrollButtonPanel(GUIButtonPanel panel) {
        int i = 0;
        boolean scrollingSearch = !panel.searchButtons.isEmpty();
        panel.visibleButtons.clear();
        if (panel.getScroller().scrollerType == GUIScroller.EnumScrollerType.STANDARD) {
            for (i = panel.getScroller().getPosition(); i < panel.getScroller().getPosition() + panel.getVisibleElementsAmount(); ++i) {
                if ((scrollingSearch || i >= panel.buttonsBuffer.size()) && (!scrollingSearch || i >= panel.searchButtons.size())) continue;
                GUIButton button = scrollingSearch ? panel.searchButtons.get(i) : panel.buttonsBuffer.get(i);
                int size = panel.visibleButtons.size();
                button.setPosition(panel.orientation == EnumGUIOrientation.HORIZONTAL ? panel.getX() + size * (panel.getButtonWidth() + panel.getButtonsOffset()) - size / panel.getVisibleElementsAmount() * (panel.getMaxElementsAmount() * (panel.getButtonWidth() + panel.getButtonsOffset())) : panel.getX(), panel.orientation == EnumGUIOrientation.VERTICAL ? panel.getY() + size * (panel.getButtonHeight() + panel.getButtonsOffset()) - size / panel.getVisibleElementsAmount() * (panel.getMaxElementsAmount() * (panel.getButtonHeight() + panel.getButtonsOffset())) : panel.getY());
                panel.visibleButtons.add(button);
            }
        }
    }

    public void searchButtonPanel(GUIButtonPanel panel) {
        String typedText = panel.getSearchField().getTypedText().toLowerCase();
        Iterator<GUIButton> buttonsIterator = panel.buttonsBuffer.iterator();
        panel.visibleButtons.clear();
        panel.searchButtons.clear();
        while (buttonsIterator.hasNext()) {
            String buttonName;
            GUIButton button = buttonsIterator.next();
            if (button == null || !(buttonName = button.getDisplayText().toLowerCase()).startsWith(typedText) && !buttonName.contains(" " + typedText)) continue;
            int size = panel.searchButtons.size();
            GUIButton buttonCopy = button;
            int k = size;
            buttonCopy.setY(panel.getY() + k * (panel.getButtonHeight() + panel.getButtonsOffset()) - size / panel.getMaxElementsAmount() * (panel.getMaxElementsAmount() * (panel.getButtonHeight() + panel.getButtonsOffset())));
            if (size < panel.getVisibleElementsAmount()) {
                panel.visibleButtons.add(buttonCopy);
            }
            panel.searchButtons.add(buttonCopy);
        }
    }

    protected abstract boolean doesGUIPauseGame();

    public boolean func_73868_f() {
        return this.doesGUIPauseGame();
    }

    public void func_73876_c() {
        if (this.isWorkspaceCreated()) {
            this.getWorkspace().getCurrentSection().updateScreen();
        }
    }

    public void close() {
        this.field_146297_k.func_147108_a((GuiScreen)null);
        if (this.field_146297_k.field_71462_r == null) {
            this.field_146297_k.func_71381_h();
        }
    }

    public void func_146281_b() {
        GUIBaseElement.resetDragged();
    }

    public void drawToolTip(ItemStack stack, int x, int y) {
        this.func_146285_a(stack, x, y);
    }

    public int width(String text) {
        return this.field_146297_k.field_71466_p.func_78256_a(text);
    }
}

