/*
 * Decompiled with CFR 0.152.
 */
package austeretony.alternateui.screen.core;

import austeretony.alternateui.container.framework.GUISlotsFramework;
import austeretony.alternateui.screen.callback.AbstractGUICallback;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.GUIAdvancedElement;
import austeretony.alternateui.screen.core.GUIBaseElement;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Mouse;

public abstract class AbstractGUISection
extends GUIAdvancedElement<AbstractGUISection> {
    private final Set<GUIBaseElement> elements = new LinkedHashSet<GUIBaseElement>();
    private final List<GUISlotsFramework> slotsFrameworksList = new ArrayList<GUISlotsFramework>(2);
    private GUIBaseElement hoveredElement;
    private AbstractGUICallback currentCallback;
    private boolean initiliazed;
    private boolean reinitAllowed;
    private boolean clearElementsList;
    private boolean hasCurrentCallback;
    private boolean enableDefaultBackground;
    private int defBackgroundColor = 2014318608;

    public AbstractGUISection(AbstractGUIScreen screen) {
        this.initScreen(screen);
        this.setDebugColor(1677787135);
    }

    public void open() {
        this.screen.getWorkspace().setCurrentSection(this);
    }

    @Override
    public abstract void init();

    public void drawBackground() {
        if (this.isDefaultBackgroundEnabled()) {
            this.drawDefaultBackground();
        }
        if (this.isDebugMode()) {
            AbstractGUISection.drawRect(this.getX() + this.getTextureOffsetX(), this.getY() + this.getTextureOffsetY(), this.getX() + this.getTextureOffsetX() + this.getTextureWidth(), this.getY() + this.getTextureOffsetY() + this.getTextureHeight(), this.getDebugColor());
        }
        if (this.isStaticBackgroundEnabled()) {
            AbstractGUISection.drawRect(0, 0, this.getWidth(), this.getHeight(), this.getStaticBackgroundColor());
        }
        if (this.isTextureEnabled()) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179126_j();
            GlStateManager.func_179147_l();
            this.mc.func_110434_K().func_110577_a(this.getTexture());
            AbstractGUISection.drawCustomSizedTexturedRect(this.getX() + this.getTextureOffsetX(), this.getY() + this.getTextureOffsetY(), 0, 0, this.getTextureWidth(), this.getTextureHeight(), this.getTextureWidth(), this.getTextureHeight());
            GlStateManager.func_179084_k();
            GlStateManager.func_179097_i();
            GlStateManager.func_179145_e();
        }
    }

    public void drawDefaultBackground() {
        AbstractGUISection.drawRect(0, 0, this.mc.field_71443_c, this.mc.field_71440_d, this.getDefaultBackgroundColor());
    }

    @Override
    public void mouseOver(int mouseX, int mouseY) {
        if (!this.hasCurrentCallback()) {
            this.setHovered(this.isEnabled() && mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.getWidth() && mouseY < this.getY() + this.getHeight());
            for (GUIBaseElement element : this.getElements()) {
                element.mouseOver(mouseX, mouseY);
                if (!element.isHovered()) continue;
                this.hoveredElement = element;
            }
            for (GUISlotsFramework framework : this.getSlotsFrameworks()) {
                framework.mouseOver(mouseX, mouseY);
            }
        }
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        for (GUIBaseElement element : this.getElements()) {
            element.draw(mouseX, mouseY);
        }
        for (GUISlotsFramework framework : this.getSlotsFrameworks()) {
            framework.draw(mouseX, mouseY);
        }
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY) {
        if (!this.hasCurrentCallback()) {
            for (GUIBaseElement element : this.getElements()) {
                element.drawTooltip(mouseX, mouseY);
            }
            for (GUISlotsFramework framework : this.getSlotsFrameworks()) {
                framework.drawTooltip(mouseX, mouseY);
            }
        }
    }

    @Override
    public void drawContextMenu(int mouseX, int mouseY) {
        if (!this.hasCurrentCallback()) {
            for (GUIBaseElement element : this.getElements()) {
                element.drawContextMenu(mouseX, mouseY);
            }
        }
    }

    public void drawCallback(int mouseX, int mouseY) {
        this.currentCallback.draw(mouseX, mouseY);
    }

    public void drawCallbackTooltip(int mouseX, int mouseY) {
        this.currentCallback.drawTooltip(mouseX, mouseY);
    }

    public void drawCallbackContextMenu(int mouseX, int mouseY) {
        this.currentCallback.drawContextMenu(mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        for (GUIBaseElement element : this.getElements()) {
            if (element == this.hoveredElement) {
                element.mouseClicked(mouseX, mouseY, mouseButton);
                continue;
            }
            if (!element.isDragged()) continue;
            element.setDragged(false);
        }
        if (this.hasCurrentCallback()) {
            this.currentCallback.mouseClicked(mouseX, mouseY, mouseButton);
        }
        return true;
    }

    @Override
    public void handleScroller(boolean isScrolling) {
        if (isScrolling && !AbstractGUISection.hasDraggedElement()) {
            for (GUIBaseElement element : this.getElements()) {
                element.handleScroller(isScrolling);
            }
            if (this.hasCurrentCallback()) {
                this.getCurrentCallback().handleScroller(isScrolling);
            }
        }
        if (!Mouse.isButtonDown((int)0)) {
            for (GUIBaseElement element : this.getElements()) {
                element.handleSlider();
            }
            if (this.hasCurrentCallback()) {
                this.getCurrentCallback().handleSlider();
            }
        }
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) {
        for (GUIBaseElement element : this.getElements()) {
            if (element.isSearchField()) continue;
            element.keyTyped(typedChar, keyCode);
        }
        if (this.hasCurrentCallback()) {
            this.getCurrentCallback().keyTyped(typedChar, keyCode);
        }
        return true;
    }

    public void updateScreen() {
        this.update();
        for (GUIBaseElement element : this.getElements()) {
            element.updateCursorCounter();
            element.update();
        }
        if (this.hasCurrentCallback()) {
            this.getCurrentCallback().updateScreen();
        }
    }

    public boolean hasCurrentCallback() {
        return this.hasCurrentCallback;
    }

    public AbstractGUICallback getCurrentCallback() {
        return this.currentCallback;
    }

    public void openCallback(AbstractGUICallback callback) {
        this.hoveredElement.setHovered(false);
        this.currentCallback = callback;
        this.hasCurrentCallback = true;
    }

    public void closeCallback() {
        this.hasCurrentCallback = false;
    }

    public Set<GUIBaseElement> getElements() {
        return this.elements;
    }

    public AbstractGUISection addElement(GUIBaseElement element) {
        element.initScreen(this.getScreen());
        this.elements.add(element);
        return this;
    }

    public List<GUISlotsFramework> getSlotsFrameworks() {
        return this.slotsFrameworksList;
    }

    public final AbstractGUISection addSlotsFramework(GUISlotsFramework framework) {
        if (!this.slotsFrameworksList.contains(framework)) {
            framework.initScreen(this.getScreen());
            this.slotsFrameworksList.add(framework);
        }
        return this;
    }

    public GUIBaseElement getHoveredElement() {
        return this.hoveredElement;
    }

    public abstract void handleElementClick(AbstractGUISection var1, GUIBaseElement var2, int var3);

    public boolean isDefaultBackgroundEnabled() {
        return this.enableDefaultBackground;
    }

    public AbstractGUISection enableDefaultBackground() {
        this.enableDefaultBackground = true;
        return this;
    }

    public AbstractGUISection enableDefaultBackground(int colorHex) {
        this.enableDefaultBackground();
        this.defBackgroundColor = colorHex;
        return this;
    }

    public int getDefaultBackgroundColor() {
        return this.defBackgroundColor;
    }

    public AbstractGUISection setDefaultBackgroundColor(int colorHex) {
        this.defBackgroundColor = colorHex;
        return this;
    }
}

