/*
 * Decompiled with CFR 0.152.
 */
package austeretony.alternateui.screen.core;

import austeretony.alternateui.screen.core.GUISimpleElement;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class GUIAdvancedElement<T extends GUISimpleElement>
extends GUISimpleElement<T> {
    private ResourceLocation texture;
    private int textureWidth;
    private int textureHeight;
    private int textureU;
    private int textureV;
    private int imageWidth;
    private int imageHeight;
    private int textureOffsetX;
    private int textureOffsetY;
    private boolean isTextureEnabled;

    @Override
    public void draw(int mouseX, int mouseY) {
        super.draw(mouseX, mouseY);
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.isTextureEnabled()) {
                int u = this.getTextureU();
                this.mc.func_110434_K().func_110577_a(this.getTexture());
                if (!this.isEnabled()) {
                    u = this.getTextureWidth();
                } else if (this.isHovered() || this.isToggled()) {
                    u += this.getTextureWidth() * 2;
                }
                GlStateManager.func_179147_l();
                GUIAdvancedElement.drawCustomSizedTexturedRect((this.getWidth() - this.getTextureWidth()) / 2, (this.getHeight() - this.getTextureHeight()) / 2, u, this.getTextureV(), this.getTextureWidth(), this.getTextureHeight(), this.getImageWidth(), this.getImageHeight());
                GlStateManager.func_179084_k();
            }
            GlStateManager.func_179121_F();
        }
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public T setTexture(ResourceLocation texture, int textureWidth, int textureHeight, int u, int v, int imageWidth, int imageHeight) {
        this.setTexture(texture, textureWidth, textureHeight, imageWidth, imageHeight);
        this.textureU = u;
        this.textureV = v;
        return (T)this;
    }

    public T setTexture(ResourceLocation texture, int textureWidth, int textureHeight, int imageWidth, int imageHeight) {
        this.setTexture(texture, textureWidth, textureHeight);
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        return (T)this;
    }

    public T setTexture(ResourceLocation texture, int textureWidth, int textureHeight) {
        this.setTexture(texture);
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.imageWidth = textureWidth;
        this.imageHeight = textureHeight;
        this.enableTexture();
        return (T)this;
    }

    public T setTexture(ResourceLocation texture) {
        this.texture = texture;
        this.enableTexture();
        return (T)this;
    }

    public int getTextureWidth() {
        return this.textureWidth;
    }

    public int getTextureHeight() {
        return this.textureHeight;
    }

    public T setTextureSize(int textureWidth, int textureHeight) {
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        return (T)this;
    }

    public int getTextureU() {
        return this.textureU;
    }

    public int getTextureV() {
        return this.textureV;
    }

    public T setTextureUV(int u, int v) {
        this.textureU = u;
        this.textureV = v;
        return (T)this;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public T setImageSize(int width, int height) {
        this.imageWidth = width;
        this.imageHeight = height;
        return (T)this;
    }

    public int getTextureOffsetX() {
        return this.textureOffsetX;
    }

    public int getTextureOffsetY() {
        return this.textureOffsetY;
    }

    public T setTextureOffset(int offsetX, int offsetY) {
        this.textureOffsetX = offsetX;
        this.textureOffsetY = offsetY;
        return (T)this;
    }

    public boolean isTextureEnabled() {
        return this.isTextureEnabled;
    }

    public T enableTexture() {
        this.isTextureEnabled = true;
        return (T)this;
    }

    public static void drawCustomSizedTexturedRect(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        float f = 1.0f / (float)textureWidth;
        float f1 = 1.0f / (float)textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)((float)u * f), (double)(((float)v + (float)height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)(((float)u + (float)width) * f), (double)(((float)v + (float)height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)(((float)u + (float)width) * f), (double)((float)v * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)((float)u * f), (double)((float)v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }
}

