/*
 * Decompiled with CFR 0.152.
 */
package austeretony.alternateui.screen.framework;

import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.alternateui.screen.core.GUISimpleElement;
import java.util.LinkedHashSet;
import java.util.Set;

public class GUIElementsFramework
extends GUISimpleElement<GUIElementsFramework> {
    private final Set<GUIBaseElement> elements = new LinkedHashSet<GUIBaseElement>(5);
    private GUIBaseElement hoveredElement;
    private boolean clearElementsList;

    public GUIElementsFramework() {
        this.enableFull();
    }

    @Override
    public void mouseOver(int mouseX, int mouseY) {
        this.setHovered(this.isEnabled() && mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.getWidth() && mouseY < this.getY() + this.getHeight());
        for (GUIBaseElement element : this.getElements()) {
            element.mouseOver(mouseX, mouseY);
            if (!element.isHovered()) continue;
            this.hoveredElement = element;
        }
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            for (GUIBaseElement element : this.getElements()) {
                element.draw(mouseX, mouseY);
            }
        }
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY) {
        if (this.isVisible()) {
            for (GUIBaseElement element : this.getElements()) {
                element.drawTooltip(mouseX, mouseY);
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        for (GUIBaseElement element : this.getElements()) {
            if (element != this.hoveredElement) continue;
            element.mouseClicked(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    @Override
    public void handleScroller(boolean isScrolling) {
        for (GUIBaseElement element : this.getElements()) {
            element.handleScroller(isScrolling);
        }
    }

    @Override
    public void handleSlider() {
        for (GUIBaseElement element : this.getElements()) {
            element.handleSlider();
        }
    }

    public Set<GUIBaseElement> getElements() {
        return this.elements;
    }

    public GUIElementsFramework addElement(GUIBaseElement element) {
        element.initScreen(this.getScreen());
        this.elements.add(element);
        return this;
    }

    public GUIBaseElement getHoveredElement() {
        return this.hoveredElement;
    }
}

