/*
 * Decompiled with CFR 0.152.
 */
package austeretony.alternateui.screen.list;

import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.alternateui.screen.list.GUIDropDownElement;
import austeretony.alternateui.util.GUISoundEffect;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.SoundEvent;

public class GUIDropDownList
extends GUISimpleElement<GUIDropDownList> {
    public final List<GUIDropDownElement> visibleElements = new ArrayList<GUIDropDownElement>(5);
    public final List<GUIDropDownElement> elementsBuffer = new ArrayList<GUIDropDownElement>(5);
    private int elementsOffset;
    private GUIDropDownElement choosenElement;
    private GUIDropDownElement hoveredElement;
    private boolean resetScroller;
    private boolean hasChoosenElement;
    private int actionBoxWidth;
    private int actionBoxHeight;
    private GUISoundEffect openSound;
    private GUISoundEffect closeSound;

    public GUIDropDownList(int xPosition, int yPosition, int buttonWidth, int buttonHeight) {
        this.setPosition(xPosition, yPosition);
        this.actionBoxWidth = buttonWidth;
        this.actionBoxHeight = buttonHeight;
        this.enableFull();
    }

    public GUIDropDownList addElement(GUIDropDownElement dropDownElement) {
        int size;
        if (this.visibleElements.size() == 0) {
            this.setSize((int)((float)this.actionBoxWidth * this.getScale()), (int)((float)this.actionBoxHeight * this.getScale()));
        }
        dropDownElement.initScreen(this.getScreen());
        dropDownElement.setTextScale(this.getTextScale());
        dropDownElement.setTextAlignment(this.getTextAlignment(), this.getTextOffset());
        this.bind(dropDownElement);
        if (!this.visibleElements.contains(dropDownElement)) {
            size = this.visibleElements.size();
            if (!this.hasScroller()) {
                dropDownElement.setPosition(this.getX(), this.getY() + (int)((float)this.getHeight() * this.getScale() * (float)(size + 1)));
                dropDownElement.setSize(this.actionBoxWidth, this.actionBoxHeight);
                dropDownElement.setScale(this.getScale());
                dropDownElement.setTextAlignment(this.getTextAlignment(), this.getTextOffset());
                this.visibleElements.add(dropDownElement);
            }
        }
        if (!this.elementsBuffer.contains(dropDownElement)) {
            size = this.elementsBuffer.size();
            dropDownElement.setPosition(this.getX(), this.getY() + (int)((float)this.getHeight() * this.getScale() * (float)(size + 1)));
            dropDownElement.setSize(this.getWidth(), this.getHeight());
            dropDownElement.setScale(this.getScale());
            dropDownElement.setTextAlignment(this.getTextAlignment(), this.getTextOffset());
            this.elementsBuffer.add(dropDownElement);
            dropDownElement.init();
        }
        return this;
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        super.draw(mouseX, mouseY);
        if (this.isVisible() && this.isDragged()) {
            for (GUIDropDownElement element : this.visibleElements) {
                element.draw(mouseX, mouseY);
            }
        }
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY) {
        if (this.isVisible() && this.isDragged()) {
            for (GUIDropDownElement element : this.visibleElements) {
                element.drawTooltip(mouseX, mouseY);
            }
        }
    }

    @Override
    public void mouseOver(int mouseX, int mouseY) {
        if (this.isEnabled()) {
            this.setHovered(mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.getWidth() && mouseY < this.getY() + (this.isDragged() ? this.getHeight() * this.visibleElements.size() : this.getHeight()));
            if (this.isDragged()) {
                for (GUIDropDownElement element : this.visibleElements) {
                    element.mouseOver(mouseX, mouseY);
                    if (!element.isHovered()) continue;
                    this.hoveredElement = element;
                }
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (flag && mouseButton == 0) {
            for (GUIDropDownElement element : this.visibleElements) {
                if (!element.mouseClicked(mouseX, mouseY, mouseButton)) continue;
                this.choosenElement = element;
                this.setDisplayText(element.getDisplayText());
                this.hasChoosenElement = true;
                this.setDragged(false);
                element.setHovered(false);
                if (this.shouldResetScrollerOnClosing()) {
                    this.reset();
                }
                this.screen.handleElementClick(this.screen.getWorkspace().getCurrentSection(), element);
                this.screen.getWorkspace().getCurrentSection().handleElementClick(this.screen.getWorkspace().getCurrentSection(), element, mouseButton);
                if (this.screen.getWorkspace().getCurrentSection().hasCurrentCallback()) {
                    this.screen.getWorkspace().getCurrentSection().getCurrentCallback().handleElementClick(this.screen.getWorkspace().getCurrentSection(), element, mouseButton);
                }
                if (this.closeSound != null) {
                    this.mc.field_71439_g.func_184185_a(this.closeSound.sound, this.closeSound.volume, this.closeSound.pitch);
                }
                return true;
            }
        }
        if (flag && mouseButton == 0 && !this.isDragged() && this.openSound != null) {
            this.mc.field_71439_g.func_184185_a(this.openSound.sound, this.openSound.volume, this.openSound.pitch);
        }
        this.setDragged(flag && mouseButton == 0);
        if (this.shouldResetScrollerOnClosing()) {
            this.reset();
        }
        return false;
    }

    @Override
    public void handleScroller(boolean isScrolling) {
        if (this.hasScroller() && (this.isHovered() || this.getScroller().shouldIgnoreBorders()) && this.getScroller().handleScroller()) {
            this.screen.scrollDropDownList(this);
        }
    }

    private void reset() {
        int i = 0;
        this.visibleElements.clear();
        this.getScroller().resetPosition();
        for (i = 0; i < this.getVisibleElementsAmount(); ++i) {
            if (i >= this.elementsBuffer.size()) continue;
            GUIDropDownElement dropDownElement = this.elementsBuffer.get(i);
            int size = this.visibleElements.size();
            dropDownElement.setPosition(this.getX(), this.getY() + (size + 1) * this.getHeight() - size / this.getVisibleElementsAmount() * (this.getMaxElementsAmount() * this.getHeight()));
            this.visibleElements.add(dropDownElement);
        }
    }

    public boolean hasChoosenElement() {
        return this.hasChoosenElement;
    }

    public GUIDropDownElement getChoosenElement() {
        return this.choosenElement;
    }

    public GUIDropDownElement getHoveredElement() {
        return this.hoveredElement;
    }

    public boolean shouldResetScrollerOnClosing() {
        return this.resetScroller;
    }

    public GUIDropDownList resetScrollerOnClosing() {
        this.resetScroller = true;
        return this;
    }

    public GUIDropDownList setOpenSound(GUISoundEffect sound) {
        this.openSound = sound;
        return this;
    }

    public GUIDropDownList setOpenSound(SoundEvent sound) {
        this.openSound = new GUISoundEffect(sound, 0.5f, 1.0f);
        return this;
    }

    public GUIDropDownList setCloseSound(GUISoundEffect sound) {
        this.closeSound = sound;
        return this;
    }

    public GUIDropDownList setCloseSound(SoundEvent sound) {
        this.closeSound = new GUISoundEffect(sound, 0.5f, 1.0f);
        return this;
    }
}

