/*
 * Decompiled with CFR 0.152.
 */
package austeretony.alternateui.screen.text;

import austeretony.alternateui.screen.core.GUISimpleElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ChatAllowedCharacters;

public class GUITextBoxField
extends GUISimpleElement<GUITextBoxField> {
    protected String typedText;
    protected final int maxStringLength;
    protected int cursorCounter;
    protected int lineOffset;
    protected boolean newLine;
    private final List<String> lines = new ArrayList<String>(5);

    public GUITextBoxField(int xPosition, int yPosition, int width, int height, int maxStringLength) {
        this.setPosition(xPosition, yPosition);
        this.setSize(width, height);
        this.maxStringLength = maxStringLength > 1500 ? 1500 : maxStringLength;
        this.typedText = "";
        this.lineOffset = 2;
        this.enableFull();
    }

    @Override
    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public String getTypedText() {
        return this.typedText;
    }

    public GUITextBoxField setText(String text) {
        this.typedText = text.length() > this.maxStringLength ? text.substring(0, this.maxStringLength) : text;
        this.lines.clear();
        int width = this.getWidth() - 3;
        StringBuilder builder = new StringBuilder();
        int index = 0;
        int wordStartIndex = 0;
        boolean rechedLimit = false;
        boolean wordProcessing = false;
        char prevSymbol = '0';
        for (char symbol : this.typedText.toCharArray()) {
            if ((this.textHeight(this.getTextScale()) + this.lineOffset) * this.lines.size() >= this.getHeight()) break;
            this.newLine = false;
            if (symbol != ' ') {
                wordProcessing = true;
                if (prevSymbol == ' ') {
                    wordStartIndex = index;
                }
            }
            if (symbol == '\n') {
                this.lines.add(builder.toString());
                builder.delete(0, builder.length());
                index = 0;
                this.newLine = true;
                continue;
            }
            if (this.textWidth(builder.toString() + String.valueOf(symbol), this.getTextScale()) <= width) {
                builder.append(symbol);
            } else {
                if (symbol == '.' || symbol == ',' || symbol == '!' || symbol == '?') {
                    builder.append(symbol);
                }
                if (wordProcessing) {
                    this.lines.add(builder.toString().substring(0, wordStartIndex));
                    builder.delete(0, wordStartIndex);
                } else {
                    this.lines.add(builder.toString());
                    builder.delete(0, builder.length());
                }
                if (symbol != ' ') {
                    builder.append(symbol);
                }
                index = builder.length() - 1;
            }
            wordProcessing = false;
            prevSymbol = symbol;
            ++index;
        }
        if (builder.length() != 0) {
            this.lines.add(builder.toString());
        }
        return this;
    }

    public void reset() {
        this.setText("");
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag = false;
        if (this.isDoubleClickRequired()) {
            if (this.isClickedLately()) {
                flag = true;
                this.setLastClickTime(0L);
            } else {
                this.setLastClickTime(Minecraft.func_71386_F());
            }
        } else {
            flag = true;
        }
        if (flag && this.isEnabled()) {
            this.setDragged(this.isHovered());
            if (this.isDragged() && this.shouldCancelDraggedLogic()) {
                GUITextBoxField.resetDragged();
            }
            if (this.isDragged() && this.isHovered()) {
                this.screen.handleElementClick(this.screen.getWorkspace().getCurrentSection(), this);
                this.screen.getWorkspace().getCurrentSection().handleElementClick(this.screen.getWorkspace().getCurrentSection(), this, mouseButton);
                if (this.screen.getWorkspace().getCurrentSection().hasCurrentCallback()) {
                    this.screen.getWorkspace().getCurrentSection().getCurrentCallback().handleElementClick(this.screen.getWorkspace().getCurrentSection(), this, mouseButton);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean keyTyped(char keyChar, int keyCode) {
        if (!this.isDragged()) {
            return false;
        }
        switch (keyCode) {
            case 14: {
                String s = this.getTypedText();
                if (!s.isEmpty()) {
                    this.setText(s.substring(0, s.length() - 1));
                }
                return true;
            }
            case 28: 
            case 156: {
                this.append("\n");
                return true;
            }
        }
        if (ChatAllowedCharacters.func_71566_a((char)keyChar)) {
            this.append(Character.toString(keyChar));
        }
        return true;
    }

    private void append(String string) {
        String s = this.getTypedText();
        String s1 = s + string;
        if (s1.length() < 256) {
            this.setText(s1);
        }
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.isDynamicBackgroundEnabled()) {
                if (this.isEnabled()) {
                    GUITextBoxField.drawRect(0, 0, this.getWidth(), this.getHeight(), this.getEnabledBackgroundColor());
                } else {
                    GUITextBoxField.drawRect(0, 0, this.getWidth(), this.getHeight(), this.getDisabledBackgroundColor());
                }
                if (this.isDragged()) {
                    GUITextBoxField.drawRect(0, 0, this.getWidth(), this.getHeight(), this.getHoveredBackgroundColor());
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)1.0f, (float)2.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.isDragged() && this.lines.isEmpty() && this.cursorCounter / 6 % 2 == 0) {
                this.mc.field_71466_p.func_175065_a("_", 0.0f, 0.0f, this.getEnabledTextColor(), this.isTextShadowEnabled());
            }
            int index = 0;
            for (String line : this.lines) {
                if (this.isDragged() && !this.newLine && index == this.lines.size() - 1 && this.cursorCounter / 6 % 2 == 0) {
                    this.mc.field_71466_p.func_175065_a(line + "_", 0.0f, (float)((this.mc.field_71466_p.field_78288_b + this.lineOffset) * index), this.getEnabledTextColor(), this.isTextShadowEnabled());
                } else {
                    this.mc.field_71466_p.func_175065_a(line, 0.0f, (float)((this.mc.field_71466_p.field_78288_b + this.lineOffset) * index), this.getEnabledTextColor(), this.isTextShadowEnabled());
                }
                ++index;
            }
            if (this.isDragged() && this.newLine && this.cursorCounter / 6 % 2 == 0) {
                this.mc.field_71466_p.func_175065_a("_", 0.0f, (float)((this.mc.field_71466_p.field_78288_b + this.lineOffset) * this.lines.size()), this.getEnabledTextColor(), this.isTextShadowEnabled());
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }

    public GUITextBoxField setLineOffset(int offset) {
        this.lineOffset = offset;
        return this;
    }
}

