/*
 * Decompiled with CFR 0.152.
 */
package austeretony.alternateui.screen.text;

import austeretony.alternateui.screen.core.GUISimpleElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;

public class GUITextBoxLabel
extends GUISimpleElement<GUITextBoxLabel> {
    private final List<String> lines = new ArrayList<String>(5);
    protected int lineOffset;

    public GUITextBoxLabel(int xPosition, int yPosition, int width, int height) {
        this.setPosition(xPosition, yPosition);
        this.setSize(width, height);
        this.lineOffset = 2;
        this.enableFull();
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.isDynamicBackgroundEnabled()) {
                GUITextBoxLabel.drawRect(0, 0, this.getWidth(), this.getHeight(), this.getEnabledColor());
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)1.0f, (float)2.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int index = 0;
            for (String line : this.lines) {
                this.mc.field_71466_p.func_175065_a(line, 0.0f, (float)((this.mc.field_71466_p.field_78288_b + this.lineOffset) * index), this.getEnabledTextColor(), this.isTextShadowEnabled());
                ++index;
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public GUITextBoxLabel setDisplayText(String displayText) {
        this.lines.clear();
        int width = this.getWidth() - 3;
        StringBuilder builder = new StringBuilder();
        int index = 0;
        int wordStartIndex = 0;
        boolean rechedLimit = false;
        boolean wordProcessing = false;
        char prevSymbol = '0';
        for (char symbol : displayText.toCharArray()) {
            if ((this.textHeight(this.getTextScale()) + this.lineOffset) * this.lines.size() >= this.getHeight()) break;
            if (symbol != ' ') {
                wordProcessing = true;
                if (prevSymbol == ' ') {
                    wordStartIndex = index;
                }
            }
            if (symbol == '\n') {
                this.lines.add(builder.toString());
                builder.delete(0, builder.length());
                index = 0;
                continue;
            }
            if (this.textWidth(builder.toString() + String.valueOf(symbol), this.getTextScale()) <= width) {
                builder.append(symbol);
            } else {
                if (symbol == '.' || symbol == ',' || symbol == '!' || symbol == '?') {
                    builder.append(symbol);
                }
                if (wordProcessing) {
                    this.lines.add(builder.toString().substring(0, wordStartIndex));
                    builder.delete(0, wordStartIndex);
                } else {
                    this.lines.add(builder.toString());
                    builder.delete(0, builder.length());
                }
                if (symbol != ' ') {
                    builder.append(symbol);
                }
                index = builder.length() - 1;
            }
            wordProcessing = false;
            prevSymbol = symbol;
            ++index;
        }
        if (builder.length() != 0) {
            this.lines.add(builder.toString());
        }
        return this;
    }

    public GUITextBoxLabel setLineOffset(int offset) {
        this.lineOffset = offset;
        return this;
    }
}

