/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client;

import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.api.event.OxygenNotificationRecievedEvent;
import austeretony.oxygen_core.client.gui.notifications.NotificationsGUIScreen;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.server.SPRequestReply;
import austeretony.oxygen_core.common.notification.EnumNotification;
import austeretony.oxygen_core.common.notification.EnumRequestReply;
import austeretony.oxygen_core.common.notification.Notification;
import austeretony.oxygen_core.common.sound.OxygenSoundEffects;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class NotificationManagerClient {
    private final Map<Long, Notification> notifications = new ConcurrentHashMap<Long, Notification>(5);
    private long latestNotificationId;

    public void openNotificationsMenu() {
        ClientReference.displayGuiScreen(new NotificationsGUIScreen());
    }

    public Map<Long, Notification> getNotifications() {
        return this.notifications;
    }

    public Notification getNotification(long id) {
        return this.notifications.get(id);
    }

    public void addNotification(Notification notification) {
        this.notifications.put(notification.getId(), notification);
        ClientReference.getClientPlayer().func_184185_a(OxygenSoundEffects.NOTIFICATION_RECEIVED.soundEvent, 1.0f, 1.0f);
        if (notification.getType() == EnumNotification.REQUEST && !OxygenHelperClient.getClientSettingBoolean(0)) {
            this.latestNotificationId = notification.getId();
        }
        ClientReference.delegateToClientThread(() -> MinecraftForge.EVENT_BUS.post((Event)new OxygenNotificationRecievedEvent(notification)));
    }

    public boolean pendingRequestExist() {
        return this.latestNotificationId != 0L;
    }

    public long getLatestRequestId() {
        return this.latestNotificationId;
    }

    public Notification getLatestRequest() {
        return this.notifications.get(this.latestNotificationId);
    }

    public void resetLatestRequestId() {
        this.latestNotificationId = 0L;
    }

    public void processNotifications() {
        OxygenHelperClient.addRoutineTask(() -> {
            Iterator<Notification> iterator = this.notifications.values().iterator();
            while (iterator.hasNext()) {
                Notification notification = iterator.next();
                if (!notification.isExpired()) continue;
                if (notification.getId() == this.latestNotificationId) {
                    this.latestNotificationId = 0L;
                }
                iterator.remove();
            }
        });
    }

    public void acceptKeyPressedSynced() {
        if (!ClientReference.hasActiveGUI() && this.pendingRequestExist()) {
            this.notifications.remove(this.latestNotificationId);
            OxygenMain.network().sendToServer(new SPRequestReply(EnumRequestReply.ACCEPT, this.latestNotificationId));
            this.resetLatestRequestId();
        }
    }

    public void rejectKeyPressedSynced() {
        if (!ClientReference.hasActiveGUI() && this.pendingRequestExist()) {
            this.notifications.remove(this.latestNotificationId);
            OxygenMain.network().sendToServer(new SPRequestReply(EnumRequestReply.REJECT, this.latestNotificationId));
            this.resetLatestRequestId();
        }
    }

    public void reset() {
        this.notifications.clear();
        this.latestNotificationId = 0L;
    }
}

