/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.elements;

import austeretony.alternateui.screen.core.GUIAdvancedElement;
import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.oxygen_core.client.OxygenManagerClient;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.gui.OxygenGUITextures;
import austeretony.oxygen_core.client.gui.elements.ActivityStatusGUIDDElement;
import austeretony.oxygen_core.client.gui.elements.CustomRectUtils;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.sound.OxygenSoundEffects;
import austeretony.oxygen_core.server.OxygenPlayerData;
import net.minecraft.client.renderer.GlStateManager;

public class ActivityStatusGUIDDList
extends GUISimpleElement<ActivityStatusGUIDDList> {
    private final ActivityStatusGUIDDElement[] elements;
    private ActivityStatusChangeListener statusChangeListener;
    private final int width;
    private final int height;
    private int previous = -1;
    private int current = -1;

    public ActivityStatusGUIDDList(int xPosition, int yPosition) {
        this.setPosition(xPosition, yPosition);
        this.setSize(14, 8);
        this.setTextScale(GUISettings.get().getSubTextScale());
        this.setDisplayText(OxygenHelperClient.getPlayerUsername());
        this.elements = new ActivityStatusGUIDDElement[OxygenPlayerData.EnumActivityStatus.values().length];
        int width = 0;
        int height = this.textHeight(this.getTextScale()) + 3;
        for (OxygenPlayerData.EnumActivityStatus status : OxygenPlayerData.EnumActivityStatus.values()) {
            int textWidth = this.textWidth(status.localizedName(), this.getTextScale());
            if (width != 0 && width >= textWidth) continue;
            width = textWidth + 6;
        }
        this.width = width;
        this.height = height * OxygenPlayerData.EnumActivityStatus.values().length;
        int index = 0;
        for (OxygenPlayerData.EnumActivityStatus status : OxygenPlayerData.EnumActivityStatus.values()) {
            ActivityStatusGUIDDElement element = new ActivityStatusGUIDDElement(status);
            element.initScreen(this.getScreen());
            element.setPosition(this.getX(), this.getY() + height * (index + 1) + 1);
            element.setSize(width, height);
            element.setTextScale(this.getTextScale() - 0.05f);
            this.elements[index++] = element;
            this.bind(element);
        }
        this.setDynamicBackgroundColor(GUISettings.get().getBaseGUIBackgroundColor(), GUISettings.get().getAdditionalGUIBackgroundColor(), 0);
        this.setTextDynamicColor(GUISettings.get().getEnabledTextColor(), GUISettings.get().getDisabledTextColor(), GUISettings.get().getHoveredTextColor());
        this.enableFull();
    }

    public void updateActivityStatus() {
        this.current = OxygenHelperClient.getPlayerActivityStatus().ordinal();
    }

    public void setActivityStatusChangeListener(ActivityStatusChangeListener listener) {
        this.statusChangeListener = listener;
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.isDragged()) {
                int size = this.elements.length;
                ActivityStatusGUIDDList.drawRect(-2, this.getHeight(), this.width + 2, this.getHeight() + this.height + 2, this.getEnabledBackgroundColor());
                CustomRectUtils.drawRect(-2.0, this.getHeight(), -1.6, this.getHeight() + this.height + 2, this.getDisabledBackgroundColor());
                CustomRectUtils.drawRect((double)this.width + 1.6, this.getHeight(), (double)this.width + 2.0, this.getHeight() + this.height + 2, this.getDisabledBackgroundColor());
                CustomRectUtils.drawRect(-2.0, this.getHeight(), (double)this.width + 2.0, (double)this.getHeight() + 0.4, this.getDisabledBackgroundColor());
                CustomRectUtils.drawRect(-2.0, (double)(this.getHeight() + this.height + 2) - 0.4, (double)this.width + 2.0, this.getHeight() + this.height + 2, this.getDisabledBackgroundColor());
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)4.0f, (float)((this.getHeight() - this.textHeight(this.getTextScale())) / 2), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 14.0f, 0.0f, this.getEnabledTextColor(), false);
            GlStateManager.func_179121_F();
            if (this.current != -1) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.mc.func_110434_K().func_110577_a(OxygenGUITextures.STATUS_ICONS);
                GUIAdvancedElement.drawCustomSizedTexturedRect(0, 1, this.current * 3, 0, 3, 3, 12, 3);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int iconU = 0;
            if (!this.isEnabled()) {
                iconU = 3;
            } else if (this.isHovered() && !this.isDragged()) {
                iconU = 6;
            }
            this.mc.func_110434_K().func_110577_a(OxygenGUITextures.SORT_DOWN_ICONS);
            GUIAdvancedElement.drawCustomSizedTexturedRect(6, 1, iconU, 0, 3, 3, 9, 3);
            GlStateManager.func_179121_F();
            if (this.isDragged()) {
                for (ActivityStatusGUIDDElement element : this.elements) {
                    element.draw(mouseX, mouseY);
                }
            }
        }
    }

    @Override
    public void mouseOver(int mouseX, int mouseY) {
        if (this.isEnabled()) {
            this.setHovered(mouseX >= this.getX() && mouseY >= this.getY() && mouseX <= this.getX() + (int)(this.getScale() * (float)this.getWidth()) && mouseY < this.getY() + (int)(this.getScale() * (float)(this.isDragged() ? this.getHeight() * (this.elements.length + 1) : this.getHeight())));
            if (this.isDragged()) {
                for (ActivityStatusGUIDDElement element : this.elements) {
                    element.mouseOver(mouseX, mouseY);
                }
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (flag && mouseButton == 0) {
            for (ActivityStatusGUIDDElement element : this.elements) {
                if (!element.mouseClicked(mouseX, mouseY, mouseButton)) continue;
                this.setDragged(false);
                element.setHovered(false);
                if (this.previous == -1 || this.previous != element.activityStatus.ordinal()) {
                    OxygenManagerClient.instance().getClientDataManager().changeActivityStatusSynced(element.activityStatus);
                    OxygenHelperClient.getPlayerSharedData().setByte(0, element.activityStatus.ordinal());
                }
                if (this.statusChangeListener != null) {
                    this.statusChangeListener.onChange(element.activityStatus);
                }
                this.current = this.previous = element.activityStatus.ordinal();
                this.mc.field_71439_g.func_184185_a(OxygenSoundEffects.CONTEXT_CLOSE.soundEvent, 0.5f, 1.0f);
                return true;
            }
        }
        if (flag && mouseButton == 0 && !this.isDragged()) {
            this.mc.field_71439_g.func_184185_a(OxygenSoundEffects.DROP_DOWN_LIST_OPEN.soundEvent, 0.5f, 1.0f);
        }
        this.setDragged(flag && mouseButton == 0);
        return false;
    }

    public static interface ActivityStatusChangeListener {
        public void onChange(OxygenPlayerData.EnumActivityStatus var1);
    }
}

