/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.elements;

import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.oxygen_core.client.gui.elements.CustomRectUtils;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.sound.OxygenSoundEffects;
import net.minecraft.client.renderer.GlStateManager;

public class OxygenGUIButton
extends GUISimpleElement<OxygenGUIButton> {
    private ClickListener clickListener;

    public OxygenGUIButton(int xPosition, int yPosition, int buttonWidth, int buttonHeight, String displayText) {
        this.setPosition(xPosition, yPosition);
        this.setSize(buttonWidth, buttonHeight);
        this.setTextScale(GUISettings.get().getButtonTextScale());
        this.setDisplayText(displayText, true, GUISettings.get().getButtonTextScale());
        this.setStaticBackgroundColor(GUISettings.get().getBaseGUIBackgroundColor());
        this.setDynamicBackgroundColor(GUISettings.get().getEnabledButtonColor(), GUISettings.get().getDisabledButtonColor(), GUISettings.get().getHoveredButtonColor());
        this.setTextDynamicColor(GUISettings.get().getEnabledTextColor(), GUISettings.get().getDisabledTextColor(), GUISettings.get().getHoveredTextColor());
        this.setSound(OxygenSoundEffects.BUTTON_CLICK.soundEvent);
        this.enableFull();
    }

    public void setClickListener(ClickListener clickListener) {
        this.clickListener = clickListener;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (flag) {
            if (this.clickListener != null) {
                this.clickListener.onClick(mouseX, mouseY, mouseButton);
            }
            this.screen.handleElementClick(this.screen.getWorkspace().getCurrentSection(), this);
            this.screen.getWorkspace().getCurrentSection().handleElementClick(this.screen.getWorkspace().getCurrentSection(), this, mouseButton);
            if (this.screen.getWorkspace().getCurrentSection().hasCurrentCallback()) {
                this.screen.getWorkspace().getCurrentSection().getCurrentCallback().handleElementClick(this.screen.getWorkspace().getCurrentSection(), this, mouseButton);
            }
        }
        return flag;
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int color = this.getEnabledBackgroundColor();
            if (!this.isEnabled()) {
                color = this.getDisabledBackgroundColor();
            } else if (this.isHovered() || this.isToggled()) {
                color = this.getHoveredBackgroundColor();
            }
            OxygenGUIButton.drawRect(0, 0, this.getWidth(), this.getHeight(), this.getStaticBackgroundColor());
            CustomRectUtils.drawRect(0.0, 0.0, 0.4, this.getHeight(), color);
            CustomRectUtils.drawRect((double)this.getWidth() - 0.4, 0.0, this.getWidth(), this.getHeight(), color);
            CustomRectUtils.drawRect(0.0, 0.0, this.getWidth(), 0.4, color);
            CustomRectUtils.drawRect(0.0, (double)this.getHeight() - 0.4, this.getWidth(), this.getHeight(), color);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((this.getWidth() - this.textWidth(this.getDisplayText(), this.getTextScale())) / 2), (float)((this.getHeight() - this.textHeight(this.getTextScale())) / 2), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            color = this.getEnabledTextColor();
            if (!this.isEnabled()) {
                color = this.getDisabledTextColor();
            } else if (this.isHovered() || this.isToggled()) {
                color = this.getHoveredTextColor();
            }
            this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 0.0f, 0.0f, color, false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }

    public static interface ClickListener {
        public void onClick(int var1, int var2, int var3);
    }
}

