/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.elements;

import austeretony.alternateui.screen.browsing.GUIScroller;
import austeretony.alternateui.screen.button.GUIButton;
import austeretony.alternateui.screen.button.GUISlider;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.panel.GUIButtonPanel;
import austeretony.alternateui.util.EnumGUIOrientation;
import austeretony.oxygen_core.client.gui.settings.GUISettings;

public class OxygenGUIButtonPanel
extends GUIButtonPanel {
    private ClickListener clickListener;
    private GUIButton previousButton;

    public OxygenGUIButtonPanel(AbstractGUIScreen screen, int xPosition, int yPosition, int buttonWidth, int buttonHeight, int buttonsOffset, int scrollerRows, int visibleScrollerRows, float textScale, boolean enableSlider) {
        super(EnumGUIOrientation.VERTICAL, xPosition, yPosition, buttonWidth, buttonHeight);
        this.initScreen(screen);
        this.setPosition(xPosition, yPosition);
        this.setButtonsOffset(buttonsOffset);
        GUIScroller scroller = new GUIScroller(scrollerRows, visibleScrollerRows);
        this.initScroller(scroller);
        GUISlider slider = new GUISlider(xPosition + buttonWidth + 1, yPosition, 2, visibleScrollerRows * buttonHeight + buttonsOffset * (visibleScrollerRows - 1));
        this.setSize(buttonWidth, slider.getSlidebarHeight());
        slider.setDynamicBackgroundColor(GUISettings.get().getEnabledSliderColor(), GUISettings.get().getDisabledSliderColor(), GUISettings.get().getHoveredSliderColor());
        scroller.initSlider(slider);
        if (!enableSlider) {
            slider.disableFull();
        }
        this.setSize(buttonWidth, buttonHeight * scroller.rowsVisible + this.getButtonsOffset() * (scroller.rowsVisible - 1));
        this.setTextScale(textScale);
        this.enableFull();
    }

    public <T> void setClickListener(ClickListener<T> listener) {
        this.clickListener = listener;
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY) {
        if (this.isVisible() && (!this.hasContextMenu() || this.hasContextMenu() && !this.getContextMenu().isDragged())) {
            for (GUIButton button : this.visibleButtons) {
                button.drawTooltip(mouseX, mouseY);
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.isEnabled()) {
            if (this.hasContextMenu() && this.getContextMenu().isDragged() && mouseButton != 1) {
                this.getContextMenu().mouseClicked(mouseX, mouseY, mouseButton);
            }
            for (GUIButton button : this.visibleButtons) {
                if (button.mouseClicked(mouseX, mouseY, mouseButton) && this.clickListener != null) {
                    this.clickListener.onClick(this.previousButton, button, mouseX, mouseY, mouseButton);
                    this.previousButton = button;
                }
                if (!button.isHovered() || mouseButton != 1 || !this.hasContextMenu() || this.getContextMenu().isDragged()) continue;
                this.getContextMenu().open(button, mouseX, mouseY);
            }
        }
        return false;
    }

    public static interface ClickListener<T> {
        public void onClick(T var1, T var2, int var3, int var4, int var5);
    }
}

