/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.elements;

import austeretony.alternateui.screen.contextmenu.GUIContextMenu;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.alternateui.util.GUISoundEffect;
import austeretony.oxygen_core.client.gui.elements.CustomRectUtils;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIContextMenuElement;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.sound.OxygenSoundEffects;
import net.minecraft.client.renderer.GlStateManager;

public class OxygenGUIContextMenu
extends GUIContextMenu {
    private final OxygenGUIContextMenuElement[] elements;
    private GUISoundEffect openSound;
    private GUISoundEffect closeSound;
    private GUIBaseElement currentElement;

    public OxygenGUIContextMenu(int width, int height, OxygenGUIContextMenuElement.ContextMenuAction ... actions) {
        super(0, 0);
        this.openSound = new GUISoundEffect(OxygenSoundEffects.CONTEXT_OPEN.soundEvent, 0.5f, 1.0f);
        this.closeSound = new GUISoundEffect(OxygenSoundEffects.CONTEXT_CLOSE.soundEvent, 0.5f, 1.0f);
        this.elements = new OxygenGUIContextMenuElement[actions.length];
        int index = 0;
        for (OxygenGUIContextMenuElement.ContextMenuAction action : actions) {
            int n = index++;
            OxygenGUIContextMenuElement oxygenGUIContextMenuElement = new OxygenGUIContextMenuElement(width, height, action);
            this.elements[n] = oxygenGUIContextMenuElement;
            this.bind(oxygenGUIContextMenuElement);
        }
        this.setSize(width, height * actions.length);
        this.setDynamicBackgroundColor(GUISettings.get().getBaseGUIBackgroundColor(), GUISettings.get().getAdditionalGUIBackgroundColor(), 0);
    }

    @Override
    public void drawContextMenu(int mouseX, int mouseY) {
        if (this.isEnabled()) {
            for (OxygenGUIContextMenuElement element : this.elements) {
                element.mouseOver(mouseX, mouseY);
            }
            this.setHovered(this.isEnabled() && mouseX >= this.getX() && mouseY >= this.getY() && (float)mouseX < (float)this.getX() + (float)this.getWidth() * this.getScale() && mouseY < this.getY() + this.getHeight());
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            OxygenGUIContextMenu.drawRect(0, 0, this.getWidth(), this.getHeight(), this.getEnabledBackgroundColor());
            CustomRectUtils.drawRect(0.0, 0.0, 0.4, this.getHeight(), this.getDisabledBackgroundColor());
            CustomRectUtils.drawRect((double)this.getWidth() - 0.4, 0.0, this.getWidth(), this.getHeight(), this.getDisabledBackgroundColor());
            CustomRectUtils.drawRect(0.0, -0.4, this.getWidth(), 0.0, this.getDisabledBackgroundColor());
            CustomRectUtils.drawRect(0.0, this.getHeight(), this.getWidth(), (float)this.getHeight() - 0.4f, this.getDisabledBackgroundColor());
            GlStateManager.func_179121_F();
            for (OxygenGUIContextMenuElement element : this.elements) {
                element.draw(mouseX, mouseY);
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag = this.isHovered();
        if (flag && mouseButton == 0) {
            for (OxygenGUIContextMenuElement element : this.elements) {
                if (!element.mouseClicked(mouseX, mouseY, mouseButton)) continue;
                element.action.execute(this.currentElement);
                element.setHovered(false);
                this.close();
                return true;
            }
        } else {
            this.close();
        }
        return false;
    }

    @Override
    public void open(GUIBaseElement element, int mouseX, int mouseY) {
        if (this.elements.length != 0) {
            this.setPosition(mouseX, mouseY);
            int index = 0;
            for (OxygenGUIContextMenuElement action : this.elements) {
                this.currentElement = element;
                action.setDisplayText(action.action.getName(element));
                action.setPosition(this.getX(), this.getY() + index * action.getHeight());
                if (action.action.isValid(element)) {
                    action.setEnabled(true);
                }
                action.setVisible(true);
                ++index;
            }
            this.setDragged(true);
            this.enableFull();
            if (this.openSound != null) {
                this.mc.field_71439_g.func_184185_a(this.openSound.sound, this.openSound.volume, this.openSound.pitch);
            }
        }
    }

    @Override
    public void close() {
        this.setDragged(false);
        this.disableFull();
        for (OxygenGUIContextMenuElement action : this.elements) {
            action.disableFull();
        }
        if (this.closeSound != null) {
            this.mc.field_71439_g.func_184185_a(this.closeSound.sound, this.closeSound.volume, this.closeSound.pitch);
        }
    }
}

