/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.elements;

import austeretony.alternateui.screen.core.GUIAdvancedElement;
import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.oxygen_core.client.gui.OxygenGUITextures;
import austeretony.oxygen_core.client.gui.elements.CustomRectUtils;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.sound.OxygenSoundEffects;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class OxygenSorterGUIElement
extends GUISimpleElement<OxygenSorterGUIElement> {
    private ClickListener clickListener;
    private EnumSorting currentSorting;

    public OxygenSorterGUIElement(int xPosition, int yPosition, EnumSorting sorting, String tooltip) {
        this.setPosition(xPosition, yPosition);
        this.setSize(3, 3);
        this.currentSorting = sorting;
        this.setSound(OxygenSoundEffects.BUTTON_CLICK.soundEvent);
        this.setDynamicBackgroundColor(GUISettings.get().getBaseGUIBackgroundColor(), GUISettings.get().getAdditionalGUIBackgroundColor(), 0);
        if (!tooltip.isEmpty()) {
            this.initTooltip(tooltip, GUISettings.get().getTooltipTextColor(), 0, GUISettings.get().getTooltipScale());
        }
        if (sorting != EnumSorting.INACTIVE) {
            this.setToggled(true);
        }
        this.enableFull();
    }

    public OxygenSorterGUIElement(int xPosition, int yPosition, String tooltip) {
        this(xPosition, yPosition, EnumSorting.INACTIVE, tooltip);
    }

    public void setClickListener(ClickListener clickListener) {
        this.clickListener = clickListener;
    }

    public void reset() {
        this.currentSorting = EnumSorting.INACTIVE;
        this.setToggled(false);
    }

    public void setSorting(EnumSorting sorting) {
        this.currentSorting = sorting;
        this.setToggled(true);
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ResourceLocation icon = null;
            switch (this.currentSorting) {
                case UP: {
                    icon = OxygenGUITextures.SORT_UP_ICONS;
                    break;
                }
                case DOWN: 
                case INACTIVE: {
                    icon = OxygenGUITextures.SORT_DOWN_ICONS;
                }
            }
            int iconU = 0;
            if (!this.isEnabled()) {
                iconU = 3;
            } else if (this.isHovered() || this.isToggled()) {
                iconU = 6;
            }
            GlStateManager.func_179147_l();
            this.mc.func_110434_K().func_110577_a(icon);
            GUIAdvancedElement.drawCustomSizedTexturedRect(0, 0, iconU, 0, 3, 3, 9, 3);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY) {
        if (this.isVisible() && this.isHovered() && this.hasTooltip()) {
            float scale = this.getTooltipScaleFactor();
            int width = this.textWidth(this.getTooltipText(), scale) + 6;
            int height = 12;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)(this.getX() + this.getWidth() / 2) - scale * (float)(width / 2)), (float)((float)this.getY() - scale * (float)height - 2.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            OxygenSorterGUIElement.drawRect(0, 0, width, height, this.getEnabledBackgroundColor());
            CustomRectUtils.drawRect(0.0, 0.0, 0.4, height, this.getDisabledBackgroundColor());
            CustomRectUtils.drawRect((double)width - 0.4, 0.0, width, height, this.getDisabledBackgroundColor());
            CustomRectUtils.drawRect(0.0, 0.0, width, 0.4, this.getDisabledBackgroundColor());
            CustomRectUtils.drawRect(0.0, (double)height - 0.4, width, height, this.getDisabledBackgroundColor());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((width - this.textWidth(this.getTooltipText(), scale)) / 2), (float)((height - this.textHeight(scale)) / 2 + 1), (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.getTooltipText(), 0.0f, 0.0f, this.getTooltipTextColor(), false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (flag) {
            EnumSorting newSorting = EnumSorting.INACTIVE;
            switch (this.currentSorting) {
                case UP: {
                    newSorting = EnumSorting.DOWN;
                    break;
                }
                case DOWN: 
                case INACTIVE: {
                    newSorting = EnumSorting.UP;
                }
            }
            this.currentSorting = this.isToggled() ? newSorting : EnumSorting.DOWN;
            this.setToggled(true);
            if (this.clickListener != null) {
                this.clickListener.onClick(this.currentSorting);
            }
            this.screen.handleElementClick(this.screen.getWorkspace().getCurrentSection(), this);
            this.screen.getWorkspace().getCurrentSection().handleElementClick(this.screen.getWorkspace().getCurrentSection(), this, mouseButton);
            if (this.screen.getWorkspace().getCurrentSection().hasCurrentCallback()) {
                this.screen.getWorkspace().getCurrentSection().getCurrentCallback().handleElementClick(this.screen.getWorkspace().getCurrentSection(), this, mouseButton);
            }
        }
        return flag;
    }

    public EnumSorting getCurrentSorting() {
        return this.currentSorting;
    }

    public static interface ClickListener {
        public void onClick(EnumSorting var1);
    }

    public static enum EnumSorting {
        INACTIVE,
        UP,
        DOWN;

    }
}

