/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.elements;

import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIAdvancedElement;
import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.oxygen_core.client.gui.OxygenGUITextures;
import austeretony.oxygen_core.client.gui.elements.CustomRectUtils;
import austeretony.oxygen_core.client.gui.elements.SectionsGUIDDListElement;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.sound.OxygenSoundEffects;
import net.minecraft.client.renderer.GlStateManager;

public class SectionsGUIDDList
extends GUISimpleElement<SectionsGUIDDList> {
    private final SectionsGUIDDListElement[] elements;
    private SectionChangeListener sectionChangeListener;

    public SectionsGUIDDList(int xPosition, int yPosition, AbstractGUISection ... sections) {
        this.setTextScale(GUISettings.get().getTextScale());
        this.setDisplayText(sections[0].getDisplayText());
        int width = 0;
        for (AbstractGUISection section : sections) {
            int textWidth = this.textWidth(section.getDisplayText(), this.getTextScale());
            if (width != 0 && width >= textWidth) continue;
            width = textWidth;
        }
        this.setSize(width + 8, 9);
        this.setPosition(xPosition - this.getWidth() - 1, yPosition);
        this.elements = new SectionsGUIDDListElement[sections.length];
        int index = 0;
        for (AbstractGUISection section : sections) {
            int n = index++;
            SectionsGUIDDListElement sectionsGUIDDListElement = new SectionsGUIDDListElement(this.getX(), this.getY() + index * 9, this.getWidth(), 9, section);
            this.elements[n] = sectionsGUIDDListElement;
            this.bind(sectionsGUIDDListElement);
        }
        this.setDynamicBackgroundColor(GUISettings.get().getBaseGUIBackgroundColor(), GUISettings.get().getAdditionalGUIBackgroundColor(), 0);
        this.setTextDynamicColor(GUISettings.get().getEnabledTextColor(), GUISettings.get().getDisabledTextColor(), GUISettings.get().getHoveredTextColor());
        this.enableFull();
    }

    public void setSectionChangeListener(SectionChangeListener listener) {
        this.sectionChangeListener = listener;
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.isDragged()) {
                int size = this.elements.length + 1;
                SectionsGUIDDList.drawRect(0, this.getHeight(), this.getWidth(), this.getHeight() * size, this.getEnabledBackgroundColor());
                CustomRectUtils.drawRect(0.0, this.getHeight(), 0.4, (double)(this.getHeight() * size) - 0.4, this.getDisabledBackgroundColor());
                CustomRectUtils.drawRect((double)this.getWidth() - 0.4, this.getHeight(), this.getWidth(), (double)(this.getHeight() * size) - 0.4, this.getDisabledBackgroundColor());
                CustomRectUtils.drawRect(0.0, (double)this.getHeight() - 0.4, this.getWidth(), this.getHeight(), this.getDisabledBackgroundColor());
                CustomRectUtils.drawRect(0.0, (double)(this.getHeight() * size) - 0.4, this.getWidth(), this.getHeight() * size, this.getDisabledBackgroundColor());
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)4.0f, (float)((this.getHeight() - this.textHeight(this.getTextScale())) / 2), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int iconU = 0;
            int textColor = this.getEnabledTextColor();
            if (!this.isEnabled()) {
                iconU = 3;
                textColor = this.getDisabledTextColor();
            } else if (this.isHovered() && !this.isDragged()) {
                iconU = 6;
                textColor = this.getHoveredTextColor();
            }
            this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 0.0f, 0.0f, textColor, false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(OxygenGUITextures.SORT_DOWN_ICONS);
            GUIAdvancedElement.drawCustomSizedTexturedRect(this.textWidth(this.getDisplayText(), this.getTextScale()) + 6, (this.getHeight() - 3) / 2, iconU, 0, 3, 3, 9, 3);
            GlStateManager.func_179121_F();
            if (this.isDragged()) {
                for (SectionsGUIDDListElement element : this.elements) {
                    element.draw(mouseX, mouseY);
                }
            }
        }
    }

    @Override
    public void mouseOver(int mouseX, int mouseY) {
        if (this.isEnabled()) {
            this.setHovered(mouseX >= this.getX() && mouseY >= this.getY() && mouseX <= this.getX() + (int)(this.getScale() * (float)this.getWidth()) && mouseY < this.getY() + (int)(this.getScale() * (float)(this.isDragged() ? this.getHeight() * (this.elements.length + 1) : this.getHeight())));
            if (this.isDragged()) {
                for (SectionsGUIDDListElement element : this.elements) {
                    element.mouseOver(mouseX, mouseY);
                }
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (flag && mouseButton == 0) {
            for (SectionsGUIDDListElement element : this.elements) {
                if (!element.mouseClicked(mouseX, mouseY, mouseButton)) continue;
                this.setDragged(false);
                element.setHovered(false);
                if (this.sectionChangeListener != null) {
                    this.sectionChangeListener.onChange(element.section);
                }
                if (this.screen.getWorkspace().getCurrentSection() != element.section) {
                    element.section.open();
                }
                this.mc.field_71439_g.func_184185_a(OxygenSoundEffects.CONTEXT_CLOSE.soundEvent, 0.5f, 1.0f);
                return true;
            }
        }
        if (flag && mouseButton == 0 && !this.isDragged()) {
            this.mc.field_71439_g.func_184185_a(OxygenSoundEffects.DROP_DOWN_LIST_OPEN.soundEvent, 0.5f, 1.0f);
        }
        this.setDragged(flag && mouseButton == 0);
        return false;
    }

    public static interface SectionChangeListener {
        public void onChange(AbstractGUISection var1);
    }
}

