/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.elements;

import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.gui.elements.CustomRectUtils;
import austeretony.oxygen_core.client.gui.elements.OxygenGUITextField;
import austeretony.oxygen_core.client.gui.elements.UsernameGUIElement;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.PlayerSharedData;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.client.renderer.GlStateManager;

public class UsernameGUITextField
extends OxygenGUITextField {
    private final Set<String> usernames = new TreeSet<String>();
    private UsernameGUIElement[] elements = new UsernameGUIElement[5];
    private int elementsAmount;
    private int baseColorHex = GUISettings.get().getBaseGUIBackgroundColor();
    private int additionalColorHex = GUISettings.get().getAdditionalGUIBackgroundColor();
    private UsernameSelectListener selectListener;
    private boolean active;

    public UsernameGUITextField(int xPosition, int yPosition, int width) {
        super(xPosition, yPosition, width, 8, 24, "", 3, false, -1L);
        this.cancelDraggedElementLogic(false);
    }

    public void setUsernameSelectListener(UsernameSelectListener listener) {
        this.selectListener = listener;
    }

    public void load() {
        for (PlayerSharedData sharedData : OxygenHelperClient.getPlayersSharedData()) {
            this.usernames.add(sharedData.getUsername());
        }
        this.usernames.remove(OxygenHelperClient.getPlayerUsername());
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        super.draw(mouseX, mouseY);
        if (this.isDragged() && this.active) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            UsernameGUITextField.drawRect(0, this.getHeight(), this.getWidth(), (this.getHeight() + 1) * (this.elementsAmount + 1), this.baseColorHex);
            CustomRectUtils.drawRect(0.0, (double)this.getHeight() + 1.0, 0.4, ((double)this.getHeight() + 1.0) * (double)(this.elementsAmount + 1) - 0.4, this.additionalColorHex);
            CustomRectUtils.drawRect((double)this.getWidth() - 0.4, (double)this.getHeight() + 1.0, this.getWidth(), ((double)this.getHeight() + 1.0) * (double)(this.elementsAmount + 1) - 0.4, this.additionalColorHex);
            CustomRectUtils.drawRect(0.0, (double)this.getHeight() + 0.4, this.getWidth(), (double)this.getHeight() + 1.0, this.additionalColorHex);
            CustomRectUtils.drawRect(0.0, ((double)this.getHeight() + 1.0) * (double)(this.elementsAmount + 1) - 0.4, this.getWidth(), ((double)this.getHeight() + 1.0) * (double)(this.elementsAmount + 1), this.additionalColorHex);
            GlStateManager.func_179121_F();
            for (UsernameGUIElement element : this.elements) {
                if (element == null) continue;
                element.draw(mouseX, mouseY);
            }
        }
    }

    @Override
    public void mouseOver(int mouseX, int mouseY) {
        if (this.isEnabled()) {
            super.mouseOver(mouseX, mouseY);
            if (this.isDragged() && this.active) {
                for (UsernameGUIElement element : this.elements) {
                    if (element == null) continue;
                    element.mouseOver(mouseX, mouseY);
                }
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.active && mouseButton == 0) {
            for (UsernameGUIElement element : this.elements) {
                if (element == null || !element.mouseClicked(mouseX, mouseY, mouseButton)) continue;
                this.setText(element.getDisplayText());
                this.setDragged(false);
                element.setHovered(false);
                if (this.selectListener != null) {
                    this.selectListener.onSelect(OxygenHelperClient.getPlayerSharedData(element.getDisplayText()));
                }
                this.active = false;
            }
        }
        return flag;
    }

    private void resetElements() {
        for (int i = 0; i < 5; ++i) {
            this.unbind(this.elements[i]);
            this.elements[i] = null;
        }
    }

    @Override
    public boolean keyTyped(char keyChar, int keyCode) {
        boolean flag = super.keyTyped(keyChar, keyCode);
        if (flag) {
            String typed = this.getTypedText().toLowerCase();
            if (!typed.isEmpty()) {
                this.resetElements();
                int index = 0;
                for (String username : this.usernames) {
                    if (index > 4) break;
                    String formatted = username.toLowerCase();
                    if (!formatted.startsWith(typed)) continue;
                    this.elements[index] = new UsernameGUIElement(this.getX(), this.getY() + (this.getHeight() + 1) * (index + 1), this.getWidth(), this.getHeight(), username);
                    this.bind(this.elements[index]);
                    ++index;
                }
                this.elementsAmount = index;
                this.active = index > 0;
            } else {
                this.active = false;
            }
        }
        return flag;
    }

    public static interface UsernameSelectListener {
        public void onSelect(PlayerSharedData var1);
    }
}

