/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.gui.overlay;

import austeretony.alternateui.screen.core.GUISimpleElement;
import austeretony.oxygen_core.client.OxygenManagerClient;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.gui.elements.CustomRectUtils;
import austeretony.oxygen_core.client.gui.overlay.Overlay;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.client.input.OxygenKeyHandler;
import austeretony.oxygen_core.common.notification.Notification;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;

public class RequestOverlay
implements Overlay {
    private Notification notification;

    @Override
    public boolean shouldDraw() {
        return OxygenManagerClient.instance().getNotificationsManager() != null && OxygenManagerClient.instance().getNotificationsManager().pendingRequestExist();
    }

    @Override
    public boolean drawWhileInGUI() {
        return false;
    }

    @Override
    public void draw(float partialTicks) {
        this.notification = OxygenManagerClient.instance().getNotificationsManager().getLatestRequest();
        if (this.notification == null) {
            return;
        }
        Minecraft mc = ClientReference.getMinecraft();
        ScaledResolution scaledResolution = new ScaledResolution(mc);
        String request = ClientReference.localize(this.notification.getDescription(), this.notification.getArguments());
        String acceptKeyName = OxygenKeyHandler.ACCEPT.getDisplayName();
        String rejectKeyName = OxygenKeyHandler.REJECT.getDisplayName();
        int requestWidth = (int)((float)mc.field_71466_p.func_78256_a(request) * GUISettings.get().getOverlayScale());
        int x = (scaledResolution.func_78326_a() - requestWidth) / 2;
        int y = scaledResolution.func_78328_b() / 2 + 25;
        int acceptKeyNameWidth = mc.field_71466_p.func_78256_a(acceptKeyName);
        int rejectKeyNameWidth = mc.field_71466_p.func_78256_a(rejectKeyName);
        int frameWidth = acceptKeyNameWidth + 6;
        int frameHeight = 12;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)GUISettings.get().getOverlayScale(), (float)GUISettings.get().getOverlayScale(), (float)0.0f);
        mc.field_71466_p.func_175065_a(request, 0.0f, 0.0f, GUISettings.get().getAdditionalOverlayTextColor(), true);
        this.drawKeyFrame(0, 12, frameWidth, frameHeight);
        mc.field_71466_p.func_78276_b(acceptKeyName, 3, 15, GUISettings.get().getAdditionalOverlayTextColor());
        mc.field_71466_p.func_175065_a(ClientReference.localize("oxygen.request.accept", new Object[0]), (float)(10 + acceptKeyNameWidth), 15.0f, GUISettings.get().getBaseOverlayTextColor(), true);
        this.drawKeyFrame(0, 26, frameWidth, frameHeight);
        mc.field_71466_p.func_78276_b(rejectKeyName, 3, 29, GUISettings.get().getAdditionalOverlayTextColor());
        mc.field_71466_p.func_175065_a(ClientReference.localize("oxygen.request.reject", new Object[0]), (float)(10 + rejectKeyNameWidth), 29.0f, GUISettings.get().getBaseOverlayTextColor(), true);
        mc.field_71466_p.func_175065_a("(" + String.valueOf((this.notification.getExpirationTimeStamp() - System.currentTimeMillis()) / 1000L) + ")", 0.0f, 43.0f, GUISettings.get().getAdditionalOverlayTextColor(), true);
        GlStateManager.func_179121_F();
    }

    private void drawKeyFrame(int x, int y, int width, int height) {
        GUISimpleElement.drawRect(x, y, x + width, y + height, GUISettings.get().getBaseGUIBackgroundColor());
        CustomRectUtils.drawRect(x, y, (double)x + 0.4, y + height, GUISettings.get().getAdditionalGUIBackgroundColor());
        CustomRectUtils.drawRect((double)(x + width) - 0.4, y, x + width, y + height, GUISettings.get().getAdditionalGUIBackgroundColor());
        CustomRectUtils.drawRect(x, y, x + width, (double)y + 0.4, GUISettings.get().getAdditionalGUIBackgroundColor());
        CustomRectUtils.drawRect(x, (double)(y + height) - 0.4, x + width, y + height, GUISettings.get().getAdditionalGUIBackgroundColor());
    }
}

